/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.blocks;

import com.telepathicgrunt.the_bumblezone.entities.mobs.BeehemothEntity;
import com.telepathicgrunt.the_bumblezone.entities.nonliving.PollenPuffEntity;
import com.telepathicgrunt.the_bumblezone.items.HoneyBeeLeggings;
import com.telepathicgrunt.the_bumblezone.mixin.blocks.FallingBlockEntityAccessor;
import com.telepathicgrunt.the_bumblezone.mixin.entities.BeeEntityInvoker;
import com.telepathicgrunt.the_bumblezone.modinit.BzBlocks;
import com.telepathicgrunt.the_bumblezone.modinit.BzCriterias;
import com.telepathicgrunt.the_bumblezone.modinit.BzEffects;
import com.telepathicgrunt.the_bumblezone.modinit.BzItems;
import com.telepathicgrunt.the_bumblezone.modinit.BzParticles;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.animal.Panda;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.DirectionalPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PileOfPollen
extends FallingBlock {
    public static final IntegerProperty LAYERS = BlockStateProperties.f_61417_;
    protected static final VoxelShape[] SHAPE_BY_LAYER = new VoxelShape[]{Shapes.m_83040_(), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)};
    protected static final AABB[] SHAPE_AABB_BY_LAYER = new AABB[]{AABB.m_165882_((Vec3)new Vec3(0.0, 0.0, 0.0), (double)0.0, (double)0.0, (double)0.0), SHAPE_BY_LAYER[1].m_83215_().m_82400_((double)0.1f), SHAPE_BY_LAYER[2].m_83215_().m_82400_((double)0.1f), SHAPE_BY_LAYER[3].m_83215_().m_82400_((double)0.1f), SHAPE_BY_LAYER[4].m_83215_().m_82400_((double)0.1f), SHAPE_BY_LAYER[5].m_83215_().m_82400_((double)0.1f), SHAPE_BY_LAYER[6].m_83215_().m_82400_((double)0.1f), SHAPE_BY_LAYER[7].m_83215_().m_82400_((double)0.1f), SHAPE_BY_LAYER[8].m_83215_().m_82400_((double)0.1f)};
    private Item item;

    public PileOfPollen() {
        super(BlockBehaviour.Properties.m_60939_((Material)BzBlocks.YELLOW_NOT_SOLID).m_60971_((blockState, world, blockPos) -> true).m_60955_().m_60978_(0.1f).m_60918_(SoundType.f_56747_));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> blockStateBuilder) {
        blockStateBuilder.m_61104_(new Property[]{LAYERS});
    }

    public ItemStack m_7397_(BlockGetter world, BlockPos blockPos, BlockState blockState) {
        return new ItemStack((ItemLike)BzItems.POLLEN_PUFF.get());
    }

    public Item m_5456_() {
        if (this.item == null) {
            this.item = BzItems.POLLEN_PUFF.get();
        }
        return this.item;
    }

    public boolean m_7357_(BlockState blockState, BlockGetter world, BlockPos blockPos, PathComputationType pathType) {
        return true;
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter world, BlockPos blockPos, CollisionContext selectionContext) {
        return SHAPE_BY_LAYER[(Integer)blockState.m_61143_((Property)LAYERS)];
    }

    public static AABB getAABBShape(BlockState blockState) {
        return SHAPE_AABB_BY_LAYER[(Integer)blockState.m_61143_((Property)LAYERS)];
    }

    public VoxelShape m_5939_(BlockState blockState, BlockGetter world, BlockPos blockPos, CollisionContext selectionContext) {
        return Shapes.m_83040_();
    }

    public VoxelShape m_7947_(BlockState blockState, BlockGetter world, BlockPos blockPos) {
        return SHAPE_BY_LAYER[(Integer)blockState.m_61143_((Property)LAYERS)];
    }

    public VoxelShape m_5909_(BlockState blockState, BlockGetter world, BlockPos blockPos, CollisionContext selectionContext) {
        return SHAPE_BY_LAYER[(Integer)blockState.m_61143_((Property)LAYERS)];
    }

    public boolean m_7923_(BlockState blockState) {
        return true;
    }

    public boolean m_7898_(BlockState blockState, LevelReader world, BlockPos blockPos) {
        BlockState blockstate = world.m_8055_(blockPos.m_7495_());
        if (blockstate.m_60713_(Blocks.f_50126_) || blockstate.m_60713_(Blocks.f_50354_) || blockstate.m_60713_(Blocks.f_50375_) || !world.m_8055_(blockPos).m_60819_().m_76178_()) {
            return false;
        }
        if (blockstate.m_60795_() || blockstate.m_60713_(BzBlocks.PILE_OF_POLLEN.get()) || blockstate.m_60713_(Blocks.f_50719_) || blockstate.m_60713_(Blocks.f_50135_)) {
            return true;
        }
        return Block.m_49918_((VoxelShape)blockstate.m_60812_((BlockGetter)world, blockPos.m_7495_()), (Direction)Direction.UP);
    }

    public BlockState m_7417_(BlockState oldBlockState, Direction direction, BlockState newBlockState, LevelAccessor world, BlockPos blockPos, BlockPos blockPos1) {
        return !oldBlockState.m_60710_((LevelReader)world, blockPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(oldBlockState, direction, newBlockState, world, blockPos, blockPos1);
    }

    public void m_213897_(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, RandomSource random) {
        if (PileOfPollen.canFall(serverLevel.m_8055_(blockPos.m_7495_())) && blockPos.m_123342_() >= serverLevel.m_141937_()) {
            FallingBlockEntity fallingblockentity = new FallingBlockEntity((Level)serverLevel, (double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_(), (double)blockPos.m_123343_() + 0.5, serverLevel.m_8055_(blockPos));
            serverLevel.m_7731_(blockPos, Blocks.f_50016_.m_49966_(), 3);
            this.m_6788_(fallingblockentity);
            serverLevel.m_7967_((Entity)fallingblockentity);
        }
    }

    private static boolean canFall(BlockState blockState) {
        Material material = blockState.m_60767_();
        boolean isFullPollenPile = blockState.m_60713_(BzBlocks.PILE_OF_POLLEN.get()) && (Integer)blockState.m_61143_((Property)LAYERS) == 8;
        return !isFullPollenPile && (blockState.m_60795_() || blockState.m_204336_(BlockTags.f_13076_) || material.m_76332_() || material.m_76336_());
    }

    public boolean m_6864_(BlockState blockState, BlockPlaceContext itemPlacementContext) {
        int layerValue = (Integer)blockState.m_61143_((Property)LAYERS);
        if (itemPlacementContext.m_43722_().m_41720_() == this.m_5456_() && layerValue < 8) {
            if (!(itemPlacementContext instanceof DirectionalPlaceContext) && itemPlacementContext.m_7058_()) {
                return itemPlacementContext.m_43719_() == Direction.UP;
            }
            return true;
        }
        return layerValue == 1;
    }

    public BlockState m_5573_(BlockPlaceContext itemPlacementContext) {
        BlockState blockState = itemPlacementContext.m_43725_().m_8055_(itemPlacementContext.m_8083_());
        if (blockState.m_60713_((Block)this)) {
            int layerValue = (Integer)blockState.m_61143_((Property)LAYERS);
            return (BlockState)blockState.m_61124_((Property)LAYERS, (Comparable)Integer.valueOf(Math.min(8, layerValue + 1)));
        }
        return super.m_5573_(itemPlacementContext);
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState blockState, Level worldIn, BlockPos pos) {
        return (Integer)blockState.m_61143_((Property)LAYERS);
    }

    public void m_6786_(LevelAccessor world, BlockPos blockPos, BlockState blockState) {
        if (world.m_5776_()) {
            for (int i = 0; i < 50; ++i) {
                PileOfPollen.spawnParticles(blockState, world, blockPos, world.m_213780_(), true);
                PileOfPollen.spawnParticles(world, Vec3.m_82512_((Vec3i)blockPos), world.m_213780_(), 0.055, 0.0075, 0.0);
            }
        }
    }

    public void m_7892_(BlockState blockState, Level world, BlockPos blockPos, Entity entity) {
        if (!blockState.m_60713_(BzBlocks.PILE_OF_POLLEN.get())) {
            return;
        }
        if (entity instanceof FallingBlockEntity) {
            if (((FallingBlockEntity)entity).m_31980_().m_60795_() || world.m_5776_()) {
                return;
            }
            if (((FallingBlockEntity)entity).m_31980_().m_60713_(BzBlocks.PILE_OF_POLLEN.get())) {
                PileOfPollen.stackPollen(blockState, world, blockPos, ((FallingBlockEntity)entity).m_31980_());
                entity.m_146870_();
                ((FallingBlockEntityAccessor)entity).setBlockState(Blocks.f_50016_.m_49966_());
            } else {
                world.m_7731_(blockPos, Blocks.f_50016_.m_49966_(), 3);
                if (world.m_5776_()) {
                    for (int i = 0; i < (Integer)blockState.m_61143_((Property)LAYERS) * 30; ++i) {
                        PileOfPollen.spawnParticles(blockState, (LevelAccessor)world, blockPos, world.f_46441_, true);
                    }
                }
            }
        } else if (entity instanceof PollenPuffEntity) {
            PollenPuffEntity pollenPuffEntity = (PollenPuffEntity)entity;
            if (pollenPuffEntity.isConsumed() || !GeneralUtils.isPermissionAllowedAtSpot(world, pollenPuffEntity.m_19749_(), blockPos, true)) {
                return;
            }
            PileOfPollen.stackPollen(blockState, world, blockPos, BzBlocks.PILE_OF_POLLEN.get().m_49966_());
            pollenPuffEntity.m_142687_(Entity.RemovalReason.DISCARDED);
            pollenPuffEntity.consumed();
            if (world.m_5776_()) {
                for (int i = 0; i < 50; ++i) {
                    PileOfPollen.spawnParticles((LevelAccessor)world, pollenPuffEntity.m_20182_(), world.f_46441_, 0.055, 0.0075, 0.0);
                }
            }
        } else if (!(entity instanceof ExperienceOrb)) {
            LivingEntity livingEntity;
            double entitySpeed;
            int layerValueMinusOne = (Integer)blockState.m_61143_((Property)LAYERS) - 1;
            double speedReduction = entity instanceof Projectile ? 0.85 : 1.0 - (double)layerValueMinusOne * 0.1;
            double chance = 0.22 + (double)layerValueMinusOne * 0.09;
            ItemStack beeLeggings = HoneyBeeLeggings.getEntityBeeLegging(entity);
            if (!beeLeggings.m_41619_()) {
                speedReduction = Math.max(0.9, speedReduction);
            }
            Vec3 deltaMovement = entity.m_20184_();
            double newYDelta = deltaMovement.f_82480_;
            if (entity instanceof ServerPlayer && entity.f_19789_ > 18.0f && newYDelta < -0.9 && (Integer)blockState.m_61143_((Property)LAYERS) >= 7) {
                BzCriterias.FALLING_ON_POLLEN_BLOCK_TRIGGER.trigger((ServerPlayer)entity);
            }
            newYDelta = deltaMovement.f_82480_ > 0.0 ? (newYDelta *= 1.0 - (double)layerValueMinusOne * 0.01) : (newYDelta *= 0.84 - (double)layerValueMinusOne * 0.03);
            if (!(entity instanceof Bee) && !(entity instanceof BeehemothEntity)) {
                entity.m_20256_(new Vec3(deltaMovement.f_82479_ * speedReduction, newYDelta, deltaMovement.f_82481_ * speedReduction));
            }
            if ((entitySpeed = entity.m_20184_().m_82553_()) > 1.0E-5 && (double)world.f_46441_.m_188501_() < chance) {
                int particleStrength;
                int particleNumber = (int)(entitySpeed / 0.0045);
                int n = particleStrength = entity instanceof ItemEntity ? Math.min(10, particleNumber / 3) : Math.min(20, particleNumber);
                if (world.m_5776_()) {
                    for (int i = 0; i < particleNumber; ++i) {
                        if (particleNumber > 5) {
                            PileOfPollen.spawnParticles(blockState, (LevelAccessor)world, blockPos, world.f_46441_, true);
                        }
                        PileOfPollen.spawnParticles((LevelAccessor)world, entity.m_20182_().m_82549_(entity.m_20184_().m_82542_(2.0, 2.0, 2.0)).m_82520_(0.0, 0.75, 0.0), world.f_46441_, 0.006 * (double)particleStrength, 7.5E-4 * (double)particleStrength, 0.006 * (double)particleStrength);
                    }
                } else if (!(entity instanceof Player) && !(entity instanceof ItemEntity)) {
                    PileOfPollen.spawnParticlesServer((LevelAccessor)world, entity.m_20182_().m_82549_(entity.m_20184_().m_82542_(2.0, 2.0, 2.0)).m_82520_(0.0, 0.75, 0.0), world.f_46441_, 0.006 * (double)particleStrength, 7.5E-4 * (double)particleStrength, 0.006 * (double)particleStrength, particleNumber);
                }
            }
            if (entity instanceof Bee && !((Bee)entity).m_27856_() && entity.m_6095_().m_204039_(BzTags.POLLEN_PUFF_CAN_POLLINATE)) {
                ((BeeEntityInvoker)entity).callSetHasNectar(true);
                ((Bee)entity).m_27853_();
                if (layerValueMinusOne == 0) {
                    world.m_7731_(blockPos, Blocks.f_50016_.m_49966_(), 3);
                } else {
                    world.m_7731_(blockPos, (BlockState)blockState.m_61124_((Property)LAYERS, (Comparable)Integer.valueOf(layerValueMinusOne)), 3);
                }
            }
            if (entity instanceof Panda) {
                Panda pandaEntity = (Panda)entity;
                PileOfPollen.pandaSneezing(pandaEntity);
            }
            if (entity instanceof LivingEntity && !(livingEntity = (LivingEntity)entity).m_21023_(BzEffects.HIDDEN.get())) {
                PileOfPollen.applyHiddenEffectIfBuried(livingEntity, blockState, blockPos);
            }
        }
    }

    public static void reapplyHiddenEffectIfInsidePollenPile(LivingEntity livingEntity) {
        BlockPos maxCorner;
        AABB aabb = livingEntity.m_20191_();
        Level level = livingEntity.f_19853_;
        BlockPos minCorner = BlockPos.m_274561_((double)(aabb.f_82288_ + 0.001), (double)(aabb.f_82289_ + 0.001), (double)(aabb.f_82290_ + 0.001));
        if (level.m_46832_(minCorner, maxCorner = BlockPos.m_274561_((double)(aabb.f_82291_ - 0.001), (double)(aabb.f_82292_ - 0.001), (double)(aabb.f_82293_ - 0.001)))) {
            BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
            for (int x = minCorner.m_123341_(); x <= maxCorner.m_123341_(); ++x) {
                for (int y = minCorner.m_123342_(); y <= maxCorner.m_123342_(); ++y) {
                    for (int z = minCorner.m_123343_(); z <= maxCorner.m_123343_(); ++z) {
                        mutableBlockPos.m_122178_(x, y, z);
                        BlockState blockState = level.m_8055_((BlockPos)mutableBlockPos);
                        if (!blockState.m_60713_(BzBlocks.PILE_OF_POLLEN.get())) continue;
                        PileOfPollen.applyHiddenEffectIfBuried(livingEntity, blockState, (BlockPos)mutableBlockPos);
                    }
                }
            }
        }
    }

    private static void applyHiddenEffectIfBuried(LivingEntity livingEntity, BlockState blockState, BlockPos blockPos) {
        AABB blockBounds = PileOfPollen.getAABBShape(blockState).m_82386_((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_());
        if (blockBounds.m_82390_(livingEntity.m_146892_())) {
            livingEntity.m_7292_(new MobEffectInstance(BzEffects.HIDDEN.get(), 10, 1, true, false, true));
        } else if (blockBounds.m_82390_(livingEntity.m_146892_().m_82520_(0.0, -0.2, 0.0))) {
            livingEntity.m_7292_(new MobEffectInstance(BzEffects.HIDDEN.get(), 10, 0, true, false, true));
        }
    }

    public static void stackPollen(BlockState blockState, Level world, BlockPos blockPos, BlockState pollonToStack) {
        BlockState lastSetState = null;
        int initialLayerValue = (Integer)blockState.m_61143_((Property)LAYERS);
        int layersToAdd = (Integer)pollonToStack.m_61143_((Property)LAYERS);
        if (initialLayerValue < 8) {
            int layerToMax = 8 - initialLayerValue;
            lastSetState = (BlockState)blockState.m_61124_((Property)LAYERS, (Comparable)Integer.valueOf(initialLayerValue + Math.min(layerToMax, layersToAdd)));
            world.m_7731_(blockPos, lastSetState, 3);
            layersToAdd -= layerToMax;
        }
        BlockState aboveState = world.m_8055_(blockPos.m_7494_());
        if (layersToAdd > 0 && aboveState.m_60713_(BzBlocks.PILE_OF_POLLEN.get())) {
            PileOfPollen.stackPollen(aboveState, world, blockPos.m_7494_(), (BlockState)blockState.m_61124_((Property)LAYERS, (Comparable)Integer.valueOf(layersToAdd)));
        } else {
            if (layersToAdd > 0 && aboveState.m_60795_()) {
                lastSetState = (BlockState)blockState.m_61124_((Property)LAYERS, (Comparable)Integer.valueOf(layersToAdd));
                world.m_7731_(blockPos.m_7494_(), (BlockState)blockState.m_61124_((Property)LAYERS, (Comparable)Integer.valueOf(layersToAdd)), 3);
            }
            if (world.m_5776_() && lastSetState != null) {
                for (int i = 0; i < 40; ++i) {
                    PileOfPollen.spawnParticles(lastSetState, (LevelAccessor)world, blockPos, world.f_46441_, true);
                }
            }
        }
    }

    public static void pandaSneezing(Panda pandaEntity) {
        if (!pandaEntity.f_19853_.m_5776_() && pandaEntity.m_217043_().m_188501_() < 0.005f && pandaEntity.f_19853_.m_8055_(pandaEntity.m_20183_()).m_60713_(BzBlocks.PILE_OF_POLLEN.get())) {
            pandaEntity.m_29220_(true);
        }
    }

    public void m_214162_(BlockState blockState, Level world, BlockPos blockPos, RandomSource random) {
        int layerValue = (Integer)blockState.m_61143_((Property)LAYERS);
        double chance = 0.015f + (float)layerValue * 0.008f;
        if ((double)random.m_188501_() < chance) {
            PileOfPollen.spawnParticles(blockState, (LevelAccessor)world, blockPos, random, false);
        }
    }

    public int m_6248_(BlockState blockState, BlockGetter blockReader, BlockPos blockPos) {
        return 0xFFAA00;
    }

    public static void spawnParticles(BlockState blockState, LevelAccessor world, BlockPos blockPos, RandomSource random, boolean disturbed) {
        for (Direction direction : Direction.values()) {
            BlockPos blockpos = blockPos.m_121945_(direction);
            if (world.m_8055_(blockpos).m_60804_((BlockGetter)world, blockpos)) continue;
            double speedYModifier = disturbed ? 0.05 : 0.005;
            double speedXZModifier = disturbed ? 0.03 : 0.005;
            VoxelShape currentShape = SHAPE_BY_LAYER[(Integer)blockState.m_61143_((Property)LAYERS)];
            double yHeight = currentShape.m_83297_(Direction.Axis.Y) - currentShape.m_83288_(Direction.Axis.Y);
            Direction.Axis directionAxis = direction.m_122434_();
            double xOffset = directionAxis == Direction.Axis.X ? 0.5 + 0.5625 * (double)direction.m_122429_() : (double)random.m_188501_();
            double yOffset = directionAxis == Direction.Axis.Y ? yHeight * (double)direction.m_122430_() : (double)random.m_188501_() * yHeight;
            double zOffset = directionAxis == Direction.Axis.Z ? 0.5 + 0.5625 * (double)direction.m_122431_() : (double)random.m_188501_();
            world.m_7106_((ParticleOptions)BzParticles.POLLEN_PARTICLE.get(), (double)blockPos.m_123341_() + xOffset, (double)blockPos.m_123342_() + yOffset, (double)blockPos.m_123343_() + zOffset, random.m_188583_() * speedXZModifier, random.m_188583_() * speedYModifier + (disturbed ? 0.01 : 0.0), random.m_188583_() * speedXZModifier);
            return;
        }
    }

    public static void spawnParticles(LevelAccessor world, Vec3 location, RandomSource random, double speedXZModifier, double speedYModifier, double initYSpeed) {
        double xOffset = (double)random.m_188501_() * 0.3 - 0.15;
        double yOffset = (double)random.m_188501_() * 0.3 - 0.15;
        double zOffset = (double)random.m_188501_() * 0.3 - 0.15;
        world.m_7106_((ParticleOptions)BzParticles.POLLEN_PARTICLE.get(), location.m_7096_() + xOffset, location.m_7098_() + yOffset, location.m_7094_() + zOffset, random.m_188583_() * speedXZModifier, random.m_188583_() * speedYModifier + initYSpeed, random.m_188583_() * speedXZModifier);
    }

    public static void spawnParticlesServer(LevelAccessor world, Vec3 location, RandomSource random, double speedXZModifier, double speedYModifier, double initYSpeed, int numberOfParticles) {
        if (world.m_5776_()) {
            return;
        }
        double xOffset = (double)random.m_188501_() * 0.3 - 0.15;
        double yOffset = (double)random.m_188501_() * 0.3 - 0.15;
        double zOffset = (double)random.m_188501_() * 0.3 - 0.15;
        ((ServerLevel)world).m_8767_((ParticleOptions)BzParticles.POLLEN_PARTICLE.get(), location.m_7096_() + xOffset, location.m_7098_() + yOffset, location.m_7094_() + zOffset, numberOfParticles, random.m_188583_() * speedXZModifier, random.m_188583_() * speedYModifier + initYSpeed, random.m_188583_() * speedXZModifier, (double)0.02f);
    }
}

