/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.blocks;

import com.mojang.datafixers.util.Pair;
import com.telepathicgrunt.the_bumblezone.blocks.blockentities.HoneyCocoonBlockEntity;
import com.telepathicgrunt.the_bumblezone.items.recipes.ContainerCraftingRecipe;
import com.telepathicgrunt.the_bumblezone.modinit.BzBlockEntities;
import com.telepathicgrunt.the_bumblezone.modinit.BzCriterias;
import com.telepathicgrunt.the_bumblezone.modinit.BzFluids;
import com.telepathicgrunt.the_bumblezone.modinit.BzItems;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import com.telepathicgrunt.the_bumblezone.utils.PlatformHooks;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class HoneyCocoon
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    protected final VoxelShape shape;
    public static final int waterDropDelay = 150;

    public HoneyCocoon() {
        super(BlockBehaviour.Properties.m_60944_((Material)Material.f_76286_, (MaterialColor)MaterialColor.f_76416_).m_60913_(0.3f, 0.3f).m_60977_().m_60955_().m_60918_(SoundType.f_56751_));
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
        VoxelShape voxelshape = Block.m_49796_((double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0);
        voxelshape = Shapes.m_83110_((VoxelShape)voxelshape, (VoxelShape)Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)1.0, (double)14.0));
        this.shape = voxelshape = Shapes.m_83110_((VoxelShape)voxelshape, (VoxelShape)Block.m_49796_((double)3.0, (double)14.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0));
    }

    public VoxelShape m_5940_(BlockState blockstate, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return this.shape;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return BzBlockEntities.HONEY_COCOON.get().m_155264_(blockPos, blockState);
    }

    public RenderShape m_7514_(BlockState blockState) {
        return RenderShape.MODEL;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WATERLOGGED});
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? BzFluids.SUGAR_WATER_FLUID.get().m_76068_(false) : super.m_5888_(state);
    }

    public BlockState m_7417_(BlockState blockstate, Direction facing, BlockState facingState, LevelAccessor world, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)blockstate.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            world.m_186469_(currentPos, (Fluid)BzFluids.SUGAR_WATER_FLUID.get(), BzFluids.SUGAR_WATER_FLUID.get().m_6718_((LevelReader)world));
            world.m_186460_(currentPos, blockstate.m_60734_(), 150);
        }
        return super.m_7417_(blockstate, facing, facingState, world, currentPos, facingPos);
    }

    public void m_6861_(BlockState blockstate, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean notify) {
        if (((Boolean)blockstate.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            world.m_186469_(pos, (Fluid)BzFluids.SUGAR_WATER_FLUID.get(), BzFluids.SUGAR_WATER_FLUID.get().m_6718_((LevelReader)world));
            world.m_186460_(pos, blockstate.m_60734_(), 150);
        }
        super.m_6861_(blockstate, world, pos, block, fromPos, notify);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState blockstate = this.m_49966_();
        FluidState fluidstate = context.m_43725_().m_6425_(context.m_8083_());
        return (BlockState)blockstate.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.m_76152_().m_205067_(BzTags.CONVERTIBLE_TO_SUGAR_WATER) && fluidstate.m_76170_()));
    }

    public void m_213898_(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, RandomSource random) {
        BlockEntity blockEntity;
        if (!((Boolean)blockState.m_61143_((Property)WATERLOGGED)).booleanValue() && (blockEntity = serverLevel.m_7702_(blockPos)) instanceof HoneyCocoonBlockEntity) {
            HoneyCocoonBlockEntity honeyCocoonBlockEntity = (HoneyCocoonBlockEntity)blockEntity;
            if (!honeyCocoonBlockEntity.isUnpackedLoottable()) {
                return;
            }
            BlockState aboveState = serverLevel.m_8055_(blockPos.m_7494_());
            if (!aboveState.m_60812_((BlockGetter)serverLevel, blockPos).m_83281_()) {
                return;
            }
            ArrayList<Pair> emptyBroods = new ArrayList<Pair>();
            ArrayList<Pair> beeFeeding = new ArrayList<Pair>();
            for (int i = 0; i < honeyCocoonBlockEntity.m_6643_(); ++i) {
                ItemStack itemStack = honeyCocoonBlockEntity.m_8020_(i);
                if (itemStack.m_41619_()) continue;
                if (itemStack.m_41720_() == BzItems.EMPTY_HONEYCOMB_BROOD.get()) {
                    emptyBroods.add(new Pair((Object)itemStack, (Object)i));
                }
                if (!itemStack.m_204117_(BzTags.BEE_FEEDING_ITEMS)) continue;
                beeFeeding.add(new Pair((Object)itemStack, (Object)i));
            }
            if (emptyBroods.isEmpty() || beeFeeding.isEmpty()) {
                return;
            }
            honeyCocoonBlockEntity.m_7407_((Integer)((Pair)emptyBroods.get(random.m_188503_(emptyBroods.size()))).getSecond(), 1);
            ItemStack consumedItem = honeyCocoonBlockEntity.m_7407_((Integer)((Pair)beeFeeding.get(random.m_188503_(beeFeeding.size()))).getSecond(), 1);
            if (PlatformHooks.hasCraftingRemainder(consumedItem)) {
                ItemStack ejectedItem = PlatformHooks.getCraftingRemainder(consumedItem);
                if (ejectedItem.m_41619_()) {
                    ejectedItem = ContainerCraftingRecipe.HARDCODED_EDGECASES_WITHOUT_CONTAINERS_SET.get(consumedItem.m_41720_()).m_7968_();
                }
                if (!ejectedItem.m_41619_()) {
                    GeneralUtils.spawnItemEntity(serverLevel, blockPos, ejectedItem, 0.0, 0.2);
                }
            }
            boolean addedToInv = false;
            for (int i = 0; i < honeyCocoonBlockEntity.m_6643_(); ++i) {
                ItemStack itemStack = honeyCocoonBlockEntity.m_8020_(i);
                if (!itemStack.m_41619_() && (itemStack.m_41720_() != BzItems.HONEYCOMB_BROOD.get() || itemStack.m_41613_() >= 64)) continue;
                if (itemStack.m_41619_()) {
                    honeyCocoonBlockEntity.m_6836_(i, BzItems.HONEYCOMB_BROOD.get().m_7968_());
                } else {
                    itemStack.m_41769_(1);
                }
                addedToInv = true;
                break;
            }
            if (!addedToInv) {
                GeneralUtils.spawnItemEntity(serverLevel, blockPos, BzItems.HONEYCOMB_BROOD.get().m_7968_(), 0.0, 0.2);
            }
        }
    }

    public void m_213897_(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, RandomSource random) {
        BlockEntity blockEntity;
        if (((Boolean)blockState.m_61143_((Property)WATERLOGGED)).booleanValue() && (blockEntity = serverLevel.m_7702_(blockPos)) instanceof HoneyCocoonBlockEntity) {
            HoneyCocoonBlockEntity honeyCocoonBlockEntity = (HoneyCocoonBlockEntity)blockEntity;
            if (!honeyCocoonBlockEntity.isUnpackedLoottable()) {
                return;
            }
            BlockState aboveState = serverLevel.m_8055_(blockPos.m_7494_());
            if (!aboveState.m_60819_().m_205070_(FluidTags.f_13131_) || !aboveState.m_60812_((BlockGetter)serverLevel, blockPos).m_83281_()) {
                return;
            }
            serverLevel.m_186460_(blockPos, blockState.m_60734_(), 150);
            ArrayList<Pair> itemStacks = new ArrayList<Pair>();
            for (int i = 0; i < honeyCocoonBlockEntity.m_6643_(); ++i) {
                ItemStack itemStack = honeyCocoonBlockEntity.m_8020_(i);
                if (itemStack.m_41619_()) continue;
                itemStacks.add(new Pair((Object)itemStack, (Object)i));
            }
            if (itemStacks.isEmpty()) {
                return;
            }
            ItemStack takenItem = honeyCocoonBlockEntity.m_7407_((Integer)((Pair)itemStacks.get(random.m_188503_(itemStacks.size()))).getSecond(), 1);
            GeneralUtils.spawnItemEntity(serverLevel, blockPos, takenItem, 0.0, -0.2);
        }
    }

    public InteractionResult m_6227_(BlockState blockstate, Level world, BlockPos position, Player playerEntity, InteractionHand playerHand, BlockHitResult raytraceResult) {
        ItemStack itemstack = playerEntity.m_21120_(playerHand);
        if (itemstack.m_41720_() == Items.f_42590_ && ((Boolean)blockstate.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            world.m_6263_(playerEntity, playerEntity.m_20185_(), playerEntity.m_20186_(), playerEntity.m_20189_(), SoundEvents.f_11770_, SoundSource.PLAYERS, 1.0f, 1.0f);
            GeneralUtils.givePlayerItem(playerEntity, playerHand, new ItemStack((ItemLike)BzItems.SUGAR_WATER_BOTTLE.get()), false, true);
            return InteractionResult.SUCCESS;
        }
        if (world.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        MenuProvider menuprovider = this.m_7246_(blockstate, world, position);
        if (menuprovider != null) {
            playerEntity.m_5893_(menuprovider);
        }
        return InteractionResult.CONSUME;
    }

    public void m_6402_(Level level, BlockPos pos, BlockState blockstate, LivingEntity livingEntity, ItemStack itemStack) {
        BlockEntity blockentity;
        if (itemStack.m_41788_() && (blockentity = level.m_7702_(pos)) instanceof HoneyCocoonBlockEntity) {
            ((HoneyCocoonBlockEntity)blockentity).m_58638_(itemStack.m_41786_());
        }
        if (((Boolean)blockstate.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(pos, (Fluid)BzFluids.SUGAR_WATER_FLUID.get(), BzFluids.SUGAR_WATER_FLUID.get().m_6718_((LevelReader)level));
            level.m_186460_(pos, blockstate.m_60734_(), 150);
        }
    }

    public boolean m_6044_(BlockGetter world, BlockPos blockPos, BlockState blockState, Fluid fluid) {
        return (Boolean)blockState.m_61143_((Property)WATERLOGGED) == false && fluid.m_205067_(BzTags.CONVERTIBLE_TO_SUGAR_WATER) && fluid.m_76145_().m_76170_();
    }

    public boolean m_7361_(LevelAccessor world, BlockPos blockPos, BlockState blockState, FluidState fluidState) {
        if (!((Boolean)blockState.m_61143_((Property)WATERLOGGED)).booleanValue() && fluidState.m_76152_().m_205067_(BzTags.CONVERTIBLE_TO_SUGAR_WATER) && fluidState.m_76170_()) {
            if (!world.m_5776_()) {
                world.m_7731_(blockPos, (BlockState)blockState.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true)), 3);
                world.m_186469_(blockPos, (Fluid)BzFluids.SUGAR_WATER_FLUID.get(), BzFluids.SUGAR_WATER_FLUID.get().m_6718_((LevelReader)world));
            }
            return true;
        }
        return false;
    }

    public ItemStack m_142598_(LevelAccessor world, BlockPos blockPos, BlockState blockState) {
        if (((Boolean)blockState.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            world.m_7731_(blockPos, (BlockState)blockState.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)), 3);
            return new ItemStack((ItemLike)BzItems.SUGAR_WATER_BUCKET.get());
        }
        return ItemStack.f_41583_;
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof HoneyCocoonBlockEntity) {
            HoneyCocoonBlockEntity honeyCocoonBlockEntity = (HoneyCocoonBlockEntity)blockEntity;
            if (!level.m_5776_() && player.m_7500_() && !honeyCocoonBlockEntity.m_7983_()) {
                ItemStack itemStack = BzItems.HONEY_COCOON.get().m_7968_();
                blockEntity.m_187476_(itemStack);
                if (honeyCocoonBlockEntity.m_8077_()) {
                    itemStack.m_41714_(honeyCocoonBlockEntity.m_7770_());
                }
                CompoundTag parentTag = null;
                CompoundTag tag = itemStack.m_41783_();
                if (tag != null) {
                    if (tag.m_128441_("BlockEntityTag")) {
                        parentTag = tag;
                        tag = tag.m_128469_("BlockEntityTag");
                    }
                    if (!tag.m_128441_("UUID")) {
                        if (parentTag != null) {
                            parentTag.m_128359_("UUID", UUID.randomUUID().toString());
                        } else {
                            tag.m_128359_("UUID", UUID.randomUUID().toString());
                        }
                    }
                }
                ItemEntity itementity = new ItemEntity(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, itemStack);
                itementity.m_32060_();
                level.m_7967_((Entity)itementity);
            } else {
                honeyCocoonBlockEntity.m_59640_(player);
            }
        }
    }

    public void m_6240_(Level level, Player player, BlockPos pos, BlockState state, BlockEntity blockEntity, ItemStack itemStack) {
        if (EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44985_, (ItemStack)itemStack) > 0 && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            BzCriterias.HONEY_COCOON_SILK_TOUCH_TRIGGER.trigger(serverPlayer);
        }
        super.m_6240_(level, player, pos, state, blockEntity, itemStack);
    }

    public void m_5871_(ItemStack itemStack, BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
        super.m_5871_(itemStack, level, tooltip, flag);
        CompoundTag compoundtag = BlockItem.m_186336_((ItemStack)itemStack);
        if (compoundtag != null) {
            if (compoundtag.m_128425_("LootTable", 8)) {
                tooltip.add((Component)Component.m_237113_((String)"???????"));
            }
            if (compoundtag.m_128425_("Items", 9)) {
                NonNullList nonnulllist = NonNullList.m_122780_((int)27, (Object)ItemStack.f_41583_);
                ContainerHelper.m_18980_((CompoundTag)compoundtag, (NonNullList)nonnulllist);
                int i = 0;
                int j = 0;
                for (ItemStack itemstack : nonnulllist) {
                    if (itemstack.m_41619_()) continue;
                    ++j;
                    if (i > 4) continue;
                    ++i;
                    MutableComponent mutablecomponent = itemstack.m_41786_().m_6881_();
                    mutablecomponent.m_130946_(" x").m_130946_(String.valueOf(itemstack.m_41613_()));
                    tooltip.add((Component)mutablecomponent);
                }
                if (j - i > 0) {
                    tooltip.add((Component)Component.m_237110_((String)"container.shulkerBox.more", (Object[])new Object[]{j - i}).m_130940_(ChatFormatting.ITALIC));
                }
            }
        }
    }

    public boolean m_7357_(BlockState state, BlockGetter world, BlockPos pos, PathComputationType type) {
        return false;
    }

    public void m_214162_(BlockState blockState, Level world, BlockPos position, RandomSource random) {
        if (!((Boolean)blockState.m_61143_((Property)WATERLOGGED)).booleanValue() && random.m_188501_() < 0.05f) {
            this.spawnHoneyParticles(world, position, random);
        }
    }

    private void spawnHoneyParticles(Level world, BlockPos position, RandomSource random) {
        double x = random.m_188500_() * 14.0 + 1.0;
        double y = random.m_188500_() * 6.0 + 5.0;
        double z = random.m_188500_() * 14.0 + 1.0;
        if (random.m_188499_()) {
            x = random.m_188499_() ? 0.8 : 15.2;
        } else {
            z = random.m_188499_() ? 0.8 : 15.2;
        }
        world.m_7106_((ParticleOptions)ParticleTypes.f_123780_, x / 16.0 + (double)position.m_123341_(), y / 16.0 + (double)position.m_123342_(), z / 16.0 + (double)position.m_123343_(), 0.0, 0.0, 0.0);
    }
}

