/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.mod_compat.jei;

import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.client.gui.menu.AlchemyTableMenu;
import com.legacy.blue_skies.client.gui.menu.HorizoniteForgeMenu;
import com.legacy.blue_skies.client.gui.menu.SnowcapOvenMenu;
import com.legacy.blue_skies.client.gui.screen.ArcsScreen;
import com.legacy.blue_skies.client.gui.screen.HorizoniteForgeScreen;
import com.legacy.blue_skies.client.gui.screen.SnowcapOvenScreen;
import com.legacy.blue_skies.data.BlueSkiesData;
import com.legacy.blue_skies.data.objects.SnowcapMushroomFreezing;
import com.legacy.blue_skies.data.objects.alchemy.AlchemyRecipe;
import com.legacy.blue_skies.mod_compat.jei.JEIOverlayWrapper;
import com.legacy.blue_skies.mod_compat.jei.category.AlchemyCategory;
import com.legacy.blue_skies.mod_compat.jei.category.HorizoniteForgeFuelCategory;
import com.legacy.blue_skies.mod_compat.jei.category.SnowcapMushroomFreezingCategory;
import com.legacy.blue_skies.mod_compat.jei.category.SnowcapOvenFreezingCategory;
import com.legacy.blue_skies.mod_compat.jei.helpers.BlockIngredientHelper;
import com.legacy.blue_skies.mod_compat.jei.renderers.BlockIngredientRenderer;
import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.registries.SkiesContainers;
import com.legacy.blue_skies.registries.SkiesItems;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IModIngredientRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import net.minecraft.Util;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;

public class SkiesJEIPlugin
implements IModPlugin {
    public static final ResourceLocation ID = BlueSkies.locate("jei_plugin");
    public static final IIngredientType<BlockState> BLOCKSTATE = () -> BlockState.class;

    public ResourceLocation getPluginUid() {
        return ID;
    }

    public void registerGuiHandlers(IGuiHandlerRegistration reg) {
        reg.addGuiContainerHandler(InventoryScreen.class, new JEIOverlayWrapper());
        reg.addGuiContainerHandler(ArcsScreen.class, new JEIOverlayWrapper());
        reg.addGuiContainerHandler(CreativeModeInventoryScreen.class, new JEIOverlayWrapper());
        reg.addRecipeClickArea(HorizoniteForgeScreen.class, 78, 32, 28, 23, new RecipeType[]{HorizoniteForgeFuelCategory.TYPE, RecipeTypes.SMELTING});
        reg.addRecipeClickArea(HorizoniteForgeScreen.class, 39, 53, 16, 18, new RecipeType[]{HorizoniteForgeFuelCategory.TYPE, RecipeTypes.SMELTING});
        reg.addRecipeClickArea(SnowcapOvenScreen.class, 78, 16, 28, 49, new RecipeType[]{SnowcapOvenFreezingCategory.TYPE, RecipeTypes.SMELTING});
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration reg) {
        reg.addRecipeTransferHandler(HorizoniteForgeMenu.class, SkiesContainers.HORIZONITE_FORGE, RecipeTypes.SMELTING, 0, 1, 3, 36);
        reg.addRecipeTransferHandler(HorizoniteForgeMenu.class, SkiesContainers.HORIZONITE_FORGE, HorizoniteForgeFuelCategory.TYPE, 1, 1, 3, 36);
        reg.addRecipeTransferHandler(SnowcapOvenMenu.class, SkiesContainers.SNOWCAP_OVEN, RecipeTypes.SMELTING, 0, 1, 3, 36);
        reg.addRecipeTransferHandler(SnowcapOvenMenu.class, SkiesContainers.SNOWCAP_OVEN, SnowcapOvenFreezingCategory.TYPE, 1, 1, 3, 36);
        reg.addRecipeTransferHandler(AlchemyTableMenu.class, SkiesContainers.ALCHEMY_TABLE, AlchemyCategory.TYPE, 0, 2, 3, 36);
    }

    public void registerCategories(IRecipeCategoryRegistration reg) {
        IGuiHelper guiHelper = reg.getJeiHelpers().getGuiHelper();
        reg.addRecipeCategories(new IRecipeCategory[]{new SnowcapMushroomFreezingCategory(guiHelper)});
        reg.addRecipeCategories(new IRecipeCategory[]{new HorizoniteForgeFuelCategory(guiHelper)});
        reg.addRecipeCategories(new IRecipeCategory[]{new SnowcapOvenFreezingCategory(guiHelper)});
        reg.addRecipeCategories(new IRecipeCategory[]{new AlchemyCategory(guiHelper)});
    }

    public void registerRecipes(IRecipeRegistration reg) {
        List removed = (List)Util.m_137469_(new ArrayList(), list -> {
            list.add(SkiesItems.summoner_spawn_egg);
            list.add(SkiesItems.alchemist_spawn_egg);
            list.add(SkiesItems.starlit_crusher_spawn_egg);
            list.add(SkiesItems.arachnarch_spawn_egg);
            list.add(SkiesItems.aquatic_arc);
            list.add(SkiesItems.life_arc);
            list.add(SkiesItems.runic_arc);
            list.add(SkiesItems.shadow_boots);
            list.add(SkiesItems.shadow_leggings);
            list.add(SkiesItems.shadow_chestplate);
            list.add(SkiesItems.shadow_helmet);
            list.add(SkiesItems.infused_arc_sword);
            list.add(SkiesItems.debug_sword);
        });
        reg.getIngredientManager().removeIngredientsAtRuntime((IIngredientType)VanillaTypes.ITEM_STACK, removed.stream().map(ItemStack::new).toList());
        reg.addRecipes(SnowcapMushroomFreezingCategory.TYPE, SnowcapMushroomFreezingCategory.getAllRecipes());
        reg.addRecipes(HorizoniteForgeFuelCategory.TYPE, List.copyOf(BlueSkiesData.HORIZONITE_FORGE_FUEL.getData().values()));
        reg.addRecipes(SnowcapOvenFreezingCategory.TYPE, List.copyOf(BlueSkiesData.SNOWCAP_OVEN_FREEZING.getData().values()));
        AlchemyRecipe goldRecipe = (AlchemyRecipe)BlueSkiesData.ALCHEMY_RECIPES.getValue(BlueSkies.locate("gold_lol"));
        reg.addRecipes(AlchemyCategory.TYPE, BlueSkiesData.ALCHEMY_RECIPES.getData().values().stream().filter(r -> r != goldRecipe).toList());
        this.info(reg, new ItemLike[]{SkiesItems.blue_journal, SkiesItems.zeal_lighter, SkiesBlocks.turquoise_stonebrick, SkiesBlocks.lunar_stonebrick, SkiesBlocks.alchemy_table, SkiesBlocks.summoning_table});
        this.info(reg, "portal", new ItemLike[]{SkiesBlocks.everbright_portal, SkiesBlocks.everdawn_portal});
    }

    private void info(IRecipeRegistration reg, String translationKey, ItemLike ... items) {
        for (ItemLike item : items) {
            reg.addIngredientInfo((Object)item.m_5456_().m_7968_(), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.m_237115_((String)("gui.blue_skies.jei.info." + translationKey))});
        }
    }

    private void info(IRecipeRegistration reg, ItemLike ... items) {
        for (ItemLike item : items) {
            Item i = item.m_5456_();
            ResourceLocation key = ForgeRegistries.ITEMS.getKey((Object)i);
            if (key != null) {
                reg.addIngredientInfo((Object)i.m_7968_(), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.m_237115_((String)("gui.blue_skies.jei.info." + key.m_135815_()))});
                continue;
            }
            BlueSkies.LOGGER.warn("[Blue Skies] " + i + " had a null registry name!");
        }
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration reg) {
        reg.addRecipeCatalyst(new ItemStack((ItemLike)SkiesBlocks.snowcap_mushroom), new RecipeType[]{SnowcapMushroomFreezingCategory.TYPE});
        reg.addRecipeCatalyst(new ItemStack((ItemLike)SkiesBlocks.horizonite_forge), new RecipeType[]{HorizoniteForgeFuelCategory.TYPE});
        reg.addRecipeCatalyst(new ItemStack((ItemLike)SkiesBlocks.snowcap_oven), new RecipeType[]{SnowcapOvenFreezingCategory.TYPE});
        reg.addRecipeCatalyst(new ItemStack((ItemLike)SkiesBlocks.alchemy_table), new RecipeType[]{AlchemyCategory.TYPE});
    }

    public void registerIngredients(IModIngredientRegistration reg) {
        HashSet<Block> blocks = new HashSet<Block>();
        for (SnowcapMushroomFreezing recipe : SnowcapMushroomFreezingCategory.getAllRecipes()) {
            this.addBlockStateIngredient(blocks, recipe.block);
            this.addBlockStateIngredient(blocks, recipe.frozenBlock);
        }
        BlockIngredientHelper blockIngredientHelper = new BlockIngredientHelper();
        BlockIngredientRenderer blockIngredientRenderer = new BlockIngredientRenderer();
        reg.register(BLOCKSTATE, (Collection)blocks.stream().map(Block::m_49966_).collect(Collectors.toList()), (IIngredientHelper)blockIngredientHelper, (IIngredientRenderer)blockIngredientRenderer);
    }

    private void addBlockStateIngredient(Set<Block> blocks, Block block) {
        if (Item.f_41373_.get(block) == null && !(block instanceof LiquidBlock)) {
            blocks.add(block);
        }
    }
}

