/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.entities.projectile;

import com.legacy.blue_skies.registries.SkiesEntityTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.projectile.LlamaSpit;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;

public class SeedBombEntity
extends LlamaSpit {
    public SeedBombEntity(EntityType<? extends SeedBombEntity> type, Level world) {
        super(type, world);
    }

    public SeedBombEntity(Level worldIn, Monster shooter) {
        this(SkiesEntityTypes.SEED_BOMB, worldIn);
        super.m_5602_((Entity)shooter);
        this.m_6034_(shooter.m_20185_(), shooter.m_20186_() + (double)shooter.m_20192_() - (double)0.1f, shooter.m_20189_());
    }

    @OnlyIn(value=Dist.CLIENT)
    public SeedBombEntity(Level worldIn, double x, double y, double z, double xDir, double yDir, double zDir) {
        this(SkiesEntityTypes.SEED_BOMB, worldIn);
        this.m_6034_(x, y, z);
        for (int i = 0; i < 7; ++i) {
            double d0 = 0.4 + 0.1 * (double)i;
            worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123764_, x, y, z, xDir * d0, yDir, zDir * d0);
        }
        this.m_20334_(xDir, yDir, zDir);
    }

    public SeedBombEntity(PlayMessages.SpawnEntity spawnEntity, Level world) {
        this(SkiesEntityTypes.SEED_BOMB, world);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19853_.f_46443_) {
            this.spawnParticles();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void spawnParticles() {
        float dx = (this.f_19796_.m_188501_() - 0.5f) / 7.0f;
        float dy = this.f_19796_.m_188501_() / 10.0f;
        float dz = (this.f_19796_.m_188501_() - 0.5f) / 7.0f;
        this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123763_, (double)this.m_20183_().m_123341_() + 0.5, (double)((float)this.m_20183_().m_123342_() + 0.5f), (double)this.m_20183_().m_123343_() + 0.5, (double)dx, (double)dy, (double)dz);
    }

    public void m_6686_(double x, double y, double z, float velocity, float inaccuracy) {
        Vec3 vec3d = new Vec3(x, y, z).m_82541_().m_82520_(this.f_19796_.m_188583_() * (double)0.0075f * (double)inaccuracy, this.f_19796_.m_188583_() * (double)0.0075f * (double)inaccuracy, this.f_19796_.m_188583_() * (double)0.0075f * (double)inaccuracy).m_82490_((double)velocity);
        this.m_20256_(vec3d);
        double f = vec3d.m_165924_();
        this.m_146922_((float)(Mth.m_14136_((double)vec3d.f_82479_, (double)z) * 57.2957763671875));
        this.m_146926_((float)(Mth.m_14136_((double)vec3d.f_82480_, (double)f) * 57.2957763671875));
        this.f_19859_ = this.m_146908_();
        this.f_19860_ = this.m_146909_();
    }

    protected void m_5790_(EntityHitResult result) {
        Entity entity = this.m_19749_();
        if (entity != null && result.m_82443_() != null && !entity.m_7307_(result.m_82443_())) {
            this.causeSeedExplosion(this.m_20183_());
            super.m_5790_(result);
            if (!this.f_19853_.f_46443_) {
                this.m_146870_();
            }
        }
    }

    protected void m_8060_(BlockHitResult result) {
        super.m_8060_(result);
        this.causeSeedExplosion(result.m_82425_().m_6630_(1));
    }

    public void causeSeedExplosion(BlockPos pos) {
        this.m_5496_(SoundEvents.f_12543_, 0.7f, 1.0f);
        this.m_5496_(SoundEvents.f_12019_, 0.3f, 0.7f);
        double d0 = (double)pos.m_123341_() + 0.5;
        double d13 = (double)pos.m_123342_() + 0.5;
        double d18 = (double)pos.m_123343_() + 0.5;
        for (double d24 = 0.0; d24 < Math.PI * 2; d24 += 0.1) {
            double motion = 0.1f;
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, d0 + Math.cos(d24) * motion, d13 - 0.4, d18 + Math.sin(d24) * motion, Math.cos(d24) * -motion, 0.0, Math.sin(d24) * -motion);
        }
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

