/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.entities.projectile;

import com.google.common.collect.Lists;
import com.legacy.blue_skies.entities.hostile.boss.SummonerEntity;
import com.legacy.blue_skies.entities.util.interfaces.ISkyBoss;
import com.legacy.blue_skies.registries.SkiesDamageSources;
import com.legacy.blue_skies.registries.SkiesEntityTypes;
import com.legacy.blue_skies.registries.SkiesParticles;
import com.legacy.blue_skies.registries.SkiesSounds;
import com.legacy.blue_skies.util.GeometryHelper;
import java.util.ArrayList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;

public class FluctuantSphereEntity
extends AbstractHurtingProjectile {
    public FluctuantSphereEntity(EntityType<? extends FluctuantSphereEntity> type, Level world) {
        super(type, world);
    }

    public FluctuantSphereEntity(Level worldIn, SummonerEntity summoner) {
        this(SkiesEntityTypes.FLUCTUANT_SPHERE, worldIn);
        this.m_5602_((Entity)summoner);
        this.m_6034_(summoner.m_20185_() - (double)(summoner.m_20205_() + 1.0f) * 0.5 * (double)Mth.m_14031_((float)(summoner.f_20883_ * ((float)Math.PI / 180))), summoner.m_20186_() + (double)summoner.m_20192_() - (double)0.1f, summoner.m_20189_() + (double)(summoner.m_20205_() + 1.0f) * 0.5 * (double)Mth.m_14089_((float)(summoner.f_20883_ * ((float)Math.PI / 180))));
    }

    public FluctuantSphereEntity(PlayMessages.SpawnEntity spawnEntity, Level world) {
        this(SkiesEntityTypes.FLUCTUANT_SPHERE, world);
    }

    @OnlyIn(value=Dist.CLIENT)
    public FluctuantSphereEntity(Level worldIn, double x, double y, double z, double accelX, double accelY, double accelZ) {
        super(SkiesEntityTypes.FLUCTUANT_SPHERE, x, y, z, accelX, accelY, accelZ, worldIn);
    }

    public FluctuantSphereEntity(Level worldIn, LivingEntity shooter, double accelX, double accelY, double accelZ) {
        super(SkiesEntityTypes.FLUCTUANT_SPHERE, shooter, accelX, accelY, accelZ, worldIn);
    }

    protected void m_6532_(HitResult result) {
        HitResult.Type raytraceresult$type = result.m_6662_();
        if (raytraceresult$type == HitResult.Type.BLOCK && !this.f_19853_.f_46443_ && this.f_19797_ > 20 || this.f_19797_ >= 100) {
            this.vanish();
        }
    }

    public boolean m_6087_() {
        return false;
    }

    public void m_8119_() {
        Entity entity = this.m_19749_();
        if (this.f_19853_.f_46443_ || (entity == null || entity.m_6084_()) && this.f_19853_.m_46749_(this.m_20183_())) {
            HitResult raytraceresult;
            super.m_8119_();
            if (this.m_5931_()) {
                this.m_20254_(1);
            }
            if ((raytraceresult = ProjectileUtil.m_37294_((Entity)this, x$0 -> this.m_5603_((Entity)x$0))).m_6662_() != HitResult.Type.MISS && !ForgeEventFactory.onProjectileImpact((Projectile)this, (HitResult)raytraceresult)) {
                this.m_6532_(raytraceresult);
            }
            this.m_20101_();
            Vec3 vector3d = this.m_20184_();
            double x = this.m_20185_() + vector3d.f_82479_;
            double y = this.m_20186_() + vector3d.f_82480_;
            double z = this.m_20189_() + vector3d.f_82481_;
            ProjectileUtil.m_37284_((Entity)this, (float)0.2f);
            float inirtia = this.m_6884_();
            if (this.m_20069_()) {
                for (int i = 0; i < 4; ++i) {
                    this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123795_, x - vector3d.f_82479_ * 0.25, y - vector3d.f_82480_ * 0.25, z - vector3d.f_82481_ * 0.25, vector3d.f_82479_, vector3d.f_82480_, vector3d.f_82481_);
                }
                inirtia = 0.8f;
            }
            this.m_20256_(vector3d.m_82520_(this.f_36813_, this.f_36814_, this.f_36815_).m_82490_((double)inirtia));
            this.m_6034_(x, y, z);
        } else {
            this.m_146870_();
        }
        if (this.f_19853_ instanceof ServerLevel) {
            ServerLevel world = (ServerLevel)this.f_19853_;
            for (ServerPlayer p : world.m_6907_()) {
                world.m_8624_(p, this.m_5967_(), true, this.m_20185_(), this.m_20186_() + 0.4, this.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
        int timeUntilHit = 8;
        if (this.m_19749_() instanceof SummonerEntity) {
            SummonerEntity summoner = (SummonerEntity)this.m_19749_();
            timeUntilHit = summoner.getDifficultyID() == ISkyBoss.BossLevel.SILVER.getId() ? 8 : (summoner.getDifficultyID() == ISkyBoss.BossLevel.GOLD.getId() ? 10 : (summoner.getDifficultyID() >= ISkyBoss.BossLevel.PLATINUM.getId() ? 14 : 0));
        }
        ArrayList list = Lists.newArrayList((Iterable)this.f_19853_.m_45933_((Entity)this, this.m_20191_().m_82400_(1.5)));
        for (Entity e : list) {
            if (e == null || !(e instanceof LivingEntity) || ((LivingEntity)e).f_19802_ > timeUntilHit || this.m_19749_() == null || e == this.m_19749_() || e.m_7307_(this.m_19749_())) continue;
            this.causeDamage(e, Math.max(1.0f, 3.0f / ((float)list.size() * 0.5f)));
        }
        if (!this.f_19853_.f_46443_ && this.f_19797_ > 120) {
            this.vanish();
        }
    }

    public void causeDamage(Entity entity, float amount) {
        boolean flag = entity.m_6469_(SkiesDamageSources.instance.fluctuantSphere((Entity)this, this.m_19749_()), amount);
        if (entity instanceof LivingEntity && flag && this.f_19853_ instanceof ServerLevel) {
            GeometryHelper.drawParticleLine((ServerLevel)this.f_19853_, (ParticleOptions)SkiesParticles.FLUCTUANT_SPHERE_BEAM, this.m_20182_().m_82520_(0.0, 0.5, 0.0), new Vec3(entity.m_20185_(), entity.m_20186_() + (double)(entity.m_20206_() / 2.0f), entity.m_20189_()), 0.2, 0.0, true);
        }
    }

    public void vanish() {
        if (this.f_19853_ instanceof ServerLevel) {
            double d0 = this.f_19796_.m_188583_() * 0.02;
            double d1 = this.f_19796_.m_188583_() * 0.02;
            double d2 = this.f_19796_.m_188583_() * 0.02;
            double d3 = 10.0;
            ((ServerLevel)this.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123759_, this.m_20185_() + (double)(this.f_19796_.m_188501_() * this.m_20205_() * 2.0f) - (double)this.m_20205_() - d0 * d3, this.m_20186_() + (double)(this.f_19796_.m_188501_() * this.m_20206_()) - d1 * d3, this.m_20189_() + (double)(this.f_19796_.m_188501_() * this.m_20205_() * 2.0f) - (double)this.m_20205_() - d2 * d3, 20, d0, d1, d2, 0.1);
        }
        this.m_146870_();
        this.f_19853_.m_5594_((Player)null, this.m_20183_(), SkiesSounds.ENTITY_FLUCTUANT_SPHERE_DISAPPEAR, SoundSource.HOSTILE, 1.0f, 2.0f);
    }

    protected ParticleOptions m_5967_() {
        return SkiesParticles.FLUCTUANT_SPHERE;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        return false;
    }

    protected boolean m_5931_() {
        return false;
    }

    protected float m_6884_() {
        return 0.7f;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

