/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.client.gui.screen.widgets;

import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.BlueSkiesConfig;
import com.legacy.blue_skies.capability.SkiesPlayer;
import com.legacy.blue_skies.client.SkiesClientUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.CreativeModeTabs;

public class SimpleInventoryTabButton
extends Button {
    private static final ResourceLocation TEXTURE = BlueSkies.locate("textures/gui/inventory_tabs_simple.png");
    private final int textureIndex;
    private final int posIndex;
    private final boolean enabled;
    private final Screen parentGui;
    private final SoundEvent openSound;
    private boolean isRecipeOpen = false;

    public SimpleInventoryTabButton(int textureIndex, Screen parentGui, boolean enabled, int posIndex, Button.OnPress onPress) {
        this(textureIndex, parentGui, enabled, posIndex, onPress, (SoundEvent)SoundEvents.f_12490_.get());
    }

    public SimpleInventoryTabButton(int textureIndex, Screen parentGui, boolean enabled, int posIndex, Button.OnPress onPress, SoundEvent openSound) {
        super(parentGui.f_96543_ / 2 + BlueSkiesConfig.CLIENT.getInventoryTabX() + (BlueSkiesConfig.CLIENT.areInventoryTabsVertical() ? 0 : posIndex) * 25, parentGui.f_96544_ / 2 - BlueSkiesConfig.CLIENT.getInventoryTabY() + (BlueSkiesConfig.CLIENT.areInventoryTabsVertical() ? posIndex : 0) * 22, 25, 22, (Component)Component.m_237119_(), onPress, Button.f_252438_);
        this.textureIndex = textureIndex;
        this.posIndex = posIndex;
        this.enabled = enabled;
        this.parentGui = parentGui;
        this.openSound = openSound;
    }

    public void m_86412_(PoseStack matrix, int mouseX, int mouseY, float partialTicks) {
        if (this.f_93624_) {
            Screen screen;
            boolean wasRecipeOpen = this.isRecipeOpen;
            boolean bl = this.isRecipeOpen = this.parentGui.getClass() == InventoryScreen.class && ((InventoryScreen)this.parentGui).m_5564_().m_100385_();
            if (wasRecipeOpen != this.isRecipeOpen) {
                this.m_252865_(this.isRecipeOpen ? this.m_252754_() + 77 : this.m_252754_() - 77);
            }
            if ((screen = this.parentGui) instanceof CreativeModeInventoryScreen) {
                CreativeModeInventoryScreen c = (CreativeModeInventoryScreen)screen;
                this.f_93624_ = CreativeModeInventoryScreen.f_98507_ == CreativeModeTabs.f_257039_;
                this.m_252865_(this.parentGui.f_96543_ / 2 + (this.parentGui.f_96543_ % 2 == 0 ? -123 : -122));
                this.m_253211_(this.parentGui.f_96544_ / 2 - 68 + this.posIndex * 22);
            }
        } else if (this.parentGui instanceof CreativeModeInventoryScreen) {
            this.f_93624_ = CreativeModeInventoryScreen.f_98507_ == CreativeModeTabs.f_257039_;
        }
        super.m_86412_(matrix, mouseX, mouseY, partialTicks);
        if (this.textureIndex == 3) {
            SkiesPlayer.ifPresent(Minecraft.m_91087_().f_91074_, skyPlayer -> {
                if (!skyPlayer.hasOpenedBlueLore()) {
                    SkiesClientUtil.renderExclamation(matrix, this.m_252754_() + 18, this.m_252907_() + 3);
                }
            });
        }
    }

    public void m_87963_(PoseStack matrix, int mouseX, int mouseY, float partialTicks) {
        SkiesClientUtil.bind(TEXTURE);
        int texStartX = 25 * this.textureIndex;
        SimpleInventoryTabButton.m_93133_((PoseStack)matrix, (int)this.m_252754_(), (int)this.m_252907_(), (float)texStartX, (float)(this.m_198029_() && this.enabled ? 0 : 22), (int)25, (int)22, (int)128, (int)128);
    }

    public void m_5691_() {
        if (this.enabled) {
            this.f_93717_.m_93750_((Button)this);
        }
    }

    public void m_7435_(SoundManager soundHandler) {
        soundHandler.m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)this.openSound, (float)1.0f));
    }
}

