/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.miningdimension.block;

import de.maxhenkel.miningdimension.Main;
import de.maxhenkel.miningdimension.corelib.block.IItemBlock;
import de.maxhenkel.miningdimension.dimension.MiningDimensionTeleporter;
import de.maxhenkel.miningdimension.tileentity.TileentityTeleporter;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.util.ITeleporter;

public class BlockTeleporter
extends Block
implements EntityBlock,
IItemBlock {
    public BlockTeleporter() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60978_(3.0f).m_60918_(SoundType.f_56736_));
    }

    @Override
    public Item toItem() {
        return new BlockItem((Block)this, new Item.Properties());
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        if (player instanceof ServerPlayer) {
            this.transferPlayer((ServerPlayer)player, pos);
        }
        return InteractionResult.SUCCESS;
    }

    public boolean transferPlayer(ServerPlayer player, BlockPos pos) {
        if (player.m_20202_() != null || player.m_20160_()) {
            return false;
        }
        if (player.f_19853_.m_46472_().equals(Main.MINING_DIMENSION)) {
            ServerLevel teleportWorld = player.f_8924_.m_129880_(Main.SERVER_CONFIG.overworldDimension);
            if (teleportWorld == null) {
                Main.LOGGER.error("Could not find overworld dimension '{}'.", (Object)Main.SERVER_CONFIG.overworldDimension.m_211136_());
                return false;
            }
            player.changeDimension(teleportWorld, (ITeleporter)new MiningDimensionTeleporter(pos));
        } else if (player.f_19853_.m_46472_().equals(Main.SERVER_CONFIG.overworldDimension)) {
            ServerLevel teleportWorld = player.f_8924_.m_129880_(Main.MINING_DIMENSION);
            if (teleportWorld == null) {
                Main.LOGGER.error("Could not find mining dimension.");
                return false;
            }
            player.changeDimension(teleportWorld, (ITeleporter)new MiningDimensionTeleporter(pos));
        } else {
            player.m_5661_((Component)Component.m_237115_((String)"message.wrong_dimension"), true);
        }
        return true;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TileentityTeleporter(pos, state);
    }
}

