/*
 * Decompiled with CFR 0.152.
 */
package net.ggwpgaming.automessage.util;

import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import net.ggwpgaming.automessage.AutoMessage;
import net.ggwpgaming.automessage.util.ValuesNode;
import org.slf4j.Logger;

public class AMIO {
    public static final String AMLogPrefix = "[AUTOMESSAGE LOG] ";
    public static final String AMClientLogName = "automessage-CLIENT_VIEWCOUNT_LOG.txt";
    private static final Logger LOGGER = LogUtils.getLogger();

    public static void main(String[] args) {
        LOGGER.debug("You ran AMIO as a standalone program!");
    }

    public static void writeLinkedListToFile(LinkedList<ValuesNode> linkedList, String fileName) {
        try (FileWriter writer = new FileWriter(fileName);){
            for (ValuesNode node : linkedList) {
                writer.write(node.UUID + "," + node.values + "\n");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static LinkedList<ValuesNode> readLinkedListFromFile(String fileName) {
        LinkedList<ValuesNode> linkedList = new LinkedList<ValuesNode>();
        try (BufferedReader reader = new BufferedReader(new FileReader(fileName));){
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.isEmpty()) continue;
                String[] parts = line.split(",", 2);
                if (parts.length >= 2) {
                    String name = parts[0];
                    String valuesString = parts[1].trim().substring(1, parts[1].length() - 1);
                    String[] parts2 = valuesString.split(",");
                    ArrayList<Integer> values = new ArrayList<Integer>();
                    for (String part : parts2) {
                        if ((part = part.trim()).isEmpty()) continue;
                        values.add(Integer.valueOf(part));
                    }
                    linkedList.add(new ValuesNode(name, values));
                    continue;
                }
                AutoMessage.println("Invalid line format: " + line);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return linkedList;
    }
}

