/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.ad_astra.common.networking.packet.server;

import com.teamresourceful.resourcefullib.common.networking.base.Packet;
import com.teamresourceful.resourcefullib.common.networking.base.PacketContext;
import com.teamresourceful.resourcefullib.common.networking.base.PacketHandler;
import earth.terrarium.ad_astra.common.screen.menu.AbstractMachineMenu;
import earth.terrarium.ad_astra.common.screen.menu.AbstractVehicleMenu;
import earth.terrarium.botarium.common.fluid.base.FluidHolder;
import earth.terrarium.botarium.common.fluid.utils.FluidHooks;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.material.Fluid;

public record MachineInfoPacket(long energy, List<FluidHolder> fluidHolders) implements Packet<MachineInfoPacket>
{
    public static final ResourceLocation ID = new ResourceLocation("ad_astra", "machine_info_packet");
    public static final Handler HANDLER = new Handler();

    public ResourceLocation getID() {
        return ID;
    }

    public PacketHandler<MachineInfoPacket> getHandler() {
        return HANDLER;
    }

    private static class Handler
    implements PacketHandler<MachineInfoPacket> {
        private Handler() {
        }

        public void encode(MachineInfoPacket packet, FriendlyByteBuf buf) {
            buf.writeLong(packet.energy());
            buf.m_236828_(packet.fluidHolders, (buf2, fluid) -> {
                buf2.m_130085_(BuiltInRegistries.f_257020_.m_7981_((Object)fluid.getFluid()));
                buf2.writeLong(fluid.getFluidAmount());
            });
        }

        public MachineInfoPacket decode(FriendlyByteBuf buf) {
            return new MachineInfoPacket(buf.readLong(), buf.m_236845_(buf2 -> FluidHooks.newFluidHolder((Fluid)((Fluid)BuiltInRegistries.f_257020_.m_7745_(buf2.m_130281_())), (long)buf2.readLong(), null)));
        }

        public PacketContext handle(MachineInfoPacket packet) {
            return (player, level) -> {
                AbstractContainerMenu patt2160$temp = player.f_36096_;
                if (patt2160$temp instanceof AbstractMachineMenu) {
                    AbstractMachineMenu handler = (AbstractMachineMenu)patt2160$temp;
                    handler.setEnergyAmount(packet.energy());
                    handler.setFluids(packet.fluidHolders);
                } else {
                    AbstractContainerMenu patt2375$temp = player.f_36096_;
                    if (patt2375$temp instanceof AbstractVehicleMenu) {
                        AbstractVehicleMenu handler = (AbstractVehicleMenu)patt2375$temp;
                        handler.setFluids(packet.fluidHolders);
                    }
                }
            };
        }
    }
}

