/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.ad_astra.common.item.vehicle;

import earth.terrarium.ad_astra.common.block.door.LocationState;
import earth.terrarium.ad_astra.common.block.launchpad.LaunchPad;
import earth.terrarium.ad_astra.common.entity.vehicle.Rocket;
import earth.terrarium.ad_astra.common.entity.vehicle.RocketTier1;
import earth.terrarium.ad_astra.common.entity.vehicle.RocketTier2;
import earth.terrarium.ad_astra.common.entity.vehicle.RocketTier3;
import earth.terrarium.ad_astra.common.entity.vehicle.RocketTier4;
import earth.terrarium.ad_astra.common.item.vehicle.VehicleItem;
import earth.terrarium.botarium.common.fluid.base.PlatformFluidItemHandler;
import earth.terrarium.botarium.common.fluid.utils.FluidHooks;
import earth.terrarium.botarium.common.item.ItemStackHolder;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;

public class RocketItem<T extends Rocket>
extends VehicleItem {
    private final int tier;

    public RocketItem(int tier, Item.Properties properties) {
        super(properties);
        this.tier = tier;
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext context) {
        Level level = context.m_43725_();
        if (!level.f_46443_) {
            ItemStackHolder rocketStack;
            Item z2;
            BlockPos pos = context.m_8083_();
            BlockState state = level.m_8055_(pos);
            Player player = context.m_43723_();
            if (player == null) {
                return InteractionResult.FAIL;
            }
            for (int x = pos.m_123341_() - 1; x < pos.m_123341_() + 2; ++x) {
                for (int y = pos.m_123342_() + 1; y < pos.m_123342_() + 9; ++y) {
                    for (int z2 = pos.m_123343_() - 1; z2 < pos.m_123343_() + 2; ++z2) {
                        BlockPos testBlockPos = new BlockPos(x, y, z2);
                        BlockState testBlock = level.m_8055_(testBlockPos);
                        if (testBlock.m_60795_() || testBlock.m_60734_() instanceof LiquidBlock) continue;
                        return InteractionResult.FAIL;
                    }
                }
            }
            if (state.m_60734_() instanceof LaunchPad && ((LocationState)((Object)state.m_61143_(LaunchPad.LOCATION))).equals((Object)LocationState.CENTER) && (z2 = (rocketStack = new ItemStackHolder(player.m_21120_(context.m_43724_()))).getStack().m_41720_()) instanceof RocketItem) {
                RocketItem rocket = (RocketItem)z2;
                Rocket rocketEntity = null;
                int tier = rocket.getTier();
                switch (tier) {
                    case 1: {
                        rocketEntity = new RocketTier1(level);
                        break;
                    }
                    case 2: {
                        rocketEntity = new RocketTier2(level);
                        break;
                    }
                    case 3: {
                        rocketEntity = new RocketTier3(level);
                        break;
                    }
                    case 4: {
                        rocketEntity = new RocketTier4(level);
                    }
                }
                if (rocketEntity != null) {
                    CompoundTag nbt;
                    AABB scanAbove = new AABB((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (double)(pos.m_123341_() + 1), (double)(pos.m_123342_() + 1), (double)(pos.m_123343_() + 1));
                    List entities = level.m_6443_(Rocket.class, scanAbove, entity -> true);
                    if (!entities.isEmpty()) {
                        return InteractionResult.PASS;
                    }
                    PlatformFluidItemHandler fluidItemHandler = FluidHooks.getItemFluidManager((ItemStack)rocketStack.getStack());
                    if (fluidItemHandler.extractFluid(rocketStack, fluidItemHandler.getFluidInTank(0), true).getFluidAmount() > 0L) {
                        rocketEntity.getTank().insertFluid(fluidItemHandler.extractFluid(rocketStack, fluidItemHandler.getFluidInTank(0), false), false);
                    }
                    if ((nbt = rocketStack.getStack().m_41784_()).m_128441_("Inventory")) {
                        rocketEntity.getInventory().m_7797_(nbt.m_128437_("Inventory", 10));
                    }
                    rocketEntity.assignLaunchPad(true);
                    level.m_5594_(null, pos, SoundEvents.f_12200_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    rocketEntity.m_6034_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.1, (double)pos.m_123343_() + 0.5);
                    rocketEntity.m_146922_(Math.round((player.m_146908_() + 180.0f) / 90.0f) * 90);
                    level.m_7967_((Entity)rocketEntity);
                    if (rocketStack.isDirty()) {
                        player.m_21008_(context.m_43724_(), rocketStack.getStack());
                    }
                    player.m_21120_(context.m_43724_()).m_41774_(1);
                    return InteractionResult.SUCCESS;
                }
            }
        }
        return InteractionResult.PASS;
    }

    public int getTier() {
        return this.tier;
    }

    @Override
    public long getTankSize() {
        return FluidHooks.buckets((double)3.0);
    }
}

