/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.ad_astra.common.block.pipe;

import earth.terrarium.ad_astra.common.block.pipe.InteractablePipe;
import earth.terrarium.ad_astra.common.block.pipe.Pipe;
import earth.terrarium.ad_astra.common.block.pipe.PipeBlock;
import earth.terrarium.ad_astra.common.block.pipe.PipeDuctBlock;
import earth.terrarium.ad_astra.common.block.pipe.PipeState;
import earth.terrarium.ad_astra.common.registry.ModBlockEntityTypes;
import earth.terrarium.botarium.common.energy.base.PlatformEnergyManager;
import earth.terrarium.botarium.common.energy.util.EnergyHooks;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class CableBlockEntity
extends BlockEntity
implements InteractablePipe<PlatformEnergyManager> {
    private final List<InteractablePipe.Node<PlatformEnergyManager>> consumers = new ArrayList<InteractablePipe.Node<PlatformEnergyManager>>();
    private InteractablePipe.Node<PlatformEnergyManager> source;

    public CableBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntityTypes.CABLE.get(), pos, state);
    }

    @Override
    public boolean supportsAutoExtract() {
        return true;
    }

    @Override
    public boolean canConnectTo(BlockEntity next, Direction direction, BlockPos pos) {
        return true;
    }

    @Override
    public void insertInto(PlatformEnergyManager consumer, Direction direction, BlockPos pos) {
        if (this.f_58857_ == null) {
            return;
        }
        BlockState state = this.m_58900_();
        BlockState state2 = this.f_58857_.m_8055_(pos);
        if (state.m_60795_() || state2.m_60795_()) {
            return;
        }
        PlatformEnergyManager input = null;
        PlatformEnergyManager output = null;
        if (!(state.m_60734_() instanceof PipeDuctBlock) && !(state2.m_60734_() instanceof PipeDuctBlock)) {
            if (this.getSource().storage() == null || this.getConsumers().isEmpty()) {
                return;
            }
            Optional optionalPipeState = state.m_61145_((Property)PipeBlock.DIRECTIONS.get(this.getSource().direction()));
            Optional optionalPipeState2 = state2.m_61145_((Property)PipeBlock.DIRECTIONS.get(direction));
            if (optionalPipeState.isEmpty() || optionalPipeState2.isEmpty()) {
                return;
            }
            PipeState pipeState = (PipeState)((Object)optionalPipeState.get());
            PipeState pipeState2 = (PipeState)((Object)optionalPipeState2.get());
            if (pipeState == PipeState.INSERT && pipeState2 == PipeState.INSERT) {
                return;
            }
            if (pipeState == PipeState.EXTRACT && pipeState2 == PipeState.EXTRACT) {
                return;
            }
            if (pipeState == PipeState.NONE || pipeState2 == PipeState.NONE) {
                return;
            }
            if (pipeState2 == PipeState.EXTRACT || pipeState == PipeState.INSERT) {
                input = consumer;
                output = this.source.storage();
            } else {
                input = this.source.storage();
                output = consumer;
            }
        }
        if (input == null || output == null) {
            return;
        }
        EnergyHooks.moveEnergy(input, output, (long)Math.max(0L, this.getTransferAmount() / (long)this.getConsumers().size()));
    }

    @Override
    public PlatformEnergyManager getInteraction(Level level, BlockPos pos, Direction direction) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity != null) {
            return EnergyHooks.safeGetBlockEnergyManager((BlockEntity)blockEntity, (Direction)direction).orElse(null);
        }
        return null;
    }

    @Override
    public InteractablePipe.Node<PlatformEnergyManager> getSource() {
        return this.source;
    }

    @Override
    public void setSource(InteractablePipe.Node<PlatformEnergyManager> source) {
        this.source = source;
    }

    @Override
    public void clearSource() {
        this.source = null;
    }

    @Override
    public List<InteractablePipe.Node<PlatformEnergyManager>> getConsumers() {
        return this.consumers;
    }

    @Override
    public int getWorkTime() {
        return 5;
    }

    @Override
    public Level getPipelevel() {
        return this.f_58857_;
    }

    @Override
    public long getTransferAmount() {
        Block block = this.m_58900_().m_60734_();
        if (block instanceof Pipe) {
            Pipe pipe = (Pipe)block;
            return pipe.getTransferRate();
        }
        return 0L;
    }

    @Override
    public BlockPos getPipePos() {
        return this.m_58899_();
    }
}

