/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.ad_astra.common.block.machine.entity;

import earth.terrarium.ad_astra.common.block.machine.AbstractMachineBlock;
import earth.terrarium.ad_astra.common.block.machine.entity.AbstractMachineBlockEntity;
import earth.terrarium.ad_astra.common.config.WaterPumpConfig;
import earth.terrarium.ad_astra.common.registry.ModBlockEntityTypes;
import earth.terrarium.ad_astra.common.registry.ModParticleTypes;
import earth.terrarium.ad_astra.common.screen.menu.WaterPumpMenu;
import earth.terrarium.ad_astra.common.util.ModUtils;
import earth.terrarium.botarium.common.energy.base.EnergyAttachment;
import earth.terrarium.botarium.common.energy.base.EnergyContainer;
import earth.terrarium.botarium.common.energy.impl.InsertOnlyEnergyContainer;
import earth.terrarium.botarium.common.energy.impl.WrappedBlockEnergyContainer;
import earth.terrarium.botarium.common.fluid.base.FluidAttachment;
import earth.terrarium.botarium.common.fluid.base.FluidContainer;
import earth.terrarium.botarium.common.fluid.base.FluidHolder;
import earth.terrarium.botarium.common.fluid.impl.SimpleFluidContainer;
import earth.terrarium.botarium.common.fluid.impl.WrappedBlockFluidContainer;
import earth.terrarium.botarium.common.fluid.utils.FluidHooks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.WaterFluid;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WaterPumpBlockEntity
extends AbstractMachineBlockEntity
implements FluidAttachment.Block,
EnergyAttachment.Block {
    private WrappedBlockEnergyContainer energyContainer;
    private long waterExtracted;
    private WrappedBlockFluidContainer tank;

    public WaterPumpBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModBlockEntityTypes.WATER_PUMP.get(), blockPos, blockState);
    }

    @Override
    @Nullable
    public AbstractContainerMenu m_7208_(int syncId, @NotNull Inventory inv, @NotNull Player player) {
        return new WaterPumpMenu(syncId, inv, this);
    }

    @Override
    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.waterExtracted = nbt.m_128454_("WaterExtracted");
    }

    @Override
    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128356_("WaterExtracted", this.waterExtracted);
    }

    @Override
    public void tick() {
        if (this.f_58857_ == null) {
            return;
        }
        if (!this.f_58857_.m_5776_()) {
            BlockPos below = this.m_58899_().m_7495_();
            FluidState water = this.f_58857_.m_6425_(below);
            if (((FluidHolder)this.getFluidContainer(this).getFluids().get(0)).getFluidAmount() < this.getFluidContainer(this).getTankCapacity(0)) {
                if (water.m_76152_() instanceof WaterFluid.Source) {
                    FluidHolder waterFluid = FluidHooks.newFluidHolder((Fluid)Fluids.f_76193_, (long)WaterPumpConfig.transferPerTick, null);
                    if (!((Boolean)this.m_58900_().m_61143_((Property)AbstractMachineBlock.POWERED)).booleanValue() && this.getEnergyStorage(this).internalExtract(this.getEnergyPerTick(), true) > 0L && this.getFluidContainer(this).insertFluid(waterFluid, true) > 0L) {
                        this.setActive(true);
                        ModUtils.spawnForcedParticles((ServerLevel)this.f_58857_, (SimpleParticleType)ModParticleTypes.OXYGEN_BUBBLE.get(), (double)this.m_58899_().m_123341_() + 0.5, (double)this.m_58899_().m_123342_() - 0.5, (double)this.m_58899_().m_123343_() + 0.5, 1, 0.0, 0.0, 0.0, 0.01);
                        this.getEnergyStorage(this).internalExtract(this.getEnergyPerTick(), false);
                        this.waterExtracted += WaterPumpConfig.transferPerTick;
                        this.getFluidContainer(this).insertFluid(waterFluid, false);
                    } else {
                        this.setActive(false);
                    }
                    if (WaterPumpConfig.deleteWaterBelowWaterPump && this.waterExtracted >= FluidHooks.buckets((double)1.0)) {
                        this.waterExtracted = 0L;
                        BlockState blockState = this.f_58857_.m_8055_(below);
                        if (blockState.m_61138_((Property)BlockStateProperties.f_61362_)) {
                            this.f_58857_.m_46597_(below, (BlockState)blockState.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false)));
                        } else {
                            this.f_58857_.m_46597_(below, Blocks.f_50016_.m_49966_());
                        }
                    }
                }
            } else {
                this.setActive(false);
            }
            if (this.getEnergyStorage(this).internalExtract(this.getEnergyPerTick(), true) > 0L && !this.getFluidContainer(this).isEmpty()) {
                FluidHolder fluid = FluidHooks.newFluidHolder((Fluid)((FluidHolder)this.getFluidContainer(this).getFluids().get(0)).getFluid(), (long)(WaterPumpConfig.transferPerTick * 2L), (CompoundTag)((FluidHolder)this.getFluidContainer(this).getFluids().get(0)).getCompound());
                for (Direction direction : Direction.values()) {
                    if (FluidHooks.moveBlockToBlockFluid((BlockEntity)this, (Direction)direction.m_122424_(), (BlockEntity)this.f_58857_.m_7702_(this.f_58858_.m_121945_(direction)), (Direction)direction, (FluidHolder)fluid) <= 0L) continue;
                    this.getEnergyStorage(this).internalExtract(this.getEnergyPerTick(), false);
                    break;
                }
            }
        }
    }

    public long getEnergyPerTick() {
        return WaterPumpConfig.energyPerTick;
    }

    public long getMaxCapacity() {
        return this.getEnergyStorage(this).getMaxCapacity();
    }

    public WrappedBlockEnergyContainer getEnergyStorage(BlockEntity holder) {
        return this.energyContainer == null ? (this.energyContainer = new WrappedBlockEnergyContainer((BlockEntity)this, (EnergyContainer)new InsertOnlyEnergyContainer(WaterPumpConfig.maxEnergy))) : this.energyContainer;
    }

    public WrappedBlockFluidContainer getFluidContainer(BlockEntity holder) {
        return this.tank == null ? (this.tank = new WrappedBlockFluidContainer((BlockEntity)this, (FluidContainer)new SimpleFluidContainer(i -> WaterPumpConfig.tankSize, 1, (amount, fluid) -> true))) : this.tank;
    }
}

