/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.ad_astra.client.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import com.teamresourceful.resourcefullib.common.networking.base.Packet;
import earth.terrarium.ad_astra.client.screen.AbstractMachineScreen;
import earth.terrarium.ad_astra.client.screen.GuiUtil;
import earth.terrarium.ad_astra.client.screen.util.ButtonType;
import earth.terrarium.ad_astra.client.screen.util.CustomButton;
import earth.terrarium.ad_astra.client.screen.util.PlanetSelectionScreen;
import earth.terrarium.ad_astra.client.screen.util.ScreenUtils;
import earth.terrarium.ad_astra.common.block.machine.entity.OxygenDistributorBlockEntity;
import earth.terrarium.ad_astra.common.config.OxygenDistributorConfig;
import earth.terrarium.ad_astra.common.data.ButtonColor;
import earth.terrarium.ad_astra.common.networking.NetworkHandling;
import earth.terrarium.ad_astra.common.networking.packet.client.ToggleDistributorPacket;
import earth.terrarium.ad_astra.common.screen.menu.OxygenDistributorMenu;
import earth.terrarium.ad_astra.common.util.OxygenUtils;
import earth.terrarium.botarium.common.fluid.utils.FluidHooks;
import java.awt.Color;
import java.awt.Rectangle;
import java.util.Arrays;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class OxygenDistributorScreen
extends AbstractMachineScreen<OxygenDistributorBlockEntity, OxygenDistributorMenu> {
    public static final int INPUT_TANK_LEFT = 50;
    public static final int INPUT_TANK_TOP = 80;
    public static final int OUTPUT_TANK_LEFT = 114;
    public static final int OUTPUT_TANK_TOP = 80;
    public static final int ENERGY_LEFT = 147;
    public static final int ENERGY_TOP = 82;
    private static final ResourceLocation TEXTURE = new ResourceLocation("ad_astra", "textures/gui/screens/oxygen_distributor.png");
    final Component SHOW_TEXT = ScreenUtils.createText("show");
    final Component HIDE_TEXT = ScreenUtils.createText("hide");
    CustomButton visibleButton;
    private boolean displayConversionEnergyCost = false;

    public OxygenDistributorScreen(OxygenDistributorMenu handler, Inventory inventory, Component title) {
        super(handler, inventory, title, TEXTURE);
        this.f_97726_ = 177;
        this.f_97727_ = 244;
        this.f_97731_ = this.f_97727_ - 92;
        this.f_97729_ = 67;
    }

    @Override
    protected void m_7286_(PoseStack poseStack, float delta, int mouseX, int mouseY) {
        boolean oxygenLeak;
        super.m_7286_(poseStack, delta, mouseX, mouseY);
        GuiUtil.drawEnergy(poseStack, this.f_97735_ + 147, this.f_97736_ + 82, ((OxygenDistributorMenu)this.f_97732_).getEnergyAmount(), ((OxygenDistributorBlockEntity)this.machine).getMaxCapacity());
        GuiUtil.drawFluidTank(poseStack, this.f_97735_ + 50, this.f_97736_ + 80, ((OxygenDistributorBlockEntity)this.machine).getInputTankCapacity(), ((OxygenDistributorMenu)this.f_97732_).getFluids().get(0));
        GuiUtil.drawFluidTank(poseStack, this.f_97735_ + 114, this.f_97736_ + 80, ((OxygenDistributorBlockEntity)this.machine).getOutputTankCapacity(), ((OxygenDistributorMenu)this.f_97732_).getFluids().get(1));
        this.visibleButton.m_93666_(((OxygenDistributorBlockEntity)this.machine).shouldShowOxygen() ? this.HIDE_TEXT : this.SHOW_TEXT);
        boolean bl = oxygenLeak = OxygenUtils.getOxygenBlocksCount(((OxygenDistributorBlockEntity)this.machine).m_58904_(), ((OxygenDistributorBlockEntity)this.machine).m_58899_()) >= OxygenDistributorConfig.maxBlockChecks;
        if (oxygenLeak) {
            GuiComponent.m_93208_((PoseStack)poseStack, (Font)this.f_96547_, (String)"\u26a0", (int)(this.f_96543_ / 2 - 85 + 7), (int)(this.f_96544_ / 2 - 137), (int)Color.YELLOW.getRGB());
        }
        if (OxygenUtils.getOxygenBlocksCount(((OxygenDistributorBlockEntity)this.machine).m_58904_(), ((OxygenDistributorBlockEntity)this.machine).m_58899_()) <= 0 && ((OxygenDistributorBlockEntity)this.machine).getEnergyStorage(this.machine).getStoredEnergy() > 0L && ((OxygenDistributorMenu)this.f_97732_).getFluids().get(1).getFluidAmount() > 0L) {
            GuiComponent.m_93208_((PoseStack)poseStack, (Font)this.f_96547_, (String)"\u26a0", (int)(this.f_96543_ / 2 - 67 + 7), (int)(this.f_96544_ / 2 - 137), (int)Color.YELLOW.getRGB());
        }
    }

    @Override
    public void m_86412_(PoseStack poseStack, int mouseX, int mouseY, float delta) {
        boolean oxygenLeak;
        super.m_86412_(poseStack, mouseX, mouseY, delta);
        if (GuiUtil.isHovering(this.getEnergyBounds(), mouseX, mouseY)) {
            GuiUtil.drawEnergyTooltip((Screen)this, poseStack, ((OxygenDistributorMenu)this.f_97732_).getEnergyAmount(), ((OxygenDistributorBlockEntity)this.machine).getMaxCapacity(), mouseX, mouseY);
        }
        if (GuiUtil.isHovering(this.getInputTankBounds(), mouseX, mouseY)) {
            GuiUtil.drawTankTooltip((Screen)this, poseStack, ((OxygenDistributorMenu)this.f_97732_).getFluids().get(0), ((OxygenDistributorBlockEntity)this.machine).getInputTankCapacity(), mouseX, mouseY);
        }
        if (GuiUtil.isHovering(this.getOutputTankBounds(), mouseX, mouseY)) {
            GuiUtil.drawTankTooltip((Screen)this, poseStack, ((OxygenDistributorMenu)this.f_97732_).getFluids().get(1), ((OxygenDistributorBlockEntity)this.machine).getOutputTankCapacity(), mouseX, mouseY);
        }
        int oxygenBlocksCount = OxygenUtils.getOxygenBlocksCount(((OxygenDistributorBlockEntity)this.machine).m_58904_(), ((OxygenDistributorBlockEntity)this.machine).m_58899_());
        boolean bl = oxygenLeak = OxygenUtils.getOxygenBlocksCount(((OxygenDistributorBlockEntity)this.machine).m_58904_(), ((OxygenDistributorBlockEntity)this.machine).m_58899_()) >= OxygenDistributorConfig.maxBlockChecks;
        if (oxygenLeak && GuiUtil.isHovering(this.getOxygenLeakWarningSignBounds(), mouseX, mouseY)) {
            this.m_96597_(poseStack, Arrays.asList(Component.m_237115_((String)"gauge_text.ad_astra.oxygen_leak_warning[0]"), Component.m_237115_((String)"gauge_text.ad_astra.oxygen_leak_warning[1]"), Component.m_237115_((String)"gauge_text.ad_astra.oxygen_leak_warning[2]"), Component.m_237115_((String)"gauge_text.ad_astra.oxygen_leak_warning[3]"), Component.m_237115_((String)"gauge_text.ad_astra.oxygen_leak_warning[4]"), Component.m_237115_((String)"gauge_text.ad_astra.oxygen_leak_warning[5]"), Component.m_237115_((String)"gauge_text.ad_astra.oxygen_leak_warning[6]"), Component.m_237115_((String)"gauge_text.ad_astra.oxygen_leak_warning[7]")), mouseX, mouseY);
        }
        if (oxygenBlocksCount <= 0 && ((OxygenDistributorBlockEntity)this.machine).getEnergyStorage(this.machine).getStoredEnergy() > 0L && ((OxygenDistributorMenu)this.f_97732_).getFluids().get(1).getFluidAmount() > 0L && GuiUtil.isHovering(this.getBlockedWarningSignBounds(), mouseX, mouseY)) {
            this.m_96597_(poseStack, Arrays.asList(Component.m_237115_((String)"gauge_text.ad_astra.blocked_warning[0]"), Component.m_237115_((String)"gauge_text.ad_astra.blocked_warning[1]")), mouseX, mouseY);
        }
    }

    @Override
    protected void m_7027_(PoseStack poseStack, int mouseX, int mouseY) {
        super.m_7027_(poseStack, mouseX, mouseY);
        long oxygenBlocksCount = OxygenUtils.getOxygenBlocksCount(((OxygenDistributorBlockEntity)this.machine).m_58904_(), ((OxygenDistributorBlockEntity)this.machine).m_58899_());
        poseStack.m_85836_();
        poseStack.m_85841_(0.9f, 0.9f, 0.9f);
        MutableComponent oxygenBlockText = Component.m_237115_((String)"gauge_text.ad_astra.oxygen_blocks");
        Component oxygenBlockAmount = Component.m_130674_((String)(oxygenBlocksCount + " / " + OxygenDistributorConfig.maxBlockChecks));
        int offset = 25;
        this.f_96547_.m_92889_(poseStack, (Component)oxygenBlockText, 11.0f, (float)(offset + 11), 6871413);
        this.f_96547_.m_92889_(poseStack, oxygenBlockAmount, 11.0f, (float)(offset + 24), 6871413);
        long energyUsagePerTick = ((OxygenDistributorBlockEntity)this.machine).getEnergyToConsume(oxygenBlocksCount, true);
        if (this.displayConversionEnergyCost) {
            energyUsagePerTick += ((OxygenDistributorBlockEntity)this.machine).getEnergyPerTick();
            this.displayConversionEnergyCost = false;
        } else if (((OxygenDistributorMenu)this.f_97732_).getFluids().get(0).getFluidAmount() > 0L && ((OxygenDistributorMenu)this.f_97732_).getFluids().get(1).getFluidAmount() < ((OxygenDistributorBlockEntity)this.machine).getOutputTankCapacity()) {
            energyUsagePerTick += ((OxygenDistributorBlockEntity)this.machine).getEnergyPerTick();
            this.displayConversionEnergyCost = true;
        }
        long oxygenUsagePerTick = ((OxygenDistributorBlockEntity)this.machine).getFluidToExtract(oxygenBlocksCount, true);
        float oxygenUsageRounded = FluidHooks.toMillibuckets((long)oxygenUsagePerTick);
        oxygenUsageRounded = (float)((double)Math.round((double)oxygenUsageRounded * 1000.0) / 1000.0);
        this.f_96547_.m_92889_(poseStack, (Component)Component.m_237110_((String)"gauge_text.ad_astra.energy_per_tick", (Object[])new Object[]{energyUsagePerTick}), 11.0f, (float)(offset - 17), 6871413);
        this.f_96547_.m_92889_(poseStack, (Component)Component.m_237110_((String)"gauge_text.ad_astra.fluid_per_tick", (Object[])new Object[]{Float.valueOf(oxygenUsageRounded)}), 11.0f, (float)(offset - 5), 6871413);
        poseStack.m_85849_();
    }

    protected void m_7856_() {
        super.m_7856_();
        OxygenDistributorBlockEntity oxygenDistributor = (OxygenDistributorBlockEntity)this.machine;
        this.visibleButton = new CustomButton(this.f_96543_ / 2 + 10, this.f_96544_ / 2 - 83, oxygenDistributor.shouldShowOxygen() ? this.HIDE_TEXT : this.SHOW_TEXT, ButtonType.STEEL, ButtonColor.WHITE, PlanetSelectionScreen.TooltipType.NONE, null, pressed -> {
            NetworkHandling.CHANNEL.sendToServer((Packet)new ToggleDistributorPacket(((OxygenDistributorBlockEntity)this.machine).m_58899_()));
            ((OxygenDistributorBlockEntity)this.machine).setShowOxygen(!oxygenDistributor.shouldShowOxygen());
        });
        this.visibleButton.doScissor = false;
        this.m_142416_((GuiEventListener)this.visibleButton);
    }

    public Rectangle getRecipeBounds() {
        return new Rectangle(this.f_97735_ + 76, this.f_97736_ + 95, 26, 21);
    }

    public Rectangle getInputTankBounds() {
        return GuiUtil.getFluidTankBounds(this.f_97735_ + 50, this.f_97736_ + 80);
    }

    public Rectangle getOutputTankBounds() {
        return GuiUtil.getFluidTankBounds(this.f_97735_ + 114, this.f_97736_ + 80);
    }

    public Rectangle getOxygenLeakWarningSignBounds() {
        return new Rectangle(this.f_96543_ / 2 - 85, this.f_96544_ / 2 - 137, 14, 15);
    }

    public Rectangle getBlockedWarningSignBounds() {
        return new Rectangle(this.f_96543_ / 2 - 67, this.f_96544_ / 2 - 137, 14, 15);
    }

    public Rectangle getEnergyBounds() {
        return GuiUtil.getEnergyBounds(this.f_97735_ + 147, this.f_97736_ + 82);
    }

    @Override
    public int getTextColour() {
        return 2893870;
    }
}

