/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.ad_astra.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.teamresourceful.resourcefullib.client.scissor.ClosingScissorBox;
import com.teamresourceful.resourcefullib.client.utils.RenderUtils;
import earth.terrarium.ad_astra.client.ClientPlatformUtils;
import earth.terrarium.botarium.common.fluid.base.FluidHolder;
import earth.terrarium.botarium.common.fluid.utils.ClientFluidHooks;
import earth.terrarium.botarium.common.fluid.utils.FluidHooks;
import java.awt.Rectangle;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class GuiUtil {
    public static final int FIRE_WIDTH = 14;
    public static final int FIRE_HEIGHT = 14;
    public static final int SNOWFLAKE_WIDTH = 13;
    public static final int SNOWFLAKE_HEIGHT = 13;
    public static final int SUN_WIDTH = 21;
    public static final int SUN_HEIGHT = 21;
    public static final int HAMMER_WIDTH = 13;
    public static final int HAMMER_HEIGHT = 13;
    public static final int ENERGY_WIDTH = 13;
    public static final int ENERGY_HEIGHT = 46;
    public static final int FLUID_TANK_WIDTH = 14;
    public static final int FLUID_TANK_HEIGHT = 48;
    public static final int ARROW_WIDTH = 24;
    public static final int ARROW_HEIGHT = 17;
    public static final ResourceLocation FIRE_TEXTURE = new ResourceLocation("ad_astra", "textures/gui/fire_on.png");
    public static final ResourceLocation SNOWFLAKE_TEXTURE = new ResourceLocation("ad_astra", "textures/gui/snowflake.png");
    public static final ResourceLocation SUN_TEXTURE = new ResourceLocation("ad_astra", "textures/gui/sun.png");
    public static final ResourceLocation HAMMER_TEXTURE = new ResourceLocation("ad_astra", "textures/gui/hammer.png");
    public static final ResourceLocation ENERGY_TEXTURE = new ResourceLocation("ad_astra", "textures/gui/energy_full.png");
    public static final ResourceLocation FLUID_TANK_TEXTURE = new ResourceLocation("ad_astra", "textures/gui/fluid_tank.png");
    public static final ResourceLocation ARROW_TEXTURE = new ResourceLocation("ad_astra", "textures/gui/arrow.png");

    public static boolean isHovering(Rectangle bounds, double x, double y) {
        double left = bounds.getX();
        double right = left + bounds.getWidth();
        double top = bounds.getY();
        double bottom = top + bounds.getHeight();
        return left <= x && x < right && top <= y && y < bottom;
    }

    public static Rectangle getFluidTankBounds(int x, int y) {
        return new Rectangle(x, y, 14, 48);
    }

    public static Rectangle getHammerBounds(int x, int y) {
        return new Rectangle(x, y, 13, 13);
    }

    public static Rectangle getEnergyBounds(int x, int y) {
        return new Rectangle(x, y, 13, 46);
    }

    public static Rectangle getFireBounds(int x, int y) {
        return new Rectangle(x, y, 14, 14);
    }

    public static void drawEnergy(PoseStack poseStack, int x, int y, long energy, long maxEnergy) {
        double ratio = maxEnergy > 0L ? (double)((float)energy / (float)maxEnergy) : 0.0;
        GuiUtil.drawVertical(poseStack, x, y, 13, 46, ENERGY_TEXTURE, ratio);
    }

    public static void drawFluidTank(PoseStack poseStack, int x, int y, long fluidCapacity, FluidHolder fluid) {
        double ratio = fluidCapacity > 0L ? (double)((float)fluid.getFluidAmount() / (float)fluidCapacity) : 0.0;
        GuiUtil.drawFluidTank(poseStack, x, y, ratio, fluid);
    }

    public static void drawFluidTank(PoseStack poseStack, int x, int y, double ratio, FluidHolder fluid) {
        GuiUtil.drawFluid(poseStack, x, y, ratio, fluid);
        RenderSystem.m_69478_();
        GuiUtil.drawVertical(poseStack, x, y, 14, 48, FLUID_TANK_TEXTURE, 1.0);
        RenderSystem.m_69461_();
    }

    private static void drawFluid(PoseStack poseStack, int x, int y, double ratio, FluidHolder fluid) {
        if (fluid.isEmpty()) {
            return;
        }
        TextureAtlasSprite sprite = ClientFluidHooks.getFluidSprite((FluidHolder)fluid);
        int colour = ClientFluidHooks.getFluidColor((FluidHolder)fluid);
        int spriteHeight = sprite.m_245424_().m_245330_();
        RenderSystem.m_157429_((float)((float)(colour >> 16 & 0xFF) / 255.0f), (float)((float)(colour >> 8 & 0xFF) / 255.0f), (float)((float)(colour & 0xFF) / 255.0f), (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)InventoryMenu.f_39692_);
        int calcHeight = (int)(49.0 * ratio);
        try (ClosingScissorBox ignored = RenderUtils.createScissorBox((Minecraft)Minecraft.m_91087_(), (PoseStack)poseStack, (int)x, (int)(y + 48 - calcHeight), (int)14, (int)calcHeight);){
            for (int i = 1; i < 4; ++i) {
                GuiComponent.m_93200_((PoseStack)poseStack, (int)(x + 1), (int)(48 + y - spriteHeight * i), (int)0, (int)12, (int)spriteHeight, (TextureAtlasSprite)sprite);
            }
        }
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void drawFire(PoseStack poseStack, int x, int y, int burnTime, int totalBurnTime) {
        double ratio = totalBurnTime > 0 ? (double)((float)burnTime / (float)totalBurnTime) : 0.0;
        GuiUtil.drawVertical(poseStack, x, y, 14, 14, FIRE_TEXTURE, ratio);
    }

    public static void drawSnowflake(PoseStack poseStack, int x, int y, int burnTime, int totalBurnTime) {
        double ratio = totalBurnTime > 0 ? (double)((float)burnTime / (float)totalBurnTime) : 0.0;
        GuiUtil.drawHorizontal(poseStack, x, y, 13, 13, SNOWFLAKE_TEXTURE, ratio);
    }

    public static void drawSun(PoseStack poseStack, int x, int y) {
        GuiUtil.drawHorizontal(poseStack, x, y, 21, 21, SUN_TEXTURE, 1.0);
    }

    public static void drawHammer(PoseStack poseStack, int x, int y, int burnTime, int totalBurnTime) {
        double ratio = totalBurnTime > 0 ? (double)((float)burnTime / (float)totalBurnTime) : 0.0;
        GuiUtil.drawHorizontal(poseStack, x, y, 13, 13, HAMMER_TEXTURE, ratio);
    }

    public static void drawVertical(PoseStack poseStack, int x, int y, int width, int height, ResourceLocation resource, double ratio) {
        int ratioHeight = (int)Math.ceil((double)height * ratio);
        int remainHeight = height - ratioHeight;
        RenderSystem.m_157456_((int)0, (ResourceLocation)resource);
        GuiComponent.m_93133_((PoseStack)poseStack, (int)x, (int)(y + remainHeight), (float)0.0f, (float)remainHeight, (int)width, (int)ratioHeight, (int)width, (int)height);
    }

    public static void drawVerticalReverse(PoseStack poseStack, int x, int y, int width, int height, ResourceLocation resource, double ratio) {
        int ratioHeight = (int)Math.ceil((double)height * ratio);
        int remainHeight = height - ratioHeight;
        RenderSystem.m_157456_((int)0, (ResourceLocation)resource);
        GuiComponent.m_93133_((PoseStack)poseStack, (int)x, (int)y, (float)0.0f, (float)0.0f, (int)width, (int)remainHeight, (int)width, (int)height);
    }

    public static void drawHorizontal(PoseStack poseStack, int x, int y, int width, int height, ResourceLocation resource, double ratio) {
        int ratioWidth = (int)Math.ceil((double)width * ratio);
        RenderSystem.m_157456_((int)0, (ResourceLocation)resource);
        GuiComponent.m_93133_((PoseStack)poseStack, (int)x, (int)y, (float)0.0f, (float)0.0f, (int)ratioWidth, (int)height, (int)width, (int)height);
    }

    public static void drawEnergyTooltip(Screen screen, PoseStack poseStack, long energy, long energyCapacity, int mouseX, int mouseY) {
        screen.m_96602_(poseStack, (Component)Component.m_237110_((String)"gauge_text.ad_astra.storage", (Object[])new Object[]{Float.valueOf(Mth.m_14036_((float)energy, (float)0.0f, (float)energyCapacity)), energyCapacity}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)), mouseX, mouseY);
    }

    public static void drawTankTooltip(Screen screen, PoseStack poseStack, FluidHolder tank, long capacity, int mouseX, int mouseY) {
        screen.m_96602_(poseStack, (Component)Component.m_237110_((String)"gauge_text.ad_astra.liquid_storage", (Object[])new Object[]{FluidHooks.toMillibuckets((long)tank.getFluidAmount()), FluidHooks.toMillibuckets((long)capacity)}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)).m_7220_(Component.m_130674_((String)", ")).m_7220_(ClientPlatformUtils.getFluidTranslation(tank.getFluid())), mouseX, mouseY);
    }

    public static class FloatGuiComponent {
        public static void drawTexture(PoseStack poseStack, float x, float y, float u, float v, int width, int height, int textureWidth, int textureHeight) {
            FloatGuiComponent.drawTexture(poseStack, x, y, width, height, u, v, width, height, textureWidth, textureHeight);
        }

        public static void drawTexture(PoseStack poseStack, float x, float y, int width, int height, float u, float v, int regionWidth, int regionHeight, int textureWidth, int textureHeight) {
            FloatGuiComponent.drawTexture(poseStack, x, x + (float)width, y, y + (float)height, 0, regionWidth, regionHeight, u, v, textureWidth, textureHeight);
        }

        private static void drawTexture(PoseStack poseStack, float x0, float x1, float y0, float y1, int z, int regionWidth, int regionHeight, float u, float v, int textureWidth, int textureHeight) {
            FloatGuiComponent.drawTexturedQuad(poseStack.m_85850_().m_252922_(), x0, x1, y0, y1, z, (u + 0.0f) / (float)textureWidth, (u + (float)regionWidth) / (float)textureWidth, (v + 0.0f) / (float)textureHeight, (v + (float)regionHeight) / (float)textureHeight);
        }

        private static void drawTexturedQuad(Matrix4f matrix, float x0, float x1, float y0, float y1, int z, float u0, float u1, float v0, float v1) {
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
            bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
            bufferBuilder.m_252986_(matrix, x0, y1, (float)z).m_7421_(u0, v1).m_5752_();
            bufferBuilder.m_252986_(matrix, x1, y1, (float)z).m_7421_(u1, v1).m_5752_();
            bufferBuilder.m_252986_(matrix, x1, y0, (float)z).m_7421_(u1, v0).m_5752_();
            bufferBuilder.m_252986_(matrix, x0, y0, (float)z).m_7421_(u0, v0).m_5752_();
            BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
        }
    }
}

