/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.ad_astra.client.renderer.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import earth.terrarium.ad_astra.client.AdAstraClient;
import earth.terrarium.ad_astra.common.block.door.SlidingDoorBlock;
import earth.terrarium.ad_astra.common.block.door.SlidingDoorBlockEntity;
import earth.terrarium.ad_astra.common.registry.ModBlocks;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SlidingDoorBlockEntityRenderer
implements BlockEntityRenderer<SlidingDoorBlockEntity> {
    public static final ResourceLocation IRON_SLIDING_DOOR_MODEL = new ResourceLocation("ad_astra", "block/door/iron_sliding_door");
    public static final ResourceLocation STEEL_SLIDING_DOOR_MODEL = new ResourceLocation("ad_astra", "block/door/steel_sliding_door");
    public static final ResourceLocation DESH_SLIDING_DOOR_MODEL = new ResourceLocation("ad_astra", "block/door/desh_sliding_door");
    public static final ResourceLocation OSTRUM_SLIDING_DOOR_MODEL = new ResourceLocation("ad_astra", "block/door/ostrum_sliding_door");
    public static final ResourceLocation CALORITE_SLIDING_DOOR_MODEL = new ResourceLocation("ad_astra", "block/door/calorite_sliding_door");
    public static final ResourceLocation AIRLOCK_MODEL = new ResourceLocation("ad_astra", "block/door/airlock");
    public static final ResourceLocation REINFORCED_DOOR_MODEL = new ResourceLocation("ad_astra", "block/door/reinforced_door");
    public static final ResourceLocation IRON_SLIDING_DOOR_MODEL_FLIPPED = new ResourceLocation("ad_astra", "block/door/iron_sliding_door_flipped");
    public static final ResourceLocation STEEL_SLIDING_DOOR_MODEL_FLIPPED = new ResourceLocation("ad_astra", "block/door/steel_sliding_door_flipped");
    public static final ResourceLocation DESH_SLIDING_DOOR_MODEL_FLIPPED = new ResourceLocation("ad_astra", "block/door/desh_sliding_door_flipped");
    public static final ResourceLocation OSTRUM_SLIDING_DOOR_MODEL_FLIPPED = new ResourceLocation("ad_astra", "block/door/ostrum_sliding_door_flipped");
    public static final ResourceLocation CALORITE_SLIDING_MODEL_FLIPPED = new ResourceLocation("ad_astra", "block/door/calorite_sliding_door_flipped");
    public static final ResourceLocation AIRLOCK_MODEL_FLIPPED = new ResourceLocation("ad_astra", "block/door/airlock_flipped");
    public static final ResourceLocation REINFORCED_DOOR_MODEL_FLIPPED = new ResourceLocation("ad_astra", "block/door/reinforced_door_flipped");

    public SlidingDoorBlockEntityRenderer(BlockEntityRendererProvider.Context ctx) {
    }

    public void render(SlidingDoorBlockEntity entity, float tickDelta, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        ResourceLocation doorModelFlipped;
        ResourceLocation doorModel;
        float slide = Mth.m_14179_((float)tickDelta, (float)entity.getPreviousSlideTicks(), (float)entity.getSlideTicks()) / 81.0f;
        Block type = entity.m_58900_().m_60734_();
        float offset = 0.0f;
        if (type.equals(ModBlocks.IRON_SLIDING_DOOR.get())) {
            doorModel = IRON_SLIDING_DOOR_MODEL;
            doorModelFlipped = IRON_SLIDING_DOOR_MODEL_FLIPPED;
        } else if (type.equals(ModBlocks.STEEL_SLIDING_DOOR.get())) {
            doorModel = STEEL_SLIDING_DOOR_MODEL;
            doorModelFlipped = STEEL_SLIDING_DOOR_MODEL_FLIPPED;
        } else if (type.equals(ModBlocks.DESH_SLIDING_DOOR.get())) {
            doorModel = DESH_SLIDING_DOOR_MODEL;
            doorModelFlipped = DESH_SLIDING_DOOR_MODEL_FLIPPED;
        } else if (type.equals(ModBlocks.OSTRUM_SLIDING_DOOR.get())) {
            doorModel = OSTRUM_SLIDING_DOOR_MODEL;
            doorModelFlipped = OSTRUM_SLIDING_DOOR_MODEL_FLIPPED;
        } else if (type.equals(ModBlocks.CALORITE_SLIDING_DOOR.get())) {
            doorModel = CALORITE_SLIDING_DOOR_MODEL;
            doorModelFlipped = CALORITE_SLIDING_MODEL_FLIPPED;
        } else if (type.equals(ModBlocks.AIRLOCK.get())) {
            doorModel = AIRLOCK_MODEL;
            doorModelFlipped = AIRLOCK_MODEL_FLIPPED;
            slide -= 0.094f;
            offset = 0.155f;
        } else if (type.equals(ModBlocks.REINFORCED_DOOR.get())) {
            doorModel = REINFORCED_DOOR_MODEL_FLIPPED;
            doorModelFlipped = REINFORCED_DOOR_MODEL;
            slide -= 0.094f;
            offset = 0.095f;
        } else {
            return;
        }
        Direction degrees = (Direction)entity.m_58900_().m_61143_((Property)SlidingDoorBlock.FACING);
        poseStack.m_85836_();
        if (degrees.equals((Object)Direction.NORTH)) {
            poseStack.m_252880_(-1.5f, 1.0f, 0.42f);
            poseStack.m_85837_((double)(-slide), 0.0, 0.0);
            poseStack.m_85837_((double)offset, 0.0, 0.0);
        } else if (degrees.equals((Object)Direction.EAST)) {
            poseStack.m_252880_(0.38f, 1.0f, 1.0f);
            poseStack.m_252880_(0.0f, 0.0f, -slide);
            poseStack.m_252880_(0.0f, 0.0f, -offset);
        } else if (degrees.equals((Object)Direction.SOUTH)) {
            poseStack.m_252880_(2.5f, 1.0f, 0.56f);
            poseStack.m_85837_((double)slide, 0.0, 0.0);
            poseStack.m_252880_(-offset, 0.0f, 0.0f);
        } else if (degrees.equals((Object)Direction.WEST)) {
            poseStack.m_252880_(0.56f, 1.0f, 0.0f);
            poseStack.m_252880_(0.0f, 0.0f, slide);
            poseStack.m_252880_(0.0f, 0.0f, offset);
        }
        poseStack.m_252781_(Axis.f_252436_.m_252977_(degrees.m_122424_().m_122435_()));
        boolean shouldNotFlip = degrees.equals((Object)Direction.WEST) || degrees.equals((Object)Direction.EAST);
        AdAstraClient.renderBlock(shouldNotFlip ? doorModel : doorModelFlipped, poseStack, buffer, packedLight, packedOverlay);
        poseStack.m_85849_();
        poseStack.m_85836_();
        if (degrees.equals((Object)Direction.NORTH)) {
            poseStack.m_252880_(0.0f, 1.0f, 0.42f);
            poseStack.m_85837_((double)slide, 0.0, 0.0);
            poseStack.m_85837_((double)offset, 0.0, 0.0);
        } else if (degrees.equals((Object)Direction.EAST)) {
            poseStack.m_252880_(0.38f, 1.0f, 2.5f);
            poseStack.m_252880_(0.0f, 0.0f, slide);
            poseStack.m_252880_(0.0f, 0.0f, -offset);
        } else if (degrees.equals((Object)Direction.SOUTH)) {
            poseStack.m_252880_(1.0f, 1.0f, 0.56f);
            poseStack.m_85837_((double)(-slide), 0.0, 0.0);
            poseStack.m_252880_(-offset, 0.0f, 0.0f);
        } else if (degrees.equals((Object)Direction.WEST)) {
            poseStack.m_252880_(0.56f, 1.0f, -1.5f);
            poseStack.m_252880_(0.0f, 0.0f, -slide);
            poseStack.m_252880_(0.0f, 0.0f, offset);
        }
        poseStack.m_252781_(Axis.f_252436_.m_252977_(degrees.m_122424_().m_122435_()));
        AdAstraClient.renderBlock(shouldNotFlip ? doorModelFlipped : doorModel, poseStack, buffer, packedLight, packedOverlay);
        poseStack.m_85849_();
    }
}

