/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.ad_astra.client.forge;

import earth.terrarium.ad_astra.client.AdAstraClient;
import earth.terrarium.ad_astra.client.registry.ClientModEntities;
import earth.terrarium.ad_astra.client.registry.ClientModKeybindings;
import earth.terrarium.ad_astra.client.registry.ClientModParticles;
import earth.terrarium.ad_astra.common.config.forge.ForgeMenuConfig;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.client.event.RenderGuiEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.util.TriConsumer;

public class AdAstraClientForge {
    private static final Map<Item, BlockEntityWithoutLevelRenderer> ITEM_RENDERERS = new HashMap<Item, BlockEntityWithoutLevelRenderer>();
    private static boolean hasInitializedRenderers = false;

    public static BlockEntityWithoutLevelRenderer getItemRenderer(ItemLike item) {
        return ITEM_RENDERERS.get(item.m_5456_());
    }

    private static void registerItemRenderer(ItemLike item, BlockEntityWithoutLevelRenderer renderer) {
        ITEM_RENDERERS.put(item.m_5456_(), renderer);
    }

    public static void modelLoading(ModelEvent.RegisterAdditional event) {
        AdAstraClient.onRegisterModels(arg_0 -> ((ModelEvent.RegisterAdditional)event).register(arg_0));
    }

    public static void init() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(AdAstraClientForge::modelLoading);
        bus.addListener(AdAstraClientForge::onRegisterParticles);
        bus.addListener(AdAstraClientForge::onRegisterLayerDefinitions);
        bus.addListener(AdAstraClientForge::onClientReloadListeners);
        bus.addListener(AdAstraClientForge::onSetupItemColors);
        bus.addListener(AdAstraClientForge::onSetupBlockColors);
        MinecraftForge.EVENT_BUS.addListener(AdAstraClientForge::onRegisterClientHud);
        MinecraftForge.EVENT_BUS.addListener(AdAstraClientForge::onClientTick);
        ForgeMenuConfig.register();
    }

    public static void postInit() {
        AdAstraClient.onRegisterItemRenderers(AdAstraClientForge::registerItemRenderer);
        AdAstraClient.onRegisterFluidRenderTypes((TriConsumer<RenderType, Fluid, Fluid>)((TriConsumer)AdAstraClientForge::onRegisterFluidRenderTypes));
        AdAstraClient.onRegisterBlockRenderTypes(AdAstraClientForge::onRegisterBlockRenderTypes);
        hasInitializedRenderers = true;
    }

    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase.equals((Object)TickEvent.Phase.START)) {
            ClientModKeybindings.onStartTick(Minecraft.m_91087_());
        }
    }

    private static void onRegisterClientHud(RenderGuiEvent.Post event) {
        AdAstraClient.onRegisterHud(hud -> hud.renderHud(event.getPoseStack(), event.getPartialTick()));
    }

    private static void onRegisterParticles(RegisterParticleProvidersEvent event) {
        ClientModParticles.onRegisterParticles((ParticleType<SimpleParticleType> type, ClientModParticles.SpriteParticleRegistration<SimpleParticleType> provider) -> event.register(type, provider::create));
    }

    private static void onRegisterFluidRenderTypes(RenderType type, Fluid fluid1, Fluid fluid2) {
        ItemBlockRenderTypes.setRenderLayer((Fluid)fluid1, (RenderType)type);
        ItemBlockRenderTypes.setRenderLayer((Fluid)fluid2, (RenderType)type);
    }

    private static void onRegisterBlockRenderTypes(RenderType type, List<Block> blocks) {
        blocks.forEach(block -> ItemBlockRenderTypes.setRenderLayer((Block)block, (RenderType)type));
    }

    public static void onClientReloadListeners(RegisterClientReloadListenersEvent event) {
        AdAstraClient.onRegisterReloadListeners((id, listener) -> event.registerReloadListener(listener));
    }

    public static void onRegisterLayerDefinitions(final EntityRenderersEvent.RegisterLayerDefinitions event) {
        ClientModEntities.registerEntityLayers(new ClientModEntities.LayerDefinitionRegistry(){

            @Override
            public void register(ModelLayerLocation location, Supplier<LayerDefinition> definition) {
                event.registerLayerDefinition(location, definition);
            }
        });
    }

    public static void onSetupItemColors(RegisterColorHandlersEvent.Item event) {
        AdAstraClient.onAddItemColors((arg_0, arg_1) -> ((RegisterColorHandlersEvent.Item)event).register(arg_0, arg_1));
    }

    public static void onSetupBlockColors(RegisterColorHandlersEvent.Block event) {
        AdAstraClient.onAddBlockColors((arg_0, arg_1) -> ((RegisterColorHandlersEvent.Block)event).register(arg_0, arg_1));
    }

    public static boolean hasInitializedRenderers() {
        return hasInitializedRenderers;
    }
}

