/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.ad_astra.client.dimension.renderer;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import earth.terrarium.ad_astra.mixin.client.LevelRendererAccessor;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ModWeatherRenderer {
    private static final ResourceLocation VENUS_RAIN_TEXTURE = new ResourceLocation("ad_astra", "textures/sky/venus/rain.png");

    public static void render(ClientLevel level, int ticks, float tickDelta, LightTexture manager, double cameraX, double cameraY, double cameraZ) {
        Minecraft minecraft = Minecraft.m_91087_();
        LevelRendererAccessor renderer = (LevelRendererAccessor)minecraft.f_91060_;
        float h = minecraft.f_91073_.m_46722_(tickDelta);
        if (!(h <= 0.0f)) {
            manager.m_109896_();
            int i = Mth.m_14107_((double)cameraX);
            int j = Mth.m_14107_((double)cameraY);
            int k = Mth.m_14107_((double)cameraZ);
            Tesselator tessellator = Tesselator.m_85913_();
            BufferBuilder bufferBuilder = tessellator.m_85915_();
            RenderSystem.m_69464_();
            RenderSystem.m_69478_();
            RenderSystem.m_69453_();
            RenderSystem.m_69482_();
            int l = 5;
            if (Minecraft.m_91405_()) {
                l = 10;
            }
            RenderSystem.m_69458_((boolean)Minecraft.m_91085_());
            int m = -1;
            RenderSystem.m_157427_(GameRenderer::m_172829_);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
            for (int o = k - l; o <= k + l; ++o) {
                for (int p = i - l; p <= i + l; ++p) {
                    int q = (o - k + 16) * 32 + p - i + 16;
                    double r = (double)renderer.getRainSizeX()[q] * 0.5;
                    double s = (double)renderer.getRainSizeZ()[q] * 0.5;
                    mutable.m_122169_((double)p, cameraY, (double)o);
                    Biome biome = (Biome)level.m_204166_((BlockPos)mutable).m_203334_();
                    if (!biome.m_264473_()) continue;
                    int t = level.m_6924_(Heightmap.Types.MOTION_BLOCKING, p, o);
                    int u = j - l;
                    int v = j + l;
                    if (u < t) {
                        u = t;
                    }
                    if (v < t) {
                        v = t;
                    }
                    int w = Math.max(t, j);
                    if (u == v) continue;
                    Random random = new Random((long)p * (long)p * 3121L + (long)p * 45238971L ^ (long)o * (long)o * 418711L + (long)o * 13761L);
                    mutable.m_122178_(p, u, o);
                    if (!biome.m_198906_((BlockPos)mutable)) continue;
                    if (m != 0) {
                        m = 0;
                        RenderSystem.m_157456_((int)0, (ResourceLocation)VENUS_RAIN_TEXTURE);
                        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85813_);
                    }
                    int x = renderer.getTicks() + p * p * 3121 + p * 45238971 + o * o * 418711 + o * 13761 & 0x1F;
                    float y = -((float)x + tickDelta) / 32.0f * (3.0f + random.nextFloat());
                    double z = (double)p + 0.5 - cameraX;
                    double aa = (double)o + 0.5 - cameraZ;
                    float ab = (float)Math.sqrt(z * z + aa * aa) / (float)l;
                    float ac = ((1.0f - ab * ab) * 0.5f + 0.5f) * h;
                    mutable.m_122178_(p, w, o);
                    int ad = LevelRenderer.m_109541_((BlockAndTintGetter)level, (BlockPos)mutable);
                    bufferBuilder.m_5483_((double)p - cameraX - r + 0.5, (double)v - cameraY, (double)o - cameraZ - s + 0.5).m_7421_(0.0f, (float)u * 0.25f + y).m_85950_(1.0f, 1.0f, 1.0f, ac).m_85969_(ad).m_5752_();
                    bufferBuilder.m_5483_((double)p - cameraX + r + 0.5, (double)v - cameraY, (double)o - cameraZ + s + 0.5).m_7421_(1.0f, (float)u * 0.25f + y).m_85950_(1.0f, 1.0f, 1.0f, ac).m_85969_(ad).m_5752_();
                    bufferBuilder.m_5483_((double)p - cameraX + r + 0.5, (double)u - cameraY, (double)o - cameraZ + s + 0.5).m_7421_(1.0f, (float)v * 0.25f + y).m_85950_(1.0f, 1.0f, 1.0f, ac).m_85969_(ad).m_5752_();
                    bufferBuilder.m_5483_((double)p - cameraX - r + 0.5, (double)u - cameraY, (double)o - cameraZ - s + 0.5).m_7421_(0.0f, (float)v * 0.25f + y).m_85950_(1.0f, 1.0f, 1.0f, ac).m_85969_(ad).m_5752_();
                }
            }
            if (m >= 0) {
                tessellator.m_85914_();
            }
            RenderSystem.m_69481_();
            RenderSystem.m_69461_();
            manager.m_109891_();
        }
    }
}

