/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.dimpaintings.util;

import com.mrbysco.dimpaintings.config.DimensionalConfig;
import com.mrbysco.dimpaintings.util.PaintingLocation;
import com.mrbysco.dimpaintings.util.PaintingWorldData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundGameEventPacket;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.portal.PortalInfo;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.ITeleporter;

public class PaintingTeleporter
implements ITeleporter {
    @Nullable
    public PortalInfo getPortalInfo(Entity entity, ServerLevel destLevel, Function<ServerLevel, PortalInfo> defaultPortalInfo) {
        PortalInfo pos = PaintingTeleporter.placeInExistingPortal(destLevel, entity, this.dimensionPosition(entity, (Level)destLevel), entity instanceof Player);
        return pos;
    }

    @Nullable
    private static PortalInfo placeInExistingPortal(ServerLevel destLevel, Entity entity, BlockPos pos, boolean isPlayer) {
        boolean isToEnd;
        int i = 200;
        BlockPos blockpos = pos;
        boolean isToOverworld = destLevel.m_46472_() == Level.f_46428_;
        boolean isFromEnd = entity.f_19853_.m_46472_() == Level.f_46430_ && isToOverworld;
        boolean bl = isToEnd = destLevel.m_46472_() == Level.f_46430_;
        if (isFromEnd || isToOverworld && ((Boolean)DimensionalConfig.COMMON.overworldToBed.get()).booleanValue()) {
            blockpos = destLevel.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, destLevel.m_220360_());
            float angle = entity.m_146909_();
            if (isPlayer && entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                BlockPos respawnPos = serverPlayer.m_8961_();
                float respawnAngle = serverPlayer.m_8962_();
                Optional optional = serverPlayer != null && respawnPos != null ? Player.m_36130_((ServerLevel)destLevel, (BlockPos)respawnPos, (float)respawnAngle, (boolean)false, (boolean)false) : Optional.empty();
                boolean flag2 = false;
                if (optional.isPresent()) {
                    float f1;
                    BlockState blockstate = destLevel.m_8055_(respawnPos);
                    boolean flag1 = blockstate.m_60713_(Blocks.f_50724_);
                    Vec3 vector3d = (Vec3)optional.get();
                    if (!blockstate.m_204336_(BlockTags.f_13038_) && !flag1) {
                        f1 = respawnAngle;
                    } else {
                        Vec3 vector3d1 = Vec3.m_82539_((Vec3i)respawnPos).m_82546_(vector3d).m_82541_();
                        f1 = (float)Mth.m_14175_((double)(Mth.m_14136_((double)vector3d1.f_82481_, (double)vector3d1.f_82479_) * 57.2957763671875 - 90.0));
                    }
                    angle = f1;
                    blockpos = BlockPos.m_274561_((double)vector3d.f_82479_, (double)vector3d.f_82480_, (double)vector3d.f_82481_);
                    flag2 = flag1;
                } else if (blockpos != null) {
                    serverPlayer.f_8906_.m_9829_((Packet)new ClientboundGameEventPacket(ClientboundGameEventPacket.f_132153_, 0.0f));
                }
                if (flag2) {
                    serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSoundPacket((Holder)SoundEvents.f_12377_, SoundSource.BLOCKS, (double)respawnPos.m_123341_(), (double)respawnPos.m_123342_(), (double)respawnPos.m_123343_(), 1.0f, 1.0f, destLevel.m_7328_()));
                }
            }
            return new PortalInfo(new Vec3((double)blockpos.m_123341_() + 0.5, (double)blockpos.m_123342_(), (double)blockpos.m_123343_() + 0.5), entity.m_20184_(), angle, entity.m_146909_());
        }
        if (isToEnd) {
            ServerLevel.m_8617_((ServerLevel)destLevel);
            blockpos = ServerLevel.f_8562_;
            return new PortalInfo(new Vec3((double)blockpos.m_123341_() + 0.5, (double)blockpos.m_123342_(), (double)blockpos.m_123343_() + 0.5), entity.m_20184_(), entity.m_146908_(), entity.m_146909_());
        }
        PaintingWorldData worldData = PaintingWorldData.get((Level)destLevel);
        List<PaintingLocation> paintingList = worldData.getDimensionPositions(destLevel.m_46472_().m_135782_());
        if (!paintingList.isEmpty()) {
            ArrayList<ClosestPosition> closestList = new ArrayList<ClosestPosition>();
            for (PaintingLocation paintingPos : paintingList) {
                int distance = (int)PaintingTeleporter.distanceTo(pos, paintingPos.pos);
                if (distance >= i || (blockpos = paintingPos.pos.m_121945_(paintingPos.getDirection())).equals((Object)BlockPos.f_121853_)) continue;
                closestList.add(new ClosestPosition(distance, blockpos));
            }
            if (!closestList.isEmpty()) {
                Collections.sort(closestList);
                blockpos = ((ClosestPosition)closestList.get(0)).pos();
                return PaintingTeleporter.moveToSafeCoords(destLevel, entity, blockpos, false);
            }
        }
        if (blockpos.equals((Object)BlockPos.f_121853_)) {
            return null;
        }
        return PaintingTeleporter.moveToSafeCoords(destLevel, entity, blockpos, true);
    }

    private static double distanceTo(BlockPos origin, BlockPos paintingPos) {
        float f = origin.m_123341_() - paintingPos.m_123341_();
        float f1 = origin.m_123343_() - paintingPos.m_123343_();
        return Mth.m_14116_((float)(f * f + f1 * f1));
    }

    private static PortalInfo moveToSafeCoords(ServerLevel serverLevel, Entity entity, BlockPos pos, boolean withGlass) {
        if (serverLevel.m_46859_(pos.m_7495_())) {
            int distance;
            for (distance = 1; serverLevel.m_8055_(pos.m_6625_(distance)).m_60734_().m_5568_() && distance < 32; ++distance) {
            }
            if (distance > 4) {
                PaintingTeleporter.makePlatform(serverLevel, pos, withGlass);
            }
        } else {
            BlockPos abovePos = pos.m_6630_(1);
            if (serverLevel.m_8055_(pos.m_7494_()).m_60734_().m_5568_() && serverLevel.m_8055_(pos.m_6630_(1)).m_60734_().m_5568_()) {
                return PaintingTeleporter.makePortalInfo(entity, (double)abovePos.m_123341_() + 0.5, abovePos.m_123342_(), (double)abovePos.m_123343_() + 0.5);
            }
            if (!serverLevel.m_46859_(pos.m_7495_()) || !serverLevel.m_46859_(pos)) {
                PaintingTeleporter.makePlatform(serverLevel, abovePos, withGlass);
                return PaintingTeleporter.makePortalInfo(entity, abovePos.m_123341_(), abovePos.m_123342_(), abovePos.m_123343_());
            }
        }
        return PaintingTeleporter.makePortalInfo(entity, pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
    }

    private static void makePlatform(ServerLevel serverLevel, BlockPos pos, boolean withGlass) {
        int i = pos.m_123341_();
        int j = pos.m_123342_() - 2;
        int k = pos.m_123343_();
        if (withGlass) {
            BlockPos.m_121976_((int)(i - 2), (int)(j + 1), (int)(k - 2), (int)(i + 2), (int)(j + 4), (int)(k + 2)).forEach(blockPos -> {
                if (!serverLevel.m_6425_(blockPos).m_76178_() || serverLevel.m_8055_(blockPos).m_60800_((BlockGetter)serverLevel, blockPos) >= 0.0f) {
                    serverLevel.m_46597_(blockPos, Blocks.f_50215_.m_49966_());
                }
            });
            BlockPos.m_121976_((int)(i - 1), (int)(j + 1), (int)(k - 1), (int)(i + 1), (int)(j + 3), (int)(k + 1)).forEach(blockPos -> {
                if (serverLevel.m_8055_(blockPos).m_60800_((BlockGetter)serverLevel, blockPos) >= 0.0f) {
                    serverLevel.m_46597_(blockPos, Blocks.f_50016_.m_49966_());
                }
            });
        }
        BlockPos.m_121976_((int)(i - 1), (int)j, (int)(k - 1), (int)(i + 1), (int)j, (int)(k + 1)).forEach(blockPos -> {
            if (serverLevel.m_8055_(blockPos).m_60800_((BlockGetter)serverLevel, blockPos) >= 0.0f) {
                serverLevel.m_46597_(blockPos, Blocks.f_50080_.m_49966_());
            }
        });
    }

    private BlockPos dimensionPosition(Entity entity, Level destLevel) {
        boolean flag2;
        boolean bl = flag2 = destLevel.m_46472_() == Level.f_46429_;
        if (entity.f_19853_.m_46472_() != Level.f_46429_ && !flag2) {
            return entity.m_20183_();
        }
        WorldBorder worldborder = destLevel.m_6857_();
        double d0 = Math.max(-2.9999872E7, worldborder.m_61955_() + 16.0);
        double d1 = Math.max(-2.9999872E7, worldborder.m_61956_() + 16.0);
        double d2 = Math.min(2.9999872E7, worldborder.m_61957_() - 16.0);
        double d3 = Math.min(2.9999872E7, worldborder.m_61958_() - 16.0);
        double d4 = DimensionType.m_63908_((DimensionType)entity.f_19853_.m_6042_(), (DimensionType)destLevel.m_6042_());
        int maxY = (Integer)DimensionalConfig.COMMON.netherMaxY.get();
        return BlockPos.m_274561_((double)Mth.m_14008_((double)(entity.m_20185_() * d4), (double)d0, (double)d2), (double)Mth.m_14008_((double)entity.m_20186_(), (double)2.0, (double)maxY), (double)Mth.m_14008_((double)(entity.m_20189_() * d4), (double)d1, (double)d3));
    }

    private static PortalInfo makePortalInfo(Entity entity, double x, double y, double z) {
        return PaintingTeleporter.makePortalInfo(entity, new Vec3(x, y, z));
    }

    private static PortalInfo makePortalInfo(Entity entity, Vec3 pos) {
        return new PortalInfo(pos, Vec3.f_82478_, entity.m_146908_(), entity.m_146909_());
    }

    public PaintingTeleporter(ServerLevel serverLevel) {
    }

    public Entity placeEntity(Entity newEntity, ServerLevel currentLevel, ServerLevel destLevel, float yaw, Function<Boolean, Entity> repositionEntity) {
        newEntity.f_19789_ = 0.0f;
        return repositionEntity.apply(false);
    }

    record ClosestPosition(int distance, BlockPos pos) implements Comparable<ClosestPosition>
    {
        @Override
        public int compareTo(ClosestPosition anotherPosition) {
            return ClosestPosition.compare(this.distance, anotherPosition.distance());
        }

        public static int compare(int x, int y) {
            return Integer.compare(x, y);
        }
    }
}

