/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.dimpaintings.item;

import com.mrbysco.dimpaintings.entity.DimensionalPainting;
import com.mrbysco.dimpaintings.registry.DimensionPaintingType;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;

public class DimensionalPaintingItem
extends Item {
    private final Supplier<DimensionPaintingType> paintingDimensionSupplier;

    public DimensionalPaintingItem(Item.Properties properties, Supplier<DimensionPaintingType> paintingDimension) {
        super(properties);
        this.paintingDimensionSupplier = paintingDimension;
    }

    public InteractionResult m_6225_(UseOnContext useContext) {
        BlockPos pos = useContext.m_8083_();
        Direction direction = useContext.m_43719_();
        BlockPos relativePos = pos.m_121945_(direction);
        Player player = useContext.m_43723_();
        ItemStack stack = useContext.m_43722_();
        if (player != null && !this.mayPlace(player, direction, stack, relativePos)) {
            return InteractionResult.FAIL;
        }
        Level level = useContext.m_43725_();
        DimensionalPainting dimensionalPainting = new DimensionalPainting(level, relativePos, direction, this.paintingDimensionSupplier.get());
        dimensionalPainting.setItem(stack);
        CompoundTag tag = stack.m_41783_();
        if (tag != null) {
            EntityType.m_20620_((Level)level, (Player)player, (Entity)dimensionalPainting, (CompoundTag)tag);
        }
        if (dimensionalPainting.m_7088_()) {
            if (!level.f_46443_) {
                dimensionalPainting.m_7084_();
                level.m_7967_((Entity)dimensionalPainting);
                stack.m_41774_(1);
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.CONSUME;
    }

    protected boolean mayPlace(Player player, Direction direction, ItemStack stack, BlockPos pos) {
        return !direction.m_122434_().m_122478_() && player.m_36204_(pos, direction, stack);
    }
}

