/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.dimpaintings.entity;

import com.mrbysco.dimpaintings.config.DimensionalConfig;
import com.mrbysco.dimpaintings.registry.DimensionPaintingType;
import com.mrbysco.dimpaintings.registry.PaintingRegistry;
import com.mrbysco.dimpaintings.registry.PaintingTypeRegistry;
import com.mrbysco.dimpaintings.util.PaintingWorldData;
import com.mrbysco.dimpaintings.util.TeleportHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DiodeBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;

public class DimensionalPainting
extends HangingEntity
implements IEntityAdditionalSpawnData {
    private static final EntityDataAccessor<ItemStack> DATA_ITEM_STACK = SynchedEntityData.m_135353_(DimensionalPainting.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    public DimensionPaintingType dimensionType;

    public DimensionalPainting(EntityType<? extends DimensionalPainting> entityType, Level world) {
        super(entityType, world);
    }

    public DimensionalPainting(Level level, BlockPos blockPos, Direction direction, DimensionPaintingType paintingType) {
        super((EntityType)PaintingRegistry.DIMENSIONAL_PAINTING.get(), level, blockPos);
        this.setDimensionType(paintingType);
        this.m_6022_(direction);
        if (!this.f_19853_.f_46443_) {
            ServerLevel serverLevel = (ServerLevel)level;
            PaintingWorldData worldData = PaintingWorldData.get((Level)serverLevel);
            worldData.addPositionToDimension(level.m_46472_().m_135782_(), this.m_31748_(), this.m_6350_());
        }
    }

    public DimensionalPainting(PlayMessages.SpawnEntity spawnEntity, Level level) {
        this(level, new BlockPos((int)spawnEntity.getPosX(), (int)spawnEntity.getPosY(), (int)spawnEntity.getPosZ()), Direction.m_122407_((int)spawnEntity.getAdditionalData().readByte()), (DimensionPaintingType)PaintingTypeRegistry.DIMENSIONAL_PAINTINGS.get().getValue(ResourceLocation.m_135820_((String)spawnEntity.getAdditionalData().m_130277_())));
        FriendlyByteBuf additionalData = spawnEntity.getAdditionalData();
        Item item = (Item)ForgeRegistries.ITEMS.getValue(ResourceLocation.m_135820_((String)additionalData.m_130277_()));
        if (item != null) {
            this.setItem(new ItemStack((ItemLike)item));
        }
    }

    protected void m_6022_(Direction dir) {
        super.m_6022_(dir);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_6089_() {
        this.m_146912_();
    }

    public boolean m_6469_(DamageSource damageSource, float amount) {
        if (this.m_6673_(damageSource)) {
            return false;
        }
        if (this.m_6084_() && !this.f_19853_.f_46443_) {
            this.removeStoredPosition();
            this.m_6074_();
            this.m_5834_();
            this.m_5553_(damageSource.m_7639_());
        }
        return true;
    }

    public void m_6478_(MoverType type, Vec3 position) {
        if (!this.f_19853_.f_46443_ && this.m_6084_() && position.m_82556_() > 0.0) {
            this.removeStoredPosition();
            this.m_6074_();
            this.m_5553_(null);
        }
    }

    public void m_5997_(double posX, double posY, double posZ) {
        if (!this.f_19853_.f_46443_ && this.m_6084_() && posX * posX + posY * posY + posZ * posZ > 0.0) {
            this.removeStoredPosition();
            this.m_6074_();
            this.m_5553_(null);
        }
    }

    private void removeStoredPosition() {
        ServerLevel serverWorld = (ServerLevel)this.f_19853_;
        PaintingWorldData worldData = PaintingWorldData.get((Level)serverWorld);
        worldData.removePositionFromDimension(this.f_19853_.m_46472_().m_135782_(), this.m_31748_());
    }

    public boolean m_6072_() {
        return false;
    }

    public void m_8119_() {
        List nearbyEntities;
        super.m_8119_();
        if (!this.f_19853_.f_46443_ && this.m_6084_() && !(nearbyEntities = this.f_19853_.m_45976_(Entity.class, this.m_20191_())).isEmpty()) {
            for (Entity entityIn : nearbyEntities) {
                boolean flag;
                if (entityIn == this || entityIn instanceof FakePlayer || entityIn instanceof Player || !(flag = entityIn.m_20270_((Entity)this) < 1.0f && !entityIn.m_20096_()) || entityIn.m_20159_() || entityIn.m_20159_() || entityIn.m_20160_() || !entityIn.m_6072_()) continue;
                entityIn.m_6021_((double)((int)this.m_20185_()), (double)((int)this.m_20186_()), (double)((int)this.m_20189_()));
                TeleportHelper.teleportToGivenDimension(entityIn, this.dimensionType.getDimensionLocation());
                return;
            }
        }
    }

    public void m_6123_(Player player) {
        super.m_6123_(player);
        if (!this.f_19853_.f_46443_ && this.m_6084_()) {
            boolean flag;
            boolean bl = flag = player.m_20270_((Entity)this) < 1.0f && !player.m_20096_();
            if (flag && !player.m_20159_() && !player.m_20159_() && !player.m_20160_() && player.m_6072_()) {
                boolean cooldownFlag;
                boolean bl2 = cooldownFlag = (Integer)DimensionalConfig.COMMON.teleportCooldown.get() == 0;
                if (cooldownFlag || !player.getPersistentData().m_128441_("PaintingCooldown")) {
                    if (!cooldownFlag) {
                        player.getPersistentData().m_128405_("PaintingCooldown", ((Integer)DimensionalConfig.COMMON.teleportCooldown.get()).intValue());
                    }
                    player.m_6021_((double)((int)this.m_20185_()), (double)((int)this.m_20186_()), (double)((int)this.m_20189_()));
                    TeleportHelper.teleportToGivenDimension((Entity)player, this.dimensionType.getDimensionLocation());
                } else {
                    player.m_5661_((Component)Component.m_237115_((String)"dimpaintings.cooldown").m_130940_(ChatFormatting.GOLD), true);
                }
            }
        }
    }

    protected void m_8097_() {
        this.m_20088_().m_135372_(DATA_ITEM_STACK, (Object)ItemStack.f_41583_);
    }

    public void setDimensionType(DimensionPaintingType type) {
        this.dimensionType = type;
    }

    public DimensionPaintingType getDimensionType() {
        return this.dimensionType;
    }

    public void m_7380_(CompoundTag compoundNBT) {
        compoundNBT.m_128359_("Dimension", PaintingTypeRegistry.DIMENSIONAL_PAINTINGS.get().getKey((Object)this.dimensionType).toString());
        compoundNBT.m_128344_("Facing", (byte)this.f_31699_.m_122416_());
        ItemStack itemstack = this.getItemRaw();
        if (!itemstack.m_41619_()) {
            compoundNBT.m_128365_("Item", (Tag)itemstack.m_41739_(new CompoundTag()));
        }
        super.m_7380_(compoundNBT);
    }

    public void m_7378_(CompoundTag compoundNBT) {
        this.dimensionType = (DimensionPaintingType)PaintingTypeRegistry.DIMENSIONAL_PAINTINGS.get().getValue(ResourceLocation.m_135820_((String)compoundNBT.m_128461_("Dimension")));
        this.f_31699_ = Direction.m_122407_((int)compoundNBT.m_128445_("Facing"));
        super.m_7378_(compoundNBT);
        this.m_6022_(this.f_31699_);
        ItemStack itemstack = ItemStack.m_41712_((CompoundTag)compoundNBT.m_128469_("Item"));
        this.setItem(itemstack);
    }

    public void setItem(ItemStack stack) {
        if (stack.m_41720_() != PaintingRegistry.OVERWORLD_PAINTING.get() || stack.m_41782_()) {
            this.m_20088_().m_135381_(DATA_ITEM_STACK, (Object)((ItemStack)Util.m_137469_((Object)stack.m_41777_(), itemStack -> itemStack.m_41764_(1))));
        }
    }

    protected ItemStack getItemRaw() {
        return (ItemStack)this.m_20088_().m_135370_(DATA_ITEM_STACK);
    }

    public ItemStack getItem() {
        ItemStack itemstack = this.getItemRaw();
        return itemstack.m_41619_() ? new ItemStack((ItemLike)PaintingRegistry.OVERWORLD_PAINTING.get()) : itemstack;
    }

    public int m_7076_() {
        return this.dimensionType == null ? 1 : this.dimensionType.getWidth();
    }

    public int m_7068_() {
        return this.dimensionType == null ? 1 : this.dimensionType.getHeight();
    }

    public void m_5553_(@Nullable Entity entity) {
        if (this.f_19853_.m_46469_().m_46207_(GameRules.f_46137_)) {
            this.m_5496_(SoundEvents.f_12175_, 1.0f, 1.0f);
            if (entity instanceof Player) {
                Player player = (Player)entity;
                if (player.m_150110_().f_35937_) {
                    return;
                }
            }
            this.m_19983_(this.getItem());
        }
    }

    public ItemStack getPickedResult(HitResult target) {
        return this.getItem();
    }

    public void m_7084_() {
        this.m_5496_(SoundEvents.f_12176_, 1.0f, 1.0f);
    }

    public void m_7678_(double posX, double posY, double posZ, float unused1, float unused2) {
        this.m_6034_(posX, posY, posZ);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_6453_(double xOffset, double yOffset, double zOffset, float unused1, float unused2, int unused3, boolean flag) {
        BlockPos blockpos = this.f_31698_.m_121955_((Vec3i)BlockPos.m_274561_((double)(xOffset - this.m_20185_()), (double)(yOffset - this.m_20186_()), (double)(zOffset - this.m_20189_())));
        this.m_6034_(blockpos.m_123341_(), blockpos.m_123342_(), blockpos.m_123343_());
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        buffer.writeByte((int)((byte)this.f_31699_.m_122416_()));
        buffer.m_130070_(PaintingTypeRegistry.DIMENSIONAL_PAINTINGS.get().getKey((Object)this.dimensionType).toString());
        buffer.m_130070_(ForgeRegistries.ITEMS.getKey((Object)this.getItem().m_41720_()).toString());
    }

    public void readSpawnData(FriendlyByteBuf additionalData) {
    }

    protected void m_7087_() {
        if (this.f_31699_ != null) {
            double posX = (double)this.f_31698_.m_123341_() + 0.5;
            double posY = (double)this.f_31698_.m_123342_() + 0.5;
            double posZ = (double)this.f_31698_.m_123343_() + 0.5;
            if (this.f_19853_.f_46443_ && this.f_19797_ == 0) {
                if (this.f_31699_ == Direction.NORTH) {
                    posY -= 1.0;
                }
                if (this.f_31699_ == Direction.EAST) {
                    posY -= 1.0;
                }
                if (this.f_31699_ == Direction.SOUTH) {
                    posX -= 1.0;
                    posY -= 1.0;
                }
                if (this.f_31699_ == Direction.WEST) {
                    posY -= 1.0;
                    posZ -= 1.0;
                }
            }
            double d3 = 0.46875;
            double offWidth = this.offs(this.m_7076_());
            double offHeight = this.offs(this.m_7068_());
            posX -= (double)this.f_31699_.m_122429_() * d3;
            posZ -= (double)this.f_31699_.m_122431_() * d3;
            Direction direction = this.f_31699_.m_122428_();
            this.m_20343_(posX += offWidth * (double)direction.m_122429_(), posY += offHeight, posZ += offWidth * (double)direction.m_122431_());
            double width = this.m_7076_();
            double height = this.m_7068_();
            double width2 = this.m_7076_();
            if (this.f_31699_.m_122434_() == Direction.Axis.Z) {
                width2 = 1.0;
            } else {
                width = 1.0;
            }
            this.m_20011_(new AABB(posX - (width /= 32.0), posY - (height /= 32.0), posZ - (width2 /= 32.0), posX + width, posY + height, posZ + width2));
        }
    }

    private double offs(int size) {
        return size % 32 == 0 ? 0.5 : 0.0;
    }

    public Component m_7755_() {
        return this.getItem().m_41611_();
    }

    public boolean m_7088_() {
        if (!this.f_19853_.m_45786_((Entity)this)) {
            return false;
        }
        int i = Math.max(1, this.m_7076_() / 16);
        int j = Math.max(1, this.m_7068_() / 16);
        BlockPos blockpos = this.f_31698_.m_121945_(this.f_31699_.m_122424_());
        Direction direction = this.f_31699_.m_122428_();
        BlockPos.MutableBlockPos blockpos$mutable = new BlockPos.MutableBlockPos();
        for (int k = 0; k < i; ++k) {
            for (int l = 0; l < j; ++l) {
                int i1 = (i - 1) / -2;
                int j1 = (j - 1) / -2;
                blockpos$mutable.m_122190_((Vec3i)blockpos).m_122175_(direction, k + i1).m_122175_(Direction.UP, l + j1);
                BlockState blockstate = this.f_19853_.m_8055_((BlockPos)blockpos$mutable);
                if (Block.m_49863_((LevelReader)this.f_19853_, (BlockPos)blockpos$mutable, (Direction)this.f_31699_) || blockstate.m_60767_().m_76333_() || DiodeBlock.m_52586_((BlockState)blockstate)) continue;
                return false;
            }
        }
        return this.f_19853_.m_6249_((Entity)this, this.m_20191_(), f_31697_).isEmpty();
    }

    public void m_6210_() {
        double posX = this.m_20185_();
        double posY = this.m_20186_();
        double posZ = this.m_20189_();
        super.m_6210_();
        this.m_20343_(posX, posY, posZ);
    }
}

