/*
 * Decompiled with CFR 0.152.
 */
package com.catastrophe573.dimdungeons.structure;

import com.catastrophe573.dimdungeons.DungeonConfig;
import com.catastrophe573.dimdungeons.structure.DungeonDesigner;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.level.block.Rotation;

public class DungeonDesignerTestShapes {
    public static void MakeTestDungeonOne(DungeonDesigner dbl) {
        int i;
        for (i = 1; i <= 8; ++i) {
            dbl.placeRoomShape(i - 1, 0, "deadend_" + i, DungeonDesigner.RoomType.END, Rotation.NONE);
        }
        for (i = 1; i <= 4; ++i) {
            dbl.placeRoomShape(i - 1, 1, "redspuzzle_" + i, DungeonDesigner.RoomType.END, Rotation.NONE);
        }
        dbl.placeRoomShape(5, 1, "freebie_1", DungeonDesigner.RoomType.END, Rotation.NONE);
        dbl.placeRoomShape(6, 1, "freebie_2", DungeonDesigner.RoomType.END, Rotation.NONE);
        dbl.placeRoomShape(7, 1, "freebie_3", DungeonDesigner.RoomType.END, Rotation.NONE);
        for (i = 1; i <= 6; ++i) {
            dbl.placeRoomShape(i - 1, 2, "spawner_" + i, DungeonDesigner.RoomType.END, Rotation.NONE);
        }
        for (i = 1; i <= 3; ++i) {
            dbl.placeRoomShape(i - 1, 3, "shoutout_" + i, DungeonDesigner.RoomType.END, Rotation.NONE);
        }
        for (i = 1; i <= 5; ++i) {
            dbl.placeRoomShape(i - 1 + 3, 3, "keytrap_" + i, DungeonDesigner.RoomType.END, Rotation.NONE);
        }
        for (i = 1; i <= 5; ++i) {
            dbl.placeRoomShape(i - 1, 4, "coffin_" + i, DungeonDesigner.RoomType.END, Rotation.NONE);
        }
        for (i = 1; i <= 5; ++i) {
            dbl.placeRoomShape(i - 1, 5, "restroom_" + i, DungeonDesigner.RoomType.END, Rotation.NONE);
        }
        for (i = 1; i <= 4; ++i) {
            dbl.placeRoomShape(i - 1, 6, "deathtrap_" + i, DungeonDesigner.RoomType.END, Rotation.NONE);
        }
        for (i = 1; i <= 4; ++i) {
            dbl.placeRoomShape(i - 1 + 4, 6, "keyroom_" + i, DungeonDesigner.RoomType.END, Rotation.NONE);
        }
        dbl.placeRoomShape(4, 7, "entrance_9", DungeonDesigner.RoomType.ENTRANCE, Rotation.NONE);
    }

    public static void MakeTestDungeonTwo(DungeonDesigner dbl) {
        int i;
        for (i = 1; i <= 8; ++i) {
            dbl.placeRoomShape(i - 1, 0, "entrance_" + i, DungeonDesigner.RoomType.ENTRANCE, Rotation.NONE);
        }
        for (i = 1; i <= 6; ++i) {
            dbl.placeRoomShape(i - 1, 1, "hallway_" + i, DungeonDesigner.RoomType.HALLWAY, Rotation.NONE);
        }
        dbl.placeRoomShape(7, 1, "entrance_9", DungeonDesigner.RoomType.ENTRANCE, Rotation.NONE);
        for (i = 1; i <= 5; ++i) {
            dbl.placeRoomShape(i - 1, 2, "extrahall_" + i, DungeonDesigner.RoomType.HALLWAY, Rotation.NONE);
        }
        dbl.placeRoomShape(6, 2, "moohall_1", DungeonDesigner.RoomType.HALLWAY, Rotation.NONE);
        dbl.placeRoomShape(7, 2, "skullcorner", DungeonDesigner.RoomType.CORNER, Rotation.NONE);
        for (i = 1; i <= 4; ++i) {
            dbl.placeRoomShape(i - 1, 3, "tempt_" + i, DungeonDesigner.RoomType.HALLWAY, Rotation.NONE);
        }
        for (i = 1; i <= 3; ++i) {
            dbl.placeRoomShape(i - 1 + 4, 3, "coalhall_" + i, DungeonDesigner.RoomType.HALLWAY, Rotation.NONE);
        }
        for (i = 1; i <= 8; ++i) {
            dbl.placeRoomShape(i - 1, 4, "corner_" + i, DungeonDesigner.RoomType.CORNER, Rotation.NONE);
        }
        for (i = 1; i <= 5; ++i) {
            dbl.placeRoomShape(i - 1, 5, "longcorner_" + i, DungeonDesigner.RoomType.CORNER, Rotation.NONE);
        }
        dbl.placeRoomShape(5, 5, "yinyang_1", DungeonDesigner.RoomType.HALLWAY, Rotation.NONE);
        dbl.placeRoomShape(6, 5, "yinyang_2", DungeonDesigner.RoomType.HALLWAY, Rotation.NONE);
        dbl.placeRoomShape(4, 7, "entrance_9", DungeonDesigner.RoomType.ENTRANCE, Rotation.NONE);
    }

    public static void MakeTestDungeonThree(DungeonDesigner dbl) {
        int i;
        for (i = 1; i <= 4; ++i) {
            dbl.placeRoomShape(i - 1, 0, "disco_" + i, DungeonDesigner.RoomType.FOURWAY, Rotation.NONE);
        }
        dbl.placeRoomShape(4, 0, "advice_1", DungeonDesigner.RoomType.END, Rotation.NONE);
        dbl.placeRoomShape(5, 0, "advice_2", DungeonDesigner.RoomType.THREEWAY, Rotation.NONE);
        dbl.placeRoomShape(6, 0, "advice_3", DungeonDesigner.RoomType.HALLWAY, Rotation.NONE);
        for (i = 1; i <= 6; ++i) {
            dbl.placeRoomShape(i - 1, 1, "combat_" + i, DungeonDesigner.RoomType.FOURWAY, Rotation.NONE);
        }
        dbl.placeRoomShape(6, 1, "swimmaze_1", DungeonDesigner.RoomType.FOURWAY, Rotation.NONE);
        dbl.placeRoomShape(7, 1, "fourway_9", DungeonDesigner.RoomType.FOURWAY, Rotation.NONE);
        for (i = 1; i <= 8; ++i) {
            dbl.placeRoomShape(i - 1, 2, "fourway_" + i, DungeonDesigner.RoomType.FOURWAY, Rotation.NONE);
        }
        for (i = 1; i <= 5; ++i) {
            dbl.placeRoomShape(i - 1, 3, "threeway_" + i, DungeonDesigner.RoomType.THREEWAY, Rotation.NONE);
        }
        dbl.placeRoomShape(5, 3, "tetris_1", DungeonDesigner.RoomType.THREEWAY, Rotation.NONE);
        dbl.placeRoomShape(6, 3, "tetris_2", DungeonDesigner.RoomType.THREEWAY, Rotation.NONE);
        dbl.placeRoomShape(7, 3, "tetris_3", DungeonDesigner.RoomType.THREEWAY, Rotation.NONE);
        for (i = 1; i <= 3; ++i) {
            dbl.placeRoomShape(i - 1, 4, "morethree_" + i, DungeonDesigner.RoomType.THREEWAY, Rotation.NONE);
        }
        dbl.placeRoomShape(0, 5, "redstrap_1", DungeonDesigner.RoomType.FOURWAY, Rotation.NONE);
        dbl.placeRoomShape(1, 5, "redstrap_2", DungeonDesigner.RoomType.HALLWAY, Rotation.NONE);
        dbl.placeRoomShape(2, 5, "redstrap_3", DungeonDesigner.RoomType.CORNER, Rotation.NONE);
        dbl.placeRoomShape(3, 5, "redstrap_4", DungeonDesigner.RoomType.THREEWAY, Rotation.NONE);
        dbl.placeRoomShape(4, 5, "mazenotfound_1", DungeonDesigner.RoomType.CORNER, Rotation.NONE);
        dbl.placeRoomShape(5, 5, "mazenotfound_2", DungeonDesigner.RoomType.THREEWAY, Rotation.NONE);
        dbl.placeRoomShape(6, 5, "mazenotfound_3", DungeonDesigner.RoomType.HALLWAY, Rotation.NONE);
        dbl.placeRoomShape(4, 7, "entrance_9", DungeonDesigner.RoomType.ENTRANCE, Rotation.NONE);
    }

    public static void MakeTestDungeonFour(DungeonDesigner dbl) {
        dbl.placeRoomShape(0, 0, "redspuzzle_4", DungeonDesigner.RoomType.END, Rotation.NONE);
        dbl.placeRoomShape(1, 0, "morethree_4", DungeonDesigner.RoomType.THREEWAY, Rotation.NONE);
        dbl.placeRoomShape(2, 0, "morethree_5", DungeonDesigner.RoomType.THREEWAY, Rotation.NONE);
        dbl.placeRoomShape(3, 0, "morethree_6", DungeonDesigner.RoomType.THREEWAY, Rotation.NONE);
        dbl.placeRoomShape(4, 0, "library_1", DungeonDesigner.RoomType.HALLWAY, Rotation.NONE);
        dbl.placeRoomShape(5, 0, "library_2", DungeonDesigner.RoomType.END, Rotation.NONE);
        dbl.placeRoomShape(0, 1, "crueltrap_1", DungeonDesigner.RoomType.END, Rotation.NONE);
        dbl.placeRoomShape(1, 1, "crueltrap_2", DungeonDesigner.RoomType.END, Rotation.NONE);
        dbl.placeRoomShape(2, 1, "crueltrap_3", DungeonDesigner.RoomType.END, Rotation.NONE);
        dbl.placeRoomShape(3, 1, "blastchest_1", DungeonDesigner.RoomType.END, Rotation.NONE);
        dbl.placeRoomShape(4, 1, "smeltery_v2", DungeonDesigner.RoomType.END, Rotation.NONE);
        dbl.placeRoomShape(5, 1, "hiddenpath_3", DungeonDesigner.RoomType.THREEWAY, Rotation.NONE);
        dbl.placeRoomShape(6, 1, "hiddenpath_1", DungeonDesigner.RoomType.THREEWAY, Rotation.NONE);
        dbl.placeRoomShape(7, 1, "hiddenpath_2", DungeonDesigner.RoomType.FOURWAY, Rotation.NONE);
        dbl.placeRoomShape(0, 2, "waterhall_1", DungeonDesigner.RoomType.HALLWAY, Rotation.NONE);
        dbl.placeRoomShape(1, 2, "yinyang_1", DungeonDesigner.RoomType.HALLWAY, Rotation.NONE);
        dbl.placeRoomShape(2, 2, "yinyang_2", DungeonDesigner.RoomType.HALLWAY, Rotation.NONE);
        dbl.placeRoomShape(3, 2, "magicpuzzle_1", DungeonDesigner.RoomType.END, Rotation.NONE);
        dbl.placeRoomShape(4, 2, "beacon_1", DungeonDesigner.RoomType.END, Rotation.NONE);
        dbl.placeRoomShape(5, 2, "beacon_2", DungeonDesigner.RoomType.END, Rotation.NONE);
        dbl.placeRoomShape(0, 4, "spawner_1", DungeonDesigner.RoomType.END, Rotation.NONE);
        dbl.placeRoomShape(1, 4, "spawner_2", DungeonDesigner.RoomType.END, Rotation.NONE);
        dbl.placeRoomShape(2, 4, "spawner_3", DungeonDesigner.RoomType.END, Rotation.NONE);
        dbl.placeRoomShape(3, 4, "spawner_4", DungeonDesigner.RoomType.END, Rotation.NONE);
        dbl.placeRoomShape(4, 4, "spawner_5", DungeonDesigner.RoomType.END, Rotation.NONE);
        dbl.placeRoomShape(5, 4, "spawner_6", DungeonDesigner.RoomType.END, Rotation.NONE);
        dbl.placeRoomShape(4, 7, "entrance_9", DungeonDesigner.RoomType.ENTRANCE, Rotation.NONE);
    }

    public static void MakeTestDungeonDynamic(DungeonDesigner dbl, DungeonDesigner.DungeonType tier, DungeonDesigner.RoomType type) {
        int i;
        ArrayList allrooms = Lists.newArrayList();
        List<? extends List<String>> theListWeCareAbout = DungeonConfig.basicEntrances;
        if (tier == DungeonDesigner.DungeonType.BASIC && type == DungeonDesigner.RoomType.FOURWAY) {
            theListWeCareAbout = DungeonConfig.basicFourways;
        }
        if (tier == DungeonDesigner.DungeonType.BASIC && type == DungeonDesigner.RoomType.THREEWAY) {
            theListWeCareAbout = DungeonConfig.basicThreeways;
        }
        if (tier == DungeonDesigner.DungeonType.BASIC && type == DungeonDesigner.RoomType.HALLWAY) {
            theListWeCareAbout = DungeonConfig.basicHallways;
        }
        if (tier == DungeonDesigner.DungeonType.BASIC && type == DungeonDesigner.RoomType.CORNER) {
            theListWeCareAbout = DungeonConfig.basicCorners;
        }
        if (tier == DungeonDesigner.DungeonType.BASIC && type == DungeonDesigner.RoomType.END) {
            theListWeCareAbout = DungeonConfig.basicEnds;
        }
        if (tier == DungeonDesigner.DungeonType.ADVANCED && type == DungeonDesigner.RoomType.FOURWAY) {
            theListWeCareAbout = DungeonConfig.advancedFourways;
        }
        if (tier == DungeonDesigner.DungeonType.ADVANCED && type == DungeonDesigner.RoomType.THREEWAY) {
            theListWeCareAbout = DungeonConfig.advancedThreeways;
        }
        if (tier == DungeonDesigner.DungeonType.ADVANCED && type == DungeonDesigner.RoomType.HALLWAY) {
            theListWeCareAbout = DungeonConfig.advancedHallways;
        }
        if (tier == DungeonDesigner.DungeonType.ADVANCED && type == DungeonDesigner.RoomType.CORNER) {
            theListWeCareAbout = DungeonConfig.advancedCorners;
        }
        if (tier == DungeonDesigner.DungeonType.ADVANCED && type == DungeonDesigner.RoomType.END) {
            theListWeCareAbout = DungeonConfig.advancedEnds;
        }
        for (i = 0; i < theListWeCareAbout.size(); ++i) {
            for (int j = 0; j < theListWeCareAbout.get(i).size(); ++j) {
                String temp = theListWeCareAbout.get(i).get(j);
                allrooms.add(temp.replace("dimdungeons:", ""));
            }
        }
        dbl.placeRoomShape(4, 7, "entrance_1", DungeonDesigner.RoomType.ENTRANCE, Rotation.NONE);
        for (i = 0; i < allrooms.size(); ++i) {
            if (i / 8 == 4 && i % 8 == 7) {
                int beyondEnd = allrooms.size() + 1;
                dbl.placeRoomShape(beyondEnd / 8, beyondEnd % 8, (String)allrooms.get(i), type, Rotation.NONE);
                continue;
            }
            dbl.placeRoomShape(i / 8, i % 8, (String)allrooms.get(i), type, Rotation.NONE);
        }
    }

    public static void MakeTestDungeonForTheme(DungeonDesigner dbl, int theme) {
        String temp;
        int j;
        int i;
        ArrayList allrooms = Lists.newArrayList();
        for (i = 0; i < DungeonConfig.themeSettings.get((int)(theme - 1)).themeEntrances.size(); ++i) {
            for (j = 0; j < DungeonConfig.themeSettings.get((int)(theme - 1)).themeEntrances.get(i).size(); ++j) {
                temp = DungeonConfig.themeSettings.get((int)(theme - 1)).themeEntrances.get(i).get(j);
                allrooms.add(temp.replace("dimdungeons:", ""));
            }
        }
        for (i = 0; i < DungeonConfig.themeSettings.get((int)(theme - 1)).themeFourways.size(); ++i) {
            for (j = 0; j < DungeonConfig.themeSettings.get((int)(theme - 1)).themeFourways.get(i).size(); ++j) {
                temp = DungeonConfig.themeSettings.get((int)(theme - 1)).themeFourways.get(i).get(j);
                allrooms.add(temp.replace("dimdungeons:", ""));
            }
        }
        for (i = 0; i < DungeonConfig.themeSettings.get((int)(theme - 1)).themeThreeways.size(); ++i) {
            for (j = 0; j < DungeonConfig.themeSettings.get((int)(theme - 1)).themeThreeways.get(i).size(); ++j) {
                temp = DungeonConfig.themeSettings.get((int)(theme - 1)).themeThreeways.get(i).get(j);
                allrooms.add(temp.replace("dimdungeons:", ""));
            }
        }
        for (i = 0; i < DungeonConfig.themeSettings.get((int)(theme - 1)).themeHallways.size(); ++i) {
            for (j = 0; j < DungeonConfig.themeSettings.get((int)(theme - 1)).themeHallways.get(i).size(); ++j) {
                temp = DungeonConfig.themeSettings.get((int)(theme - 1)).themeHallways.get(i).get(j);
                allrooms.add(temp.replace("dimdungeons:", ""));
            }
        }
        for (i = 0; i < DungeonConfig.themeSettings.get((int)(theme - 1)).themeCorners.size(); ++i) {
            for (j = 0; j < DungeonConfig.themeSettings.get((int)(theme - 1)).themeCorners.get(i).size(); ++j) {
                temp = DungeonConfig.themeSettings.get((int)(theme - 1)).themeCorners.get(i).get(j);
                allrooms.add(temp.replace("dimdungeons:", ""));
            }
        }
        for (i = 0; i < DungeonConfig.themeSettings.get((int)(theme - 1)).themeEnds.size(); ++i) {
            for (j = 0; j < DungeonConfig.themeSettings.get((int)(theme - 1)).themeEnds.get(i).size(); ++j) {
                temp = DungeonConfig.themeSettings.get((int)(theme - 1)).themeEnds.get(i).get(j);
                allrooms.add(temp.replace("dimdungeons:", ""));
            }
        }
        dbl.placeRoomShape(4, 7, (String)allrooms.get(0), DungeonDesigner.RoomType.ENTRANCE, Rotation.NONE);
        for (i = 1; i < allrooms.size(); ++i) {
            if (i / 8 == 4 && i % 8 == 7) {
                int beyondEnd = allrooms.size() + 1;
                dbl.placeRoomShape(beyondEnd / 8, beyondEnd % 8, (String)allrooms.get(i), DungeonDesigner.RoomType.FOURWAY, Rotation.NONE);
                continue;
            }
            dbl.placeRoomShape(i / 8, i % 8, (String)allrooms.get(i), DungeonDesigner.RoomType.FOURWAY, Rotation.NONE);
        }
    }
}

