/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.data_handler.handlers;

import com.legacy.structure_gel.api.data_handler.DataHandlerType;
import com.legacy.structure_gel.api.data_handler.LootTableAlias;
import com.legacy.structure_gel.api.data_handler.handlers.ProbabilityDataHandler;
import com.legacy.structure_gel.api.data_handler.parsing.DataMap;
import com.legacy.structure_gel.api.data_handler.parsing.DataParser;
import net.minecraft.core.BlockPos;
import net.minecraft.data.loot.packs.UpdateOneTwentyBuiltInLootTables;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SuspiciousSandBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;

public class ArchaeologyHandler
extends ProbabilityDataHandler<ArchaeologyHandler> {
    private static final DataParser PARSER = DataParser.of(DataHandlerType.CHEST, parser -> {
        parser.add("block", Blocks.f_271439_.m_49966_()).setDefaultValName("minecraft:suspicious_sand");
        parser.add("loot", UpdateOneTwentyBuiltInLootTables.f_271180_).setSuggestions(LootTableAlias.REGISTRY::getKeys, ResourceLocation::toString);
        parser.add("generation_chance", 1.0f, 0.0f, 1.0f);
    });
    private final ResourceLocation lootTable;
    private final BlockState block;

    public ArchaeologyHandler(DataMap data) {
        super(data, "generation_chance");
        this.lootTable = data.get("loot", ResourceLocation.class);
        this.block = data.get("block", BlockState.class);
    }

    public static DataParser parser() {
        return PARSER;
    }

    @Override
    protected void handle(BlockState dataHandler, BlockPos pos, WorldGenLevel level, RandomSource rand, BoundingBox bounds, StructurePiece piece) {
        if (level.m_246046_().m_245372_(FeatureFlags.f_244168_)) {
            BlockState state = this.createState(dataHandler, this.block);
            level.m_7731_(pos, state, 18);
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof SuspiciousSandBlockEntity) {
                SuspiciousSandBlockEntity sussyBlocka = (SuspiciousSandBlockEntity)blockEntity;
                sussyBlocka.m_272135_(this.lootTable, pos.m_121878_());
            }
        } else {
            level.m_7731_(pos, Blocks.f_49992_.m_49966_(), 18);
        }
    }
}

