/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.api.block;

import com.legacy.structure_gel.api.dimension.portal.GelPortalLogic;
import com.legacy.structure_gel.api.dimension.portal.GelTeleporter;
import com.legacy.structure_gel.core.capability.GelCapability;
import com.legacy.structure_gel.core.capability.entity.GelEntity;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Random;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.NetherPortalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class GelPortalBlock
extends NetherPortalBlock {
    private final BiFunction<ServerLevel, GelPortalBlock, GelTeleporter> teleporter;

    public GelPortalBlock(BlockBehaviour.Properties properties, BiFunction<ServerLevel, GelPortalBlock, GelTeleporter> teleporter) {
        super(properties);
        this.teleporter = teleporter;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderPortal(float timeInPortal, int screenHeight, int screenWidth) {
        if (timeInPortal < 1.0f) {
            timeInPortal *= timeInPortal;
            timeInPortal *= timeInPortal;
            timeInPortal = timeInPortal * 0.8f + 0.2f;
        }
        RenderSystem.m_69465_();
        RenderSystem.m_69458_((boolean)false);
        RenderSystem.m_69453_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)timeInPortal);
        RenderSystem.m_157456_((int)0, (ResourceLocation)InventoryMenu.f_39692_);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        TextureAtlasSprite sprite = this.getPortalTexture();
        float f = sprite.m_118409_();
        float f1 = sprite.m_118411_();
        float f2 = sprite.m_118410_();
        float f3 = sprite.m_118412_();
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder buffBuilder = tessellator.m_85915_();
        buffBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        buffBuilder.m_5483_(0.0, (double)screenHeight, -90.0).m_7421_(f, f3).m_5752_();
        buffBuilder.m_5483_((double)screenWidth, (double)screenHeight, -90.0).m_7421_(f2, f3).m_5752_();
        buffBuilder.m_5483_((double)screenWidth, 0.0, -90.0).m_7421_(f2, f1).m_5752_();
        buffBuilder.m_5483_(0.0, 0.0, -90.0).m_7421_(f, f1).m_5752_();
        tessellator.m_85914_();
        RenderSystem.m_69458_((boolean)true);
        RenderSystem.m_69482_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public TextureAtlasSprite getPortalTexture() {
        Minecraft mc = Minecraft.m_91087_();
        return mc.m_91289_().m_110907_().m_110882_(this.m_49966_());
    }

    @OnlyIn(value=Dist.CLIENT)
    public SoundInstance getTriggerSound() {
        return SimpleSoundInstance.m_119766_((SoundEvent)SoundEvents.f_12288_, (float)(new Random().nextFloat() * 0.4f + 0.8f), (float)0.25f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public SoundInstance getTravelSound() {
        return SimpleSoundInstance.m_119766_((SoundEvent)SoundEvents.f_12287_, (float)(new Random().nextFloat() * 0.4f + 0.8f), (float)0.25f);
    }

    public final GelTeleporter getTeleporter(ServerLevel level) {
        return this.teleporter.apply(level, this);
    }

    public Supplier<BlockState> getFrameBlock() {
        return this.teleporter.apply(null, this).getFrameBlock();
    }

    public int getMaxTimeInside(Entity entity) {
        return entity.m_6078_();
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource rand) {
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        Direction.Axis facingAxis = facing.m_122434_();
        Direction.Axis portalAxis = (Direction.Axis)state.m_61143_((Property)f_54904_);
        boolean flag = portalAxis != facingAxis && facingAxis.m_122479_();
        return !flag && !facingState.m_60713_((Block)this) && !GelPortalLogic.isPortalComplete(level, currentPos, portalAxis, this.getFrameBlock().get().m_60734_(), this) ? Blocks.f_50016_.m_49966_() : super.m_7417_(state, facing, facingState, level, currentPos, facingPos);
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        GelCapability.ifPresent(entity, gelEntity -> {
            if (!entity.m_20159_() && !entity.m_20160_() && entity.m_6072_()) {
                entity.m_20221_(pos);
                gelEntity.setPortal(this);
                GelEntity.setPortalClient(entity, this);
            }
        });
    }
}

