/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.util;

import com.google.common.collect.Streams;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.RegistryManager;
import net.minecraftforge.registries.tags.IReverseTag;

public final class TagUtil {
    public static <T> boolean isTaggedAs(T object, TagKey<T> tagKey, Level level) {
        return level.m_9598_().m_6632_(tagKey.f_203867_()).map(registry -> registry.m_263177_(object).m_203656_(tagKey)).orElse(false);
    }

    public static <T> Stream<TagKey<T>> getAllTagsFor(ResourceKey<? extends Registry<T>> registryKey, T object, Level level) {
        Optional vanillaRegistry = level.m_9598_().m_6632_(registryKey);
        return vanillaRegistry.map(registry -> registry.m_7854_(object).map(key -> registry.m_246971_(key).m_203616_()).orElse(Stream.empty())).orElseGet(() -> RegistryManager.ACTIVE.getRegistry(registryKey).tags().getReverseTag(object).map(IReverseTag::getTagKeys).orElseGet(Stream::empty));
    }

    public static <T> Stream<T> getTagContents(TagKey<T> tag, Level level) {
        Optional vanillaRegistry = level.m_9598_().m_6632_(tag.f_203867_());
        return vanillaRegistry.map(registry -> Streams.stream((Iterable)registry.m_206058_(tag)).map(Holder::get)).orElseGet(() -> RegistryManager.ACTIVE.getRegistry(tag.f_203867_()).tags().getTag(tag).stream());
    }

    @SafeVarargs
    public static <T extends Holder<T>> boolean isTaggedAsAny(T object, TagKey<T> ... tags) {
        for (TagKey<T> tag : tags) {
            if (!object.m_203656_(tag)) continue;
            return true;
        }
        return false;
    }
}

