/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.util;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.extensions.common.IClientMobEffectExtensions;
import net.tslat.aoa3.common.registration.AoAConfigs;
import org.joml.Matrix4f;

public final class RenderUtil {
    public static void renderTexture(PoseStack matrix, int x, int y, float u, float v, float width, float height) {
        RenderUtil.renderCustomSizedTexture(matrix, x, y, u, v, (int)width, (int)height, width, height);
    }

    public static void renderCustomSizedTexture(PoseStack matrix, int x, int y, float u, float v, float uWidth, float vHeight, float textureWidth, float textureHeight) {
        RenderUtil.renderScaledCustomSizedTexture(matrix, x, y, u, v, uWidth, vHeight, uWidth, vHeight, textureWidth, textureHeight);
    }

    public static void renderScaledCustomSizedTexture(PoseStack matrixStack, float x, float y, float u, float v, float uWidth, float vHeight, float renderWidth, float renderHeight, float textureWidth, float textureHeight) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        BufferBuilder buffer = Tesselator.m_85913_().m_85915_();
        Matrix4f matrix = matrixStack.m_85850_().m_252922_();
        float widthRatio = 1.0f / textureWidth;
        float heightRatio = 1.0f / textureHeight;
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        buffer.m_252986_(matrix, x, y + renderHeight, 0.0f).m_7421_(u * widthRatio, (v + vHeight) * heightRatio).m_5752_();
        buffer.m_252986_(matrix, x + renderWidth, y + renderHeight, 0.0f).m_7421_((u + uWidth) * widthRatio, (v + vHeight) * heightRatio).m_5752_();
        buffer.m_252986_(matrix, x + renderWidth, y, 0.0f).m_7421_((u + uWidth) * widthRatio, v * heightRatio).m_5752_();
        buffer.m_252986_(matrix, x, y, 0.0f).m_7421_(u * widthRatio, v * heightRatio).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)buffer.m_231175_());
    }

    public static void renderFullscreenTexture() {
        Minecraft mc = Minecraft.m_91087_();
        Window window = mc.m_91268_();
        RenderSystem.m_69465_();
        RenderSystem.m_69458_((boolean)false);
        RenderSystem.m_69453_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder buffer = tesselator.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        buffer.m_5483_(0.0, (double)window.m_85446_(), -90.0).m_7421_(0.0f, 1.0f).m_5752_();
        buffer.m_5483_((double)window.m_85445_(), (double)window.m_85446_(), -90.0).m_7421_(1.0f, 1.0f).m_5752_();
        buffer.m_5483_((double)window.m_85445_(), 0.0, -90.0).m_7421_(1.0f, 0.0f).m_5752_();
        buffer.m_5483_(0.0, 0.0, -90.0).m_7421_(0.0f, 0.0f).m_5752_();
        tesselator.m_85914_();
        RenderSystem.m_69458_((boolean)true);
        RenderSystem.m_69482_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void drawVerticalGradient(PoseStack matrixStack, int x, int y, int z, int width, int height, int topColour, int bottomColour) {
        float alphaTop = (float)(topColour >> 24 & 0xFF) / 255.0f;
        float redTop = (float)(topColour >> 16 & 0xFF) / 255.0f;
        float greenTop = (float)(topColour >> 8 & 0xFF) / 255.0f;
        float blueTop = (float)(topColour & 0xFF) / 255.0f;
        float alphaBottom = (float)(bottomColour >> 24 & 0xFF) / 255.0f;
        float redBottom = (float)(bottomColour >> 16 & 0xFF) / 255.0f;
        float greenBottom = (float)(bottomColour >> 8 & 0xFF) / 255.0f;
        float blueBottom = (float)(bottomColour & 0xFF) / 255.0f;
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        Matrix4f matrix = matrixStack.m_85850_().m_252922_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        bufferbuilder.m_252986_(matrix, (float)(x + width), (float)y, (float)z).m_85950_(redTop, greenTop, blueTop, alphaTop).m_5752_();
        bufferbuilder.m_252986_(matrix, (float)x, (float)y, (float)z).m_85950_(redTop, greenTop, blueTop, alphaTop).m_5752_();
        bufferbuilder.m_252986_(matrix, (float)x, (float)(y + height), (float)z).m_85950_(redBottom, greenBottom, blueBottom, alphaBottom).m_5752_();
        bufferbuilder.m_252986_(matrix, (float)(x + width), (float)(y + height), (float)z).m_85950_(redBottom, greenBottom, blueBottom, alphaBottom).m_5752_();
        tesselator.m_85914_();
        RenderSystem.m_69461_();
    }

    public static void drawColouredBox(PoseStack matrixStack, int x, int y, int z, int width, int height, int colour) {
        float alpha = (float)(colour >> 24 & 0xFF) / 255.0f;
        float red = (float)(colour >> 16 & 0xFF) / 255.0f;
        float green = (float)(colour >> 8 & 0xFF) / 255.0f;
        float blue = (float)(colour & 0xFF) / 255.0f;
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        Matrix4f matrix = matrixStack.m_85850_().m_252922_();
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        bufferBuilder.m_252986_(matrix, (float)x, (float)y + (float)height, (float)z).m_85950_(red, green, blue, alpha).m_5752_();
        bufferBuilder.m_252986_(matrix, (float)x + (float)width, (float)y + (float)height, (float)z).m_85950_(red, green, blue, alpha).m_5752_();
        bufferBuilder.m_252986_(matrix, (float)x + (float)width, (float)y, (float)z).m_85950_(red, green, blue, alpha).m_5752_();
        bufferBuilder.m_252986_(matrix, (float)x, (float)y, (float)z).m_85950_(red, green, blue, alpha).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
        RenderSystem.m_69461_();
    }

    public static void drawCenteredScaledMessage(PoseStack matrix, Font fontRenderer, Component msg, float x, float y, float scale, int colour, StringRenderType renderType) {
        matrix.m_85836_();
        matrix.m_85841_(scale, scale, 1.0f);
        float realX = (x - (float)fontRenderer.m_92852_((FormattedText)msg) * scale / 2.0f) / scale;
        float realY = y / scale;
        if (renderType == StringRenderType.OUTLINED) {
            fontRenderer.m_92889_(matrix, msg, realX, realY + 1.0f / scale, 0);
            fontRenderer.m_92889_(matrix, msg, realX, realY - 1.0f / scale, 0);
            fontRenderer.m_92889_(matrix, msg, realX + 1.0f / scale, realY, 0);
            fontRenderer.m_92889_(matrix, msg, realX - 1.0f / scale, realY, 0);
        }
        if (renderType == StringRenderType.DROP_SHADOW) {
            fontRenderer.m_92763_(matrix, msg, realX, realY, colour);
        } else {
            fontRenderer.m_92889_(matrix, msg, realX, realY, colour);
        }
        matrix.m_85849_();
    }

    public static void drawCenteredScaledString(PoseStack matrix, Font fontRenderer, String msg, float x, float y, float scale, int colour, StringRenderType renderType) {
        RenderUtil.drawCenteredScaledMessage(matrix, fontRenderer, (Component)Component.m_237113_((String)msg), x, y, scale, colour, renderType);
    }

    public static void drawScaledMessage(PoseStack matrix, Font fontRenderer, Component msg, float x, float y, float scale, int colour, StringRenderType renderType) {
        float realX = x / scale;
        float realY = y / scale;
        matrix.m_85836_();
        matrix.m_85841_(scale, scale, scale);
        if (renderType == StringRenderType.OUTLINED) {
            fontRenderer.m_92889_(matrix, msg, realX, realY + 1.0f / scale, 0);
            fontRenderer.m_92889_(matrix, msg, realX, realY - 1.0f / scale, 0);
            fontRenderer.m_92889_(matrix, msg, realX + 1.0f / scale, realY, 0);
            fontRenderer.m_92889_(matrix, msg, realX - 1.0f / scale, realY, 0);
        }
        if (renderType == StringRenderType.DROP_SHADOW) {
            fontRenderer.m_92763_(matrix, msg, realX, realY, colour);
        } else {
            fontRenderer.m_92889_(matrix, msg, realX, realY, colour);
        }
        matrix.m_85849_();
    }

    public static void drawScaledString(PoseStack matrix, Font fontRenderer, String msg, int x, int y, float scale, int colour, StringRenderType renderType) {
        RenderUtil.drawScaledMessage(matrix, fontRenderer, (Component)Component.m_237113_((String)msg), x, y, scale, colour, renderType);
    }

    public static void drawOutlinedText(PoseStack matrix, Font fontRenderer, String msg, int x, int y, int colour, float currentScale) {
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        fontRenderer.m_92883_(matrix, msg, (float)x, (float)y + 1.0f / currentScale, 0);
        fontRenderer.m_92883_(matrix, msg, (float)x, (float)y - 1.0f / currentScale, 0);
        fontRenderer.m_92883_(matrix, msg, (float)x + 1.0f / currentScale, (float)y, 0);
        fontRenderer.m_92883_(matrix, msg, (float)x - 1.0f / currentScale, (float)y, 0);
        fontRenderer.m_92883_(matrix, msg, (float)x, (float)y, colour);
    }

    public static void drawWrappedMessage(PoseStack matrix, Font fontRenderer, Component message, float x, float y, int maxLength, int color) {
        Matrix4f matrix4f = matrix.m_85850_().m_252922_();
        for (FormattedCharSequence processor : fontRenderer.m_92923_((FormattedText)message, maxLength)) {
            MultiBufferSource.BufferSource renderTypeBuffer = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
            fontRenderer.m_272191_(processor, x, y, color, false, matrix4f, (MultiBufferSource)renderTypeBuffer, Font.DisplayMode.NORMAL, 0, 0xF000F0);
            renderTypeBuffer.m_109911_();
            Objects.requireNonNull(fontRenderer);
            y += 9.0f;
        }
    }

    public static void renderItemInGui(PoseStack matrix, Minecraft mc, ItemStack stack, int x, int y) {
        boolean useItemLight;
        BakedModel model = mc.m_91291_().m_174264_(stack, null, null, 0);
        matrix.m_85836_();
        RenderSystem.m_157427_(GameRenderer::m_172820_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)InventoryMenu.f_39692_);
        mc.m_91097_().m_118506_(InventoryMenu.f_39692_).m_117960_(false, false);
        RenderSystem.m_69478_();
        RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        matrix.m_85837_((double)x, (double)y, 100.0);
        matrix.m_252880_(8.0f, 8.0f, 0.0f);
        matrix.m_85841_(1.0f, -1.0f, 1.0f);
        matrix.m_85841_(16.0f, 16.0f, 16.0f);
        MultiBufferSource.BufferSource renderTypeBuffer = Minecraft.m_91087_().m_91269_().m_110104_();
        boolean bl = useItemLight = !model.m_7547_();
        if (useItemLight) {
            Lighting.m_84930_();
        }
        mc.m_91291_().m_115143_(stack, ItemDisplayContext.GUI, false, matrix, (MultiBufferSource)renderTypeBuffer, 0xF000F0, OverlayTexture.f_118083_, model);
        renderTypeBuffer.m_109911_();
        RenderSystem.m_69482_();
        if (useItemLight) {
            Lighting.m_84931_();
        }
        matrix.m_85849_();
    }

    public static int getPotionGuiRenderOffset() {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null || mc.f_91074_.m_21220_().isEmpty() || ((Boolean)AoAConfigs.CLIENT.disableHudPotionOffset.get()).booleanValue()) {
            return 0;
        }
        int effectRenderYOffset = 0;
        for (MobEffectInstance effect : mc.f_91074_.m_21220_()) {
            if (effect.m_19557_() <= 0 || !IClientMobEffectExtensions.DEFAULT.isVisibleInGui(effect) || !effect.m_19572_()) continue;
            if (!effect.m_19544_().m_19486_()) {
                effectRenderYOffset = 50;
                break;
            }
            effectRenderYOffset = 25;
        }
        return effectRenderYOffset;
    }

    public static void prepRenderTexture(ResourceLocation texture) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderUtil.setRenderingTexture(texture);
    }

    public static void setRenderingTexture(ResourceLocation texture) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)texture);
    }

    public static void resetShaderColour() {
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void setDefaultAlphaBlend() {
        RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
    }

    public static int selectVForWidgetState(AbstractWidget widget, int disabledV, int activeV, int focussedV) {
        return widget.m_142518_() ? (widget.m_198029_() ? focussedV : activeV) : disabledV;
    }

    public static enum StringRenderType {
        NORMAL,
        DROP_SHADOW,
        OUTLINED;

    }
}

