/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.util;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.tslat.smartbrainlib.util.RandomUtil;

public final class PositionAndMotionUtil {
    public static Vec3 accountForGravity(Vec3 origin, Vec3 velocity, Vec3 targetPos, double gravity) {
        double latDist = targetPos.m_82546_(origin).m_165924_();
        double ticksToTravel = latDist / velocity.m_165924_();
        return velocity.m_82520_(0.0, 0.5 * gravity * Math.ceil(ticksToTravel), 0.0);
    }

    public static void turnToFace(Entity entity, Vec3 targetPosition) {
        Vec3 position = entity.m_146892_();
        double lengthX = targetPosition.m_7096_() - position.m_7096_();
        double lengthY = targetPosition.m_7098_() - position.m_7098_();
        double lengthZ = targetPosition.m_7094_() - position.m_7094_();
        entity.m_146926_((float)Math.toDegrees(Mth.m_14136_((double)lengthZ, (double)lengthX)) - 90.0f);
        entity.m_146922_((float)Math.toDegrees(-Mth.m_14136_((double)lengthY, (double)Math.sqrt(lengthX * lengthX + lengthZ * lengthZ))));
        entity.f_19860_ = entity.m_146909_();
        entity.f_19859_ = entity.m_146908_();
    }

    public static void faceTowardsMotion(Entity entity) {
        Vec3 velocity = entity.m_20184_();
        entity.m_146922_((float)Math.toDegrees(Mth.m_14136_((double)velocity.m_7096_(), (double)velocity.m_7094_())));
        entity.m_146926_((float)Math.toDegrees(Mth.m_14136_((double)velocity.m_7098_(), (double)velocity.m_165924_())));
        entity.f_19859_ = entity.m_146908_();
        entity.f_19860_ = entity.m_146909_();
    }

    public static void moveTowards(Entity entity, Vec3 targetPosition, double blocksPerSecond, double inaccuracy) {
        PositionAndMotionUtil.moveTowards(entity, targetPosition, blocksPerSecond, (double)0.0075f * inaccuracy, (double)0.0075f * inaccuracy);
    }

    public static void moveTowards(Entity entity, Vec3 targetPosition, double blocksPerSecond, double lateralVariance, double verticalVariance) {
        Vec3 origin = entity.m_20182_();
        Vec3 velocity = new Vec3(targetPosition.m_7096_() - origin.m_7096_(), targetPosition.m_7098_() - origin.m_7098_(), targetPosition.m_7094_() - origin.m_7094_()).m_82541_();
        if (lateralVariance != 0.0 || verticalVariance != 0.0) {
            velocity = velocity.m_82520_(RandomUtil.randomScaledGaussianValue((double)lateralVariance), RandomUtil.randomScaledGaussianValue((double)verticalVariance), RandomUtil.randomScaledGaussianValue((double)lateralVariance));
        }
        entity.m_20256_(velocity.m_82490_(blocksPerSecond));
    }

    public static void moveRelativeToFacing(Entity entity, double moveLeft, double moveForward, double moveUp) {
        entity.m_146884_(PositionAndMotionUtil.moveRelativeToFacing(entity.m_20182_(), entity.m_146908_(), moveLeft, moveForward, moveUp));
    }

    public static Vec3 moveRelativeToFacing(Vec3 position, float yRot, double moveLeft, double moveForward, double moveUp) {
        double radians;
        double x = 0.0;
        double z = 0.0;
        if (moveLeft != 0.0) {
            radians = Math.toRadians(yRot - 180.0f);
            x += moveLeft * -Math.cos(radians);
            z += moveLeft * -Math.sin(radians);
        }
        if (moveForward != 0.0) {
            radians = Math.toRadians(yRot - 90.0f);
            x += moveForward * -Math.cos(radians);
            z += moveForward * -Math.sin(radians);
        }
        return position.m_82520_(x, moveUp, z);
    }

    public static Vec3 moveDownToGround(Level level, Vec3 pos) {
        BlockPos.MutableBlockPos testPos = new BlockPos.MutableBlockPos(pos.f_82479_, pos.f_82480_, pos.f_82481_);
        while (!level.m_8055_((BlockPos)testPos.m_122173_(Direction.DOWN)).m_60767_().m_76334_() && testPos.m_123342_() > level.m_141937_()) {
        }
        return new Vec3(pos.f_82479_, (double)(testPos.m_123342_() + 1), pos.f_82481_);
    }

    public static Vec3 moveUpToSurface(Level level, Vec3 pos) {
        BlockPos.MutableBlockPos testPos = new BlockPos.MutableBlockPos(pos.f_82479_, pos.f_82480_, pos.f_82481_);
        while (level.m_8055_((BlockPos)testPos.m_122173_(Direction.UP)).m_60767_().m_76334_() && testPos.m_123342_() < level.m_151558_()) {
        }
        return new Vec3(pos.f_82479_, (double)testPos.m_123342_(), pos.f_82481_);
    }
}

