/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.util;

import com.google.common.collect.Multimap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.tslat.aoa3.common.registration.AoATags;
import net.tslat.aoa3.common.registration.item.AoAEnchantments;
import net.tslat.aoa3.common.registration.item.AoAItems;
import net.tslat.aoa3.content.item.armour.AdventArmour;
import net.tslat.aoa3.util.PlayerUtil;

public final class ItemUtil {
    public static Tier customItemTier(final int durability, final float efficiency, final float attackDamage, final int harvestLevel, final int enchantability, final @Nullable Supplier<Item> repairMaterial, final @Nullable TagKey<Block> toolTypeTag) {
        return new Tier(){

            public int m_6609_() {
                return durability;
            }

            public float m_6624_() {
                return efficiency;
            }

            public float m_6631_() {
                return attackDamage;
            }

            public int m_6604_() {
                return harvestLevel;
            }

            public int m_6601_() {
                return enchantability;
            }

            public Ingredient m_6282_() {
                return repairMaterial == null ? Ingredient.f_43901_ : Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)repairMaterial.get()});
            }

            @Nullable
            public TagKey<Block> getTag() {
                return toolTypeTag;
            }
        };
    }

    public static ArmorMaterial customArmourMaterial(final String name, final int durabilityBase, final int[] protectionValues, final int enchantability, final SoundEvent equipSound, final float toughness) {
        return new ArmorMaterial(){

            public int m_266425_(ArmorItem.Type slot) {
                return switch (slot) {
                    default -> throw new IncompatibleClassChangeError();
                    case ArmorItem.Type.HELMET -> 11 * durabilityBase;
                    case ArmorItem.Type.CHESTPLATE -> 16 * durabilityBase;
                    case ArmorItem.Type.LEGGINGS -> 15 * durabilityBase;
                    case ArmorItem.Type.BOOTS -> 13 * durabilityBase;
                };
            }

            public int m_7366_(ArmorItem.Type slot) {
                return protectionValues[slot.m_266308_().m_20749_()];
            }

            public int m_6646_() {
                return enchantability;
            }

            public SoundEvent m_7344_() {
                return equipSound;
            }

            public Ingredient m_6230_() {
                return Ingredient.f_43901_;
            }

            public String m_6082_() {
                return name;
            }

            public float m_6651_() {
                return toughness;
            }

            public float m_6649_() {
                return 0.0f;
            }
        };
    }

    public static boolean hasEnchantment(Enchantment enchant, ItemStack stack) {
        return EnchantmentHelper.m_44843_((Enchantment)enchant, (ItemStack)stack) > 0;
    }

    public static void damageItem(ItemStack stack, LivingEntity entity, InteractionHand hand) {
        ItemUtil.damageItem(stack, entity, hand, 1);
    }

    public static void damageItem(ItemStack stack, LivingEntity entity, InteractionHand hand, int amount) {
        ItemUtil.damageItem(stack, entity, amount, PlayerUtil.handToEquipmentSlotType(hand));
    }

    public static void damageItem(ItemStack stack, LivingEntity entity, int amount, EquipmentSlot slot) {
        stack.m_41622_(amount, entity, user -> user.m_21166_(slot));
    }

    public static void givePlayerMultipleItems(Player pl, ItemStack ... stacks) {
        ItemUtil.givePlayerMultipleItems(pl, Arrays.asList(stacks));
    }

    public static void givePlayerMultipleItems(Player pl, Collection<ItemStack> stacks) {
        for (ItemStack stack : stacks) {
            if (stack.m_41619_() || pl.m_150109_().m_36054_(stack)) continue;
            pl.m_5552_(stack, 0.5f);
        }
        if (!stacks.isEmpty()) {
            pl.f_36095_.m_38946_();
        }
    }

    public static void givePlayerItemOrDrop(Player player, ItemStack stack) {
        if (stack.m_41619_()) {
            return;
        }
        if (!player.m_150109_().m_36054_(stack)) {
            player.m_5552_(stack, 0.5f);
        }
        player.f_36095_.m_38946_();
    }

    public static boolean isHoldingItem(LivingEntity entity, Item item) {
        return entity.m_21205_().m_41720_() == item || entity.m_21206_().m_41720_() == item;
    }

    public static ItemStack removeEnchantment(ItemStack stack, Enchantment ench) {
        ItemStack newStack = stack.m_41777_();
        Map enchants = EnchantmentHelper.m_44831_((ItemStack)newStack);
        if (enchants.containsKey(ench)) {
            enchants.remove(ench);
            EnchantmentHelper.m_44865_((Map)enchants, (ItemStack)newStack);
        }
        return newStack;
    }

    public static void setAttribute(Multimap<Attribute, AttributeModifier> map, Attribute att, UUID id, double value) {
        Collection modifiers = map.get((Object)att);
        Optional<AttributeModifier> mod = modifiers.stream().filter(attributeModifier -> attributeModifier.m_22209_().equals(id)).findFirst();
        if (mod.isPresent()) {
            AttributeModifier existingMod = mod.get();
            modifiers.remove(existingMod);
            modifiers.add(new AttributeModifier(existingMod.m_22209_(), existingMod.m_22214_(), value, existingMod.m_22217_()));
        }
    }

    public static void clearInventoryOfItems(Player player, ItemStack ... stacks) {
        if (player.m_7500_()) {
            return;
        }
        ItemStack checkStack = player.m_21120_(InteractionHand.MAIN_HAND);
        if (!checkStack.m_41619_()) {
            for (Object stack : stacks) {
                if (!ItemUtil.areStacksFunctionallyEqual(checkStack, stack)) continue;
                checkStack.m_41764_(0);
                break;
            }
        }
        if (!(checkStack = player.m_21120_(InteractionHand.OFF_HAND)).m_41619_()) {
            for (Object stack : stacks) {
                if (!ItemUtil.areStacksFunctionallyEqual(checkStack, stack)) continue;
                checkStack.m_41764_(0);
                break;
            }
        }
        block2: for (ItemStack checkStack2 : player.m_150109_().f_35974_) {
            if (checkStack2.m_41619_()) continue;
            ItemStack[] itemStackArray = stacks;
            int n = itemStackArray.length;
            for (int i = 0; i < n; ++i) {
                ItemStack stack = itemStackArray[i];
                if (!ItemUtil.areStacksFunctionallyEqual(checkStack2, stack)) continue;
                checkStack2.m_41764_(0);
                continue block2;
            }
        }
        block4: for (ItemStack checkStack2 : player.m_150109_().f_35975_) {
            if (checkStack2.m_41619_()) continue;
            for (ItemStack stack : stacks) {
                if (!ItemUtil.areStacksFunctionallyEqual(checkStack2, stack)) continue;
                checkStack2.m_41764_(0);
                continue block4;
            }
        }
    }

    public static boolean findItemByTag(Player player, TagKey<Item> tag, boolean consumeItem, int amount) {
        if (amount <= 0 || player.m_7500_()) {
            return true;
        }
        if (amount == 1) {
            ItemStack checkStack = player.m_21120_(InteractionHand.MAIN_HAND);
            if (checkStack.m_204117_(tag) && !checkStack.m_41619_()) {
                if (consumeItem) {
                    checkStack.m_41774_(1);
                }
                return true;
            }
            checkStack = player.m_21120_(InteractionHand.OFF_HAND);
            if (checkStack.m_204117_(tag) && !checkStack.m_41619_()) {
                if (consumeItem) {
                    checkStack.m_41774_(1);
                }
                return true;
            }
            for (ItemStack checkStack2 : player.m_150109_().f_35974_) {
                if (checkStack2.m_41619_() || !checkStack2.m_204117_(tag)) continue;
                if (consumeItem) {
                    checkStack2.m_41774_(1);
                }
                return true;
            }
            for (ItemStack checkStack2 : player.m_150109_().f_35975_) {
                if (checkStack2.m_41619_() || !checkStack2.m_204117_(tag)) continue;
                if (consumeItem) {
                    checkStack2.m_41774_(1);
                }
                return true;
            }
            return false;
        }
        ObjectArrayList matchedStacks = new ObjectArrayList();
        int foundCount = 0;
        ItemStack checkStack = player.m_21120_(InteractionHand.MAIN_HAND);
        if (checkStack.m_204117_(tag) && !checkStack.m_41619_()) {
            matchedStacks.add(checkStack);
            foundCount += checkStack.m_41613_();
        }
        if (foundCount < amount && (checkStack = player.m_21120_(InteractionHand.OFF_HAND)).m_204117_(tag) && !checkStack.m_41619_()) {
            matchedStacks.add(checkStack);
            foundCount += checkStack.m_41613_();
        }
        if (foundCount < amount) {
            for (ItemStack checkStack2 : player.m_150109_().f_35974_) {
                if (checkStack2.m_41619_() || !checkStack2.m_204117_(tag)) continue;
                matchedStacks.add(checkStack2);
                if ((foundCount += checkStack2.m_41613_()) < amount) continue;
                break;
            }
        }
        if (foundCount < amount) {
            for (ItemStack checkStack2 : player.m_150109_().f_35975_) {
                if (checkStack2.m_41619_() || !checkStack2.m_204117_(tag)) continue;
                matchedStacks.add(checkStack2);
                if ((foundCount += checkStack2.m_41613_()) < amount) continue;
                break;
            }
        }
        if (foundCount < amount) {
            return false;
        }
        if (!consumeItem) {
            return true;
        }
        for (ItemStack matchedStack : matchedStacks) {
            int consumeAmount = Math.min(matchedStack.m_41613_(), Math.min(amount, foundCount));
            matchedStack.m_41774_(consumeAmount);
            foundCount -= consumeAmount;
        }
        return true;
    }

    public static boolean findInventoryItem(Player player, ItemStack stack, boolean consumeItem, int amount) {
        if (stack.m_41619_()) {
            return false;
        }
        if (amount <= 0 || player.m_7500_()) {
            return true;
        }
        if (amount == 1) {
            ItemStack checkStack = player.m_21120_(InteractionHand.MAIN_HAND);
            if (ItemUtil.areStacksFunctionallyEqual(checkStack, stack) && !checkStack.m_41619_()) {
                if (consumeItem) {
                    checkStack.m_41774_(1);
                }
                return true;
            }
            checkStack = player.m_21120_(InteractionHand.OFF_HAND);
            if (ItemUtil.areStacksFunctionallyEqual(checkStack, stack) && !checkStack.m_41619_()) {
                if (consumeItem) {
                    checkStack.m_41774_(1);
                }
                return true;
            }
            for (ItemStack checkStack2 : player.m_150109_().f_35974_) {
                if (checkStack2.m_41619_() || !ItemUtil.areStacksFunctionallyEqual(stack, checkStack2)) continue;
                if (consumeItem) {
                    checkStack2.m_41774_(1);
                }
                return true;
            }
            for (ItemStack checkStack2 : player.m_150109_().f_35975_) {
                if (checkStack2.m_41619_() || !ItemUtil.areStacksFunctionallyEqual(stack, checkStack2)) continue;
                if (consumeItem) {
                    checkStack2.m_41774_(1);
                }
                return true;
            }
            return false;
        }
        ObjectArrayList matchedStacks = new ObjectArrayList();
        int foundCount = 0;
        ItemStack checkStack = player.m_21120_(InteractionHand.MAIN_HAND);
        if (ItemUtil.areStacksFunctionallyEqual(checkStack, stack) && !checkStack.m_41619_()) {
            matchedStacks.add(checkStack);
            foundCount += checkStack.m_41613_();
        }
        if (foundCount < amount && ItemUtil.areStacksFunctionallyEqual(checkStack = player.m_21120_(InteractionHand.OFF_HAND), stack) && !checkStack.m_41619_()) {
            matchedStacks.add(checkStack);
            foundCount += checkStack.m_41613_();
        }
        if (foundCount < amount) {
            for (ItemStack checkStack2 : player.m_150109_().f_35974_) {
                if (checkStack2.m_41619_() || !ItemUtil.areStacksFunctionallyEqual(stack, checkStack2)) continue;
                matchedStacks.add(checkStack2);
                if ((foundCount += checkStack2.m_41613_()) < amount) continue;
                break;
            }
        }
        if (foundCount < amount) {
            for (ItemStack checkStack2 : player.m_150109_().f_35975_) {
                if (checkStack2.m_41619_() || !ItemUtil.areStacksFunctionallyEqual(stack, checkStack2)) continue;
                matchedStacks.add(checkStack2);
                if ((foundCount += checkStack2.m_41613_()) < amount) continue;
                break;
            }
        }
        if (foundCount < amount) {
            return false;
        }
        if (!consumeItem) {
            return true;
        }
        for (ItemStack matchedStack : matchedStacks) {
            int consumeAmount = Math.min(matchedStack.m_41613_(), Math.min(amount, foundCount));
            matchedStack.m_41774_(consumeAmount);
            foundCount -= consumeAmount;
        }
        return true;
    }

    public static boolean findAndConsumeRunes(HashMap<Item, Integer> runeMap, ServerPlayer player, boolean allowBuffs, @Nonnull ItemStack heldItem) {
        int amount;
        Item type;
        if (player.m_7500_()) {
            return true;
        }
        AdventArmour.Type armour = PlayerUtil.getAdventPlayer(player).equipment().getCurrentFullArmourSet();
        int archmage = allowBuffs ? EnchantmentHelper.m_44843_((Enchantment)((Enchantment)AoAEnchantments.ARCHMAGE.get()), (ItemStack)heldItem) : 0;
        boolean nightmareArmour = allowBuffs && armour == AdventArmour.Type.NIGHTMARE;
        boolean greed = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)AoAEnchantments.GREED.get()), (ItemStack)heldItem) > 0;
        HashMap<Item, Integer> requiredRunes = new HashMap<Item, Integer>();
        for (Map.Entry<Item, Integer> runeEntry : runeMap.entrySet()) {
            if (!allowBuffs || archmage == 0 && !nightmareArmour && !greed) {
                requiredRunes.putAll(runeMap);
                break;
            }
            int amount2 = runeEntry.getValue();
            if (greed) {
                amount2 += 2;
            }
            if (archmage > 0) {
                amount2 -= archmage;
            }
            if (nightmareArmour) {
                --amount2;
                if (runeEntry.getKey() == AoAItems.DISTORTION_RUNE.get()) continue;
            }
            if (amount2 <= 0) {
                amount2 = 1;
            }
            requiredRunes.put(runeEntry.getKey(), amount2);
        }
        if (requiredRunes.isEmpty()) {
            return true;
        }
        HashSet<Integer> runeSlots = new HashSet<Integer>();
        HashMap<Item, Integer> runeCounter = new HashMap<Item, Integer>(requiredRunes);
        ItemStack mainHandStack = player.m_21120_(InteractionHand.OFF_HAND);
        ItemStack offHandStack = player.m_21120_(InteractionHand.MAIN_HAND);
        if (mainHandStack.m_204117_(AoATags.Items.ADVENT_RUNE) && runeCounter.containsKey(type = mainHandStack.m_41720_())) {
            amount = (Integer)runeCounter.get(type);
            runeSlots.add(-1);
            if ((amount -= mainHandStack.m_41613_()) > 0) {
                runeCounter.put(type, amount);
            } else {
                runeCounter.remove(type);
            }
        }
        if (!runeCounter.isEmpty() && offHandStack.m_204117_(AoATags.Items.ADVENT_RUNE) && runeCounter.containsKey(type = offHandStack.m_41720_())) {
            amount = (Integer)runeCounter.get(type);
            runeSlots.add(-2);
            if ((amount -= offHandStack.m_41613_()) > 0) {
                runeCounter.put(type, amount);
            } else {
                runeCounter.remove(type);
            }
        }
        if (!runeCounter.isEmpty()) {
            for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
                Item type2;
                ItemStack stack = player.m_150109_().m_8020_(i);
                if (!stack.m_204117_(AoATags.Items.ADVENT_RUNE) || !runeCounter.containsKey(type2 = stack.m_41720_())) continue;
                int amount3 = (Integer)runeCounter.get(type2);
                runeSlots.add(i);
                if ((amount3 -= stack.m_41613_()) > 0) {
                    runeCounter.put(type2, amount3);
                } else {
                    runeCounter.remove(type2);
                }
                if (runeCounter.isEmpty()) break;
            }
        }
        if (runeCounter.isEmpty()) {
            int remaining;
            if (runeSlots.contains(-1)) {
                ItemStack rune = player.m_21120_(InteractionHand.MAIN_HAND);
                Item type3 = rune.m_41720_();
                int amount4 = (Integer)requiredRunes.get(type3);
                remaining = amount4 - rune.m_41613_();
                rune.m_41774_(amount4);
                if (remaining <= 0) {
                    requiredRunes.remove(type3);
                } else {
                    requiredRunes.put(type3, remaining);
                }
                runeSlots.remove(-1);
            }
            if (runeSlots.contains(-2)) {
                ItemStack rune = player.m_21120_(InteractionHand.OFF_HAND);
                Item type4 = rune.m_41720_();
                int amount5 = (Integer)requiredRunes.get(type4);
                remaining = amount5 - rune.m_41613_();
                rune.m_41774_(amount5);
                if (remaining <= 0) {
                    requiredRunes.remove(type4);
                } else {
                    requiredRunes.put(type4, remaining);
                }
                runeSlots.remove(-2);
            }
            Iterator iterator = runeSlots.iterator();
            while (iterator.hasNext()) {
                int slotId = (Integer)iterator.next();
                ItemStack rune = player.m_150109_().m_8020_(slotId);
                Item type5 = rune.m_41720_();
                int amount6 = (Integer)requiredRunes.get(type5);
                int remaining2 = amount6 - rune.m_41613_();
                rune.m_41774_(amount6);
                if (remaining2 <= 0) {
                    requiredRunes.remove(type5);
                } else {
                    requiredRunes.put(type5, remaining2);
                }
                if (!requiredRunes.isEmpty()) continue;
                break;
            }
            return true;
        }
        return false;
    }

    public static boolean hasItemInHotbar(Player player, Item item) {
        return ItemUtil.getStackFromInventory(player, item) != null;
    }

    @Nullable
    public static ItemStack getStackFromHotbar(Player player, Item item) {
        for (int i = 0; i < 9; ++i) {
            ItemStack stack = player.m_150109_().m_8020_(i);
            if (stack.m_41720_() != item) continue;
            return stack;
        }
        return null;
    }

    public static boolean hasItemInOffhand(Player player, Item item) {
        return player.m_21120_(InteractionHand.OFF_HAND).m_41720_() == item;
    }

    @Nullable
    public static ItemStack getStackFromInventory(Player player, Item item) {
        ItemStack stack = new ItemStack((ItemLike)item);
        ItemStack checkStack = player.m_21120_(InteractionHand.MAIN_HAND);
        if (ItemUtil.areStacksFunctionallyEqual(checkStack, stack) && !checkStack.m_41619_()) {
            return checkStack;
        }
        checkStack = player.m_21120_(InteractionHand.OFF_HAND);
        if (ItemUtil.areStacksFunctionallyEqual(checkStack, stack) && !checkStack.m_41619_()) {
            return checkStack;
        }
        for (ItemStack checkStack2 : player.m_150109_().f_35974_) {
            if (checkStack2.m_41619_() || !ItemUtil.areStacksFunctionallyEqual(stack, checkStack2)) continue;
            return checkStack2;
        }
        for (ItemStack checkStack2 : player.m_150109_().f_35975_) {
            if (checkStack2.m_41619_() || !ItemUtil.areStacksFunctionallyEqual(stack, checkStack2)) continue;
            return checkStack2;
        }
        return null;
    }

    public static boolean areStacksFunctionallyEqual(ItemStack a, ItemStack b) {
        if (a.m_41720_() != b.m_41720_()) {
            return false;
        }
        if (a.m_41763_() ^ b.m_41763_()) {
            return false;
        }
        return a.m_41763_() || a.m_41773_() == b.m_41773_();
    }

    public static List<ItemStack> increaseStackSize(ItemStack stack, int addAmount) {
        int maxCount = stack.m_41741_();
        if (stack.m_41613_() + addAmount <= maxCount) {
            stack.m_41764_(stack.m_41613_() + addAmount);
            return Collections.emptyList();
        }
        ObjectArrayList newStacks = new ObjectArrayList((int)((float)(addAmount + stack.m_41613_()) / (float)maxCount));
        while (addAmount > 0) {
            ItemStack copy = stack.m_41777_();
            copy.m_41764_(Math.min(maxCount, addAmount));
            newStacks.add(copy);
            addAmount -= copy.m_41613_();
        }
        return newStacks;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isHoe(Item item) {
        if (!(item instanceof DiggerItem)) return false;
        DiggerItem digger = (DiggerItem)item;
        if (digger.f_40979_ == BlockTags.f_144281_) return true;
        if (!(digger instanceof HoeItem)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isPickaxe(Item item) {
        if (!(item instanceof DiggerItem)) return false;
        DiggerItem digger = (DiggerItem)item;
        if (digger.f_40979_ == BlockTags.f_144282_) return true;
        if (!(digger instanceof PickaxeItem)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isAxe(Item item) {
        if (!(item instanceof DiggerItem)) return false;
        DiggerItem digger = (DiggerItem)item;
        if (digger.f_40979_ == BlockTags.f_144280_) return true;
        if (!(digger instanceof AxeItem)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isShovel(Item item) {
        if (!(item instanceof DiggerItem)) return false;
        DiggerItem digger = (DiggerItem)item;
        if (digger.f_40979_ == BlockTags.f_144283_) return true;
        if (!(digger instanceof ShovelItem)) return false;
        return true;
    }
}

