/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.util;

import com.google.common.base.Suppliers;
import java.time.LocalDate;
import java.time.Month;
import java.util.function.Supplier;

public final class HolidayUtil {
    private static final Supplier<Holiday> CURRENT_HOLIDAY = Suppliers.memoize(() -> {
        LocalDate date = LocalDate.now();
        if (date.isEqual(LocalDate.of(date.getYear(), Month.APRIL, 1))) {
            return Holiday.APRIL_FOOLS;
        }
        if (date.isEqual(LocalDate.of(date.getYear(), Month.DECEMBER, 25))) {
            return Holiday.CHRISTMAS;
        }
        if (date.isEqual(LocalDate.of(date.getYear(), Month.OCTOBER, 31))) {
            return Holiday.HALLOWEEN;
        }
        return Holiday.NONE;
    });

    public static Holiday getCurrentHoliday() {
        return CURRENT_HOLIDAY.get();
    }

    public static boolean isChristmas() {
        return HolidayUtil.getCurrentHoliday() == Holiday.CHRISTMAS;
    }

    public static boolean isHalloween() {
        return HolidayUtil.getCurrentHoliday() == Holiday.HALLOWEEN;
    }

    public static boolean isAprilFools() {
        return HolidayUtil.getCurrentHoliday() == Holiday.APRIL_FOOLS;
    }

    public static enum Holiday {
        NONE,
        CHRISTMAS,
        HALLOWEEN,
        APRIL_FOOLS;

    }
}

