/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.CombatEntry;
import net.minecraft.world.damagesource.CombatTracker;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.FlyingMob;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.entity.PartEntity;
import net.tslat.aoa3.util.PlayerUtil;
import net.tslat.effectslib.api.util.EffectBuilder;
import net.tslat.smartbrainlib.util.EntityRetrievalUtil;
import org.jetbrains.annotations.Nullable;

public final class EntityUtil {
    public static boolean isVulnerableEntity(Entity entity, @javax.annotation.Nullable DamageSource source) {
        Player player;
        if (!(entity instanceof LivingEntity) || !entity.m_6084_()) {
            return false;
        }
        if (source == null ? entity.m_20147_() : entity.m_6673_(source)) {
            return false;
        }
        return !(entity instanceof Player) || PlayerUtil.shouldPlayerBeAffected(player = (Player)entity);
    }

    public static boolean isHostileMob(Entity entity) {
        return entity instanceof Enemy;
    }

    public static void healEntity(LivingEntity entity, float amount) {
        if (amount > 0.0f && entity.m_6084_() && entity.m_21223_() > 0.0f && entity.m_21223_() < entity.m_21233_()) {
            entity.m_5634_(amount);
        }
    }

    public static float getCurrentHealthPercent(LivingEntity entity) {
        return entity.m_21223_() / entity.m_21233_();
    }

    public static boolean checkAboveHealthPercentThreshold(LivingEntity entity, float thresholdPercent) {
        if (entity.m_21223_() <= 0.0f) {
            return false;
        }
        return EntityUtil.getCurrentHealthPercent(entity) >= thresholdPercent;
    }

    public static boolean checkBelowHealthPercentThreshold(LivingEntity entity, float thresholdPercent) {
        if (entity.m_21223_() <= 0.0f) {
            return false;
        }
        return EntityUtil.getCurrentHealthPercent(entity) < thresholdPercent;
    }

    public static boolean isImmuneToSpecialAttacks(Entity target, LivingEntity attacker) {
        return target instanceof Player || !target.m_6072_() || target.m_20147_() || target.m_6095_().m_204039_(Tags.EntityTypes.BOSSES) || target instanceof LivingEntity && ((LivingEntity)target).m_21233_() > 500.0f;
    }

    public static float getAttackCooldown(LivingEntity entity) {
        if (entity instanceof Player) {
            return ((Player)entity).m_36403_(0.0f);
        }
        return 1.0f;
    }

    public static boolean isFlyingCreature(Entity entity) {
        return entity instanceof LivingEntity && (entity instanceof FlyingMob || entity instanceof FlyingAnimal);
    }

    public static void reapplyAttributeModifier(LivingEntity entity, Attribute attribute, AttributeModifier modifier, boolean permanentModifier) {
        AttributeInstance instance = entity.m_21051_(attribute);
        if (instance != null) {
            if (instance.m_22111_(modifier.m_22209_()) != null) {
                instance.m_22120_(modifier.m_22209_());
            }
            if (permanentModifier) {
                instance.m_22125_(modifier);
            } else {
                instance.m_22118_(modifier);
            }
            if (attribute == Attributes.f_22276_ && entity.m_21223_() > entity.m_21233_()) {
                entity.m_21153_(entity.m_21233_());
            }
        }
    }

    public static void applyAttributeModifierSafely(LivingEntity entity, Attribute attribute, AttributeModifier modifier, boolean permanentModifier) {
        AttributeInstance instance = entity.m_21051_(attribute);
        if (instance != null && !instance.m_22109_(modifier)) {
            if (permanentModifier) {
                instance.m_22125_(modifier);
            } else {
                instance.m_22118_(modifier);
            }
        }
    }

    public static void removeAttributeModifier(LivingEntity entity, Attribute attribute, AttributeModifier modifier) {
        EntityUtil.removeAttributeModifier(entity, attribute, modifier.m_22209_());
    }

    public static void removeAttributeModifier(LivingEntity entity, Attribute attribute, UUID modifierId) {
        AttributeModifier modifier;
        AttributeInstance instance = entity.m_21051_(attribute);
        if (instance != null && (modifier = instance.m_22111_(modifierId)) != null) {
            instance.m_22130_(modifier);
            if (attribute == Attributes.f_22276_ && entity.m_21223_() > entity.m_21233_()) {
                entity.m_21153_(entity.m_21233_());
            }
        }
    }

    public static double safelyGetAttributeValue(LivingEntity entity, Attribute attribute) {
        AttributeMap attributes = entity.m_21204_();
        return attributes.m_22171_(attribute) ? attributes.m_22181_(attribute) : 0.0;
    }

    public static void pushEntityAway(@Nonnull Entity centralEntity, @Nonnull Entity targetEntity, float strength) {
        Vec3 targetMotion = targetEntity.m_20184_();
        targetEntity.m_20334_((targetEntity.m_20165_(0.5) - centralEntity.m_20165_(0.5)) * (double)strength + targetMotion.m_7096_(), (targetEntity.m_20186_() - centralEntity.m_20186_()) * (double)strength + targetMotion.m_7098_(), (targetEntity.m_20246_(0.5) - centralEntity.m_20246_(0.5)) * (double)strength + targetMotion.m_7094_());
        targetEntity.f_19864_ = true;
    }

    public static void pullEntityIn(@Nonnull Entity centralEntity, @Nonnull Entity targetEntity, float strength, boolean normalised) {
        Vec3 targetMotion = targetEntity.m_20184_();
        Vec3 velocity = new Vec3(centralEntity.m_20185_() - targetEntity.m_20185_() + targetMotion.m_7096_(), centralEntity.m_20186_() - targetEntity.m_20186_() + targetMotion.m_7098_(), centralEntity.m_20189_() - targetEntity.m_20189_() + targetMotion.m_7094_());
        if (normalised) {
            velocity = velocity.m_82541_();
        }
        velocity = velocity.m_82490_((double)strength);
        targetEntity.m_20256_(velocity);
        targetEntity.f_19864_ = true;
    }

    public static void applyPotions(Collection<? extends Entity> entities, EffectBuilder ... effects) {
        for (Entity entity : entities) {
            EntityUtil.applyPotions(entity, effects);
        }
    }

    public static void applyPotions(Entity entity, EffectBuilder ... effects) {
        if (!(entity instanceof LivingEntity) || !entity.m_6084_() || entity.m_5833_() || entity instanceof FakePlayer) {
            return;
        }
        boolean onlyBeneficial = entity instanceof Player && ((Player)entity).m_7500_();
        for (EffectBuilder builder : effects) {
            if (onlyBeneficial && !builder.getEffect().m_19486_()) continue;
            ((LivingEntity)entity).m_7292_(builder.build());
        }
    }

    public static void removePotions(LivingEntity entity, MobEffect ... effects) {
        for (MobEffect effect : effects) {
            if (!entity.m_21023_(effect)) continue;
            entity.m_21195_(effect);
        }
    }

    public static boolean isPlayerLookingAtEntity(Player pl, Entity target) {
        return EntityUtil.isPlayerLookingAt(pl, target.m_20185_(), target.m_20191_().f_82289_ + (double)target.m_20206_() / 2.0, target.m_20189_()) && pl.m_142582_(target);
    }

    public static boolean isPlayerLookingAt(Player pl, double posX, double posY, double posZ) {
        Vec3 playerLookVec = pl.m_20154_().m_82541_();
        Vec3 requiredLookVec = new Vec3(posX - pl.m_20185_(), posY - (pl.m_20186_() + (double)pl.m_20192_()), posZ - pl.m_20189_());
        double requiredLookVecLength = requiredLookVec.m_82553_();
        double vecDotProduct = playerLookVec.m_82526_(requiredLookVec = requiredLookVec.m_82541_());
        return vecDotProduct > 1.0 - 0.025 / requiredLookVecLength;
    }

    public static boolean isNaturalSpawnReason(MobSpawnType reason) {
        return reason == MobSpawnType.CHUNK_GENERATION || reason == MobSpawnType.NATURAL;
    }

    @javax.annotation.Nullable
    public static Vec3 preciseEntityInterceptCalculation(Entity impactedEntity, Entity impactingEntity, int granularity) {
        Vec3 vecVelocity = impactingEntity.m_20184_();
        double velocityX = vecVelocity.m_7096_();
        double velocityY = vecVelocity.m_7098_();
        double velocityZ = vecVelocity.m_7094_();
        for (int i = 0; i < granularity; ++i) {
            double projectionX = velocityX * (double)(1.0f / (float)granularity) * (double)i;
            double projectionY = velocityY * (double)(1.0f / (float)granularity) * (double)i;
            double projectionZ = velocityZ * (double)(1.0f / (float)granularity) * (double)i;
            Vec3 initialVec = new Vec3(impactingEntity.m_20185_(), impactingEntity.m_20186_(), impactingEntity.m_20189_());
            Vec3 projectedVec = initialVec.m_82520_(projectionX, projectionY, projectionZ);
            List entityList = impactingEntity.f_19853_.m_45933_(impactingEntity, impactingEntity.m_20191_().m_82377_(projectionX, projectionY, projectionZ));
            for (Entity entity : entityList) {
                Optional intercept;
                if (entity != impactedEntity || !(intercept = entity.m_20191_().m_82371_(initialVec, projectedVec)).isPresent()) continue;
                return (Vec3)intercept.get();
            }
        }
        return null;
    }

    public static boolean canPvp(Player attacker, Player target) {
        return attacker.f_19853_.m_7654_().m_129799_() && attacker != target && !attacker.m_7307_((Entity)target);
    }

    public static Direction getDirectionFacing(Entity entity, boolean lateralOnly) {
        if (!lateralOnly) {
            if (entity.m_146909_() < -50.0f) {
                return Direction.DOWN;
            }
            if (entity.m_146909_() > 50.0f) {
                return Direction.UP;
            }
        }
        int vec = Mth.m_14107_((double)((double)(entity.m_146908_() * 4.0f / 360.0f) + 0.5)) & 3;
        return switch (++vec % 4) {
            case 0 -> Direction.EAST;
            case 1 -> Direction.SOUTH;
            case 2 -> Direction.WEST;
            default -> Direction.NORTH;
        };
    }

    public static double getEntityJumpVelocity(LivingEntity entity) {
        float jumpVelocity = entity.m_6118_();
        if (entity.m_21023_(MobEffects.f_19603_)) {
            jumpVelocity += 0.1f * (float)entity.m_21124_(MobEffects.f_19603_).m_19564_() + 1.0f;
        }
        return jumpVelocity;
    }

    @Nonnull
    public static Set<Entity> getAttackersForMob(LivingEntity entity, @javax.annotation.Nullable Predicate<Entity> filter) {
        CombatTracker tracker = entity.m_21231_();
        if (tracker.f_19276_.isEmpty()) {
            Entity attacker;
            if (entity.m_21225_() != null && (attacker = entity.m_21225_().m_7639_()) != null && (filter == null || filter.test(attacker))) {
                return Set.of(entity.m_21225_().m_7639_());
            }
            return Collections.emptySet();
        }
        HashSet<Entity> killers = new HashSet<Entity>(tracker.f_19276_.size());
        for (CombatEntry entry : tracker.f_19276_) {
            if (!entry.m_19265_() || filter != null && !filter.test(entry.m_19263_().m_7639_())) continue;
            killers.add(entry.m_19263_().m_7639_());
        }
        return killers;
    }

    public static Vec3 getDirectionForFacing(Entity entity) {
        return new Vec3((double)(-Mth.m_14031_((float)(entity.m_146908_() * (float)Math.PI / 180.0f))), (double)(-Mth.m_14031_((float)(entity.m_146909_() * (float)Math.PI / 180.0f))), (double)Mth.m_14089_((float)(entity.m_146908_() * (float)Math.PI / 180.0f)));
    }

    public static Vec3 getVelocityVectorForFacing(Entity entity) {
        return EntityUtil.getVelocityVectorForFacing(entity, 1.0f);
    }

    public static Vec3 getVelocityVectorForFacing(Entity entity, float velocityMod) {
        return new Vec3((double)(-Mth.m_14031_((float)(entity.m_146908_() * (float)Math.PI / 180.0f)) * Mth.m_14089_((float)(entity.m_146909_() * (float)Math.PI / 180.0f)) * velocityMod), (double)(-Mth.m_14031_((float)(entity.m_146909_() * (float)Math.PI / 180.0f)) * velocityMod), (double)(Mth.m_14089_((float)(entity.m_146908_() * (float)Math.PI / 180.0f)) * Mth.m_14089_((float)(entity.m_146909_() * (float)Math.PI / 180.0f)) * velocityMod));
    }

    public static boolean isEntityMoving(Entity entity) {
        Vec3 velocity = entity.m_20184_();
        return velocity.m_7096_() != 0.0 || velocity.m_7094_() != 0.0 || velocity.m_7098_() > -0.07 || velocity.m_7098_() < -0.08;
    }

    public static Vec3 getEntityCenter(Entity entity) {
        return new Vec3(entity.m_20165_(0.5), entity.m_20227_(0.5), entity.m_20246_(0.5));
    }

    @javax.annotation.Nullable
    public static <T extends Entity> EntityHitResult getEntityCollisionWithPrecision(Level level, Entity projectile, Vec3 startVec, Vec3 endVec, AABB bounds, Predicate<T> filter, float tolerance) {
        double closestDist = Double.MAX_VALUE;
        Entity impactEntity = null;
        Vec3 position = null;
        for (Entity target : EntityRetrievalUtil.getEntities((Level)level, (AABB)bounds, entity -> entity != projectile && filter.test(entity))) {
            Vec3 pos;
            double dist;
            AABB targetBounds = target.m_20191_().m_82400_((double)tolerance);
            Optional boundsClip = targetBounds.m_82371_(startVec, endVec);
            if (boundsClip.isPresent() && (dist = startVec.m_82557_(pos = (Vec3)boundsClip.get())) < closestDist) {
                impactEntity = target;
                closestDist = dist;
                position = pos;
            }
            if (!target.isMultipartEntity()) continue;
            for (PartEntity part : target.getParts()) {
                Vec3 pos2;
                double dist2;
                targetBounds = part.m_20191_().m_82400_((double)tolerance);
                boundsClip = targetBounds.m_82371_(startVec, endVec);
                if (!boundsClip.isPresent() || !((dist2 = startVec.m_82557_(pos2 = (Vec3)boundsClip.get())) < closestDist)) continue;
                impactEntity = target;
                closestDist = dist2;
                position = pos2;
            }
        }
        return impactEntity == null ? null : new EntityHitResult(impactEntity, position);
    }

    @Nullable
    public static LivingEntity getLivingEntityFromSelfOrPart(Entity entity) {
        LivingEntity livingEntity;
        PartEntity part;
        Entity entity2;
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity2 = (LivingEntity)entity;
            return livingEntity2;
        }
        return entity instanceof PartEntity && (entity2 = (part = (PartEntity)entity).getParent()) instanceof LivingEntity ? (livingEntity = (LivingEntity)entity2) : null;
    }

    public static class Predicates {
        public static final Predicate<LivingEntity> HOSTILE_MOB = entity -> entity instanceof Enemy;
        public static final Predicate<Entity> SURVIVAL_PLAYER = entity -> entity instanceof Player && !((Player)entity).m_7500_() && !entity.m_5833_();
        public static final Predicate<Entity> ATTACKABLE_ENTITY = entity -> entity.m_6084_() && SURVIVAL_PLAYER.test((Entity)entity);
    }
}

