/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.util;

import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.boss.enderdragon.EndCrystal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.entity.PartEntity;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.tslat.aoa3.common.registration.AoATags;
import net.tslat.aoa3.common.registration.entity.AoADamageTypes;
import net.tslat.aoa3.content.item.armour.AdventArmour;
import net.tslat.aoa3.util.NumberUtil;
import net.tslat.aoa3.util.PlayerUtil;

public final class DamageUtil {
    public static DamageSource miscDamage(ResourceKey<DamageType> damageType, Level level) {
        return new DamageSource((Holder)level.m_269111_().f_268645_.m_246971_(damageType));
    }

    public static DamageSource miscPositionedDamage(ResourceKey<DamageType> damageType, Level level, Vec3 position) {
        return new DamageSource((Holder)level.m_269111_().f_268645_.m_246971_(damageType), position);
    }

    public static DamageSource entityDamage(ResourceKey<DamageType> damageType, Entity attacker) {
        return new DamageSource((Holder)attacker.f_19853_.m_269111_().f_268645_.m_246971_(damageType), attacker);
    }

    public static DamageSource positionedEntityDamage(ResourceKey<DamageType> damageType, Entity attacker, Vec3 position) {
        return new DamageSource((Holder)attacker.f_19853_.m_269111_().f_268645_.m_246971_(damageType), attacker, null, position);
    }

    public static DamageSource indirectEntityDamage(ResourceKey<DamageType> damageType, Entity attacker, Entity projectile) {
        return new DamageSource((Holder)projectile.f_19853_.m_269111_().f_268645_.m_246971_(damageType), projectile, attacker);
    }

    public static boolean doMobMeleeAttack(Entity attacker, Entity target, float dmg) {
        return DamageUtil.safelyDealDamage(DamageUtil.entityDamage(AoADamageTypes.MOB_MELEE_ATTACK, attacker), target, dmg);
    }

    public static boolean doProjectileAttack(@Nullable Entity attacker, @Nullable Entity projectile, Entity target, float dmg) {
        return DamageUtil.safelyDealDamage(DamageUtil.indirectEntityDamage(AoADamageTypes.RANGED_ATTACK, attacker, projectile), target, dmg);
    }

    public static boolean doVulcaneAttack(@Nullable Entity attacker, Entity target, float dmg) {
        return DamageUtil.safelyDealDamage(DamageUtil.positionedEntityDamage(AoADamageTypes.VULCANE, attacker, target.m_20182_()), target, dmg);
    }

    public static boolean doGunAttack(@Nullable Entity attacker, @Nullable Entity projectile, Entity target, float dmg) {
        return DamageUtil.safelyDealDamage(DamageUtil.indirectEntityDamage(AoADamageTypes.GUN, attacker, projectile), target, dmg);
    }

    public static boolean doHeavyGunAttack(@Nullable Entity attacker, @Nullable Entity projectile, Entity target, float dmg) {
        return DamageUtil.safelyDealDamage(DamageUtil.indirectEntityDamage(AoADamageTypes.HEAVY_GUN, attacker, projectile), target, dmg);
    }

    public static boolean doEnergyProjectileAttack(@Nullable Entity attacker, @Nullable Entity projectile, Entity target, float dmg) {
        return DamageUtil.safelyDealDamage(DamageUtil.indirectEntityDamage(AoADamageTypes.ENERGY_PROJECTILE, attacker, projectile), target, dmg);
    }

    public static boolean doMagicProjectileAttack(@Nullable Entity attacker, @Nullable Entity projectile, Entity target, float dmg) {
        return DamageUtil.safelyDealDamage(DamageUtil.indirectEntityDamage(AoADamageTypes.MAGIC_PROJECTILE, attacker, projectile), target, dmg);
    }

    public static boolean doRecoilAttack(Entity target, float dmg) {
        return DamageUtil.safelyDealDamage(DamageUtil.miscDamage(AoADamageTypes.RECOIL, target.f_19853_), target, dmg);
    }

    public static boolean doMiscMagicAttack(Entity attacker, Entity target, float dmg, @Nullable Vec3 position) {
        return DamageUtil.safelyDealDamage(position == null ? DamageUtil.entityDamage(AoADamageTypes.MAGIC_ATTACK, attacker) : DamageUtil.positionedEntityDamage(AoADamageTypes.MAGIC_ATTACK, attacker, position), target, dmg);
    }

    public static boolean doMiscEnergyAttack(Entity attacker, Entity target, float dmg, @Nullable Vec3 position) {
        return DamageUtil.safelyDealDamage(position == null ? DamageUtil.entityDamage(AoADamageTypes.ENERGY_ATTACK, attacker) : DamageUtil.positionedEntityDamage(AoADamageTypes.ENERGY_ATTACK, attacker, position), target, dmg);
    }

    public static void doScaledKnockback(LivingEntity target, LivingEntity attacker, float strength, double xRatio, double yRatio, double zRatio) {
        if (target instanceof Player && !PlayerUtil.shouldPlayerBeAffected((Player)target)) {
            return;
        }
        LivingKnockBackEvent event = ForgeHooks.onLivingKnockBack((LivingEntity)target, (float)strength, (double)xRatio, (double)zRatio);
        if (event.isCanceled()) {
            return;
        }
        strength = event.getStrength();
        AttributeInstance knockbackResist = target.m_21051_(Attributes.f_22278_);
        AttributeInstance knockbackStrength = attacker.m_21051_(Attributes.f_22282_);
        if (knockbackStrength != null) {
            strength = (float)((double)strength * Math.max(0.0, 1.0 + knockbackStrength.m_22135_()));
        }
        if (knockbackResist != null) {
            strength = (float)((double)strength * Math.max(0.0, 1.0 - knockbackResist.m_22135_()));
        }
        Vec3 vec = target.m_20182_().m_82546_(attacker.m_20182_());
        if (vec.f_82480_ == 0.0 && (yRatio != xRatio || yRatio != zRatio)) {
            vec = vec.m_82520_(0.0, 1.0, 0.0);
        }
        vec = vec.m_82541_().m_82542_(event.getRatioX(), yRatio, event.getRatioZ()).m_82549_(attacker.m_20184_().m_82490_(0.5)).m_82542_((double)strength, (double)strength, (double)strength);
        if (target.m_20096_() && attacker.m_20186_() == target.m_20186_()) {
            vec = vec.m_82520_(0.0, 0.25, 0.0);
        }
        target.m_20256_(vec);
        target.f_19812_ = true;
        target.f_19864_ = true;
    }

    public static void doBodySlamKnockback(LivingEntity target, Entity attacker, float xModifier, float yModifier, float zModifier) {
        double zVelocity;
        double yVelocity;
        if (target instanceof Player && !PlayerUtil.shouldPlayerBeAffected((Player)target)) {
            return;
        }
        Vec3 attackerVelocity = attacker.m_20184_().m_82542_((double)xModifier, (double)yModifier, (double)zModifier);
        double xVelocity = attackerVelocity.m_7096_() * (double)xModifier;
        LivingKnockBackEvent event = ForgeHooks.onLivingKnockBack((LivingEntity)target, (float)((float)NumberUtil.average(xVelocity, yVelocity = attackerVelocity.m_7098_() * (double)yModifier, zVelocity = attackerVelocity.m_7094_() * (double)zModifier)), (double)xVelocity, (double)zVelocity);
        if (event.isCanceled()) {
            return;
        }
        double resist = 1.0;
        AttributeInstance attrib = target.m_21051_(Attributes.f_22278_);
        if (attrib != null) {
            resist -= attrib.m_22135_();
        }
        target.m_5997_(event.getRatioX() * resist, yVelocity * resist, event.getRatioZ() * resist);
        target.f_19864_ = true;
    }

    public static void killEntityCleanly(Entity entity) {
        if (!(entity instanceof LivingEntity)) {
            entity.m_6469_(entity.f_19853_.m_269111_().m_269341_(), Float.MAX_VALUE);
            entity.m_146870_();
            return;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        DamageUtil.safelyDealDamage(livingEntity.f_19853_.m_269111_().m_269341_(), (Entity)livingEntity, livingEntity.m_21223_());
        if (livingEntity.m_21223_() > 0.0f) {
            livingEntity.m_21153_(0.0f);
        }
    }

    public static boolean safelyDealDamage(DamageSource damageSource, Entity target, float dmg) {
        return DamageUtil.safelyDealDamage(damageSource, target, dmg, true);
    }

    public static boolean safelyDealDamage(DamageSource damageSource, Entity target, float dmg, boolean ignoreMiscEntities) {
        if (!(ignoreMiscEntities || target instanceof LivingEntity || target instanceof PartEntity || target instanceof EndCrystal)) {
            return false;
        }
        if (target.m_6469_(damageSource, dmg)) {
            Entity entity = damageSource.m_7639_();
            if (entity instanceof LivingEntity) {
                LivingEntity attacker = (LivingEntity)entity;
                attacker.m_21335_(target);
            }
            return true;
        }
        return false;
    }

    public static boolean isMeleeDamage(DamageSource source) {
        return source.m_7639_() != null && source.m_7640_() == source.m_7639_() && DamageUtil.isPhysicalDamage(source);
    }

    public static boolean isEnergyDamage(DamageSource source) {
        return source.m_269533_(AoATags.DamageTypes.ENERGY);
    }

    public static boolean isMagicDamage(DamageSource source, Entity target, float dmg) {
        return source.m_269533_(AoATags.DamageTypes.MAGIC) && !DamageUtil.isPoisonDamage(source, target, dmg);
    }

    public static boolean isRangedDamage(DamageSource source, Entity target, float dmg) {
        return source.m_269533_(DamageTypeTags.f_268524_) && !DamageUtil.isMagicDamage(source, target, dmg) && !DamageUtil.isEnergyDamage(source) && !source.m_269533_(AoATags.DamageTypes.GUN);
    }

    public static boolean isGunDamage(DamageSource source) {
        return source.m_269533_(AoATags.DamageTypes.GUN);
    }

    public static boolean isPoisonDamage(DamageSource source, Entity target, float dmg) {
        LivingEntity livingEntity;
        return source.m_276093_(DamageTypes.f_268515_) && source.m_7639_() == null && target instanceof LivingEntity && (livingEntity = (LivingEntity)target).m_21023_(MobEffects.f_19614_) && dmg == 1.0f;
    }

    public static boolean isPhysicalDamage(DamageSource source) {
        return !source.m_269533_(DamageTypeTags.f_268490_) && !source.m_269533_(DamageTypeTags.f_268415_) && !source.m_276093_(DamageTypes.f_268440_) && !DamageUtil.isEnvironmentalDamage(source);
    }

    public static boolean isVulcaneDamage(DamageSource source) {
        return source.m_276093_(AoADamageTypes.VULCANE);
    }

    public static boolean isEnvironmentalDamage(DamageSource source) {
        if (source.m_7639_() != null || source.m_269533_(DamageTypeTags.f_268415_)) {
            return false;
        }
        return source.m_269533_(AoATags.DamageTypes.ENVIRONMENTAL);
    }

    public static boolean isPlayerEnvironmentallyProtected(ServerPlayer player) {
        Item helmet = ((ItemStack)player.m_150109_().f_35975_.get(EquipmentSlot.HEAD.m_20749_())).m_41720_();
        return helmet instanceof AdventArmour && ((AdventArmour)helmet).isHelmetAirTight(player);
    }
}

