/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.util;

import net.minecraft.network.FriendlyByteBuf;

public final class ColourUtil {
    public static final int WHITE = ColourUtil.RGB(255, 255, 255);
    public static final int BLACK = ColourUtil.RGB(0, 0, 0);
    public static final int RED = ColourUtil.RGB(255, 0, 0);
    public static final int GREEN = ColourUtil.RGB(0, 255, 0);
    public static final int BLUE = ColourUtil.RGB(0, 0, 255);
    public static final int YELLOW = ColourUtil.RGB(255, 255, 0);
    public static final int CYAN = ColourUtil.RGB(0, 255, 255);

    public static int RGB(int red, int green, int blue) {
        return red << 16 | green << 8 | blue;
    }

    public static int RGBA(int red, int green, int blue, int alpha) {
        return ColourUtil.addAlpha(ColourUtil.RGB(red, green, blue), alpha);
    }

    public static int RGB(float red, float green, float blue) {
        return (int)(red * 255.0f) << 16 | (int)(green * 255.0f) << 8 | (int)(blue * 255.0f);
    }

    public static int RGBA(float red, float green, float blue, float alpha) {
        return ColourUtil.addAlpha(ColourUtil.RGB(red, green, blue), (int)(alpha * 255.0f));
    }

    public static int RGB(double red, double green, double blue) {
        return (int)(red * 255.0) << 16 | (int)(green * 255.0) << 8 | (int)(blue * 255.0);
    }

    public static int RGBA(double red, double green, double blue, double alpha) {
        return ColourUtil.addAlpha(ColourUtil.RGB(red, green, blue), (int)(alpha * 255.0));
    }

    public static int addAlpha(int colour, int alpha) {
        return alpha << 24 | colour;
    }

    public record Colour(float red, float green, float blue, float alpha) {
        public Colour(int red, int green, int blue) {
            this((float)red / 255.0f, (float)green / 255.0f, (float)blue / 255.0f, 1.0f);
        }

        public Colour(int rgb) {
            this((float)(rgb >> 16 & 0xFF) / 255.0f, (float)(rgb >> 8 & 0xFF) / 255.0f, (float)(rgb & 0xFF) / 255.0f, (float)(rgb >> 24 & 0xFF) / 255.0f);
        }

        public String hex() {
            return Integer.toHexString((int)(this.red * 255.0f)) + Integer.toHexString((int)(this.green * 255.0f)) + Integer.toHexString((int)(this.blue * 255.0f));
        }

        public int packed() {
            return ColourUtil.RGBA(this.red, this.green, this.blue, this.alpha);
        }

        public void toNetwork(FriendlyByteBuf buffer) {
            buffer.writeFloat(this.red);
            buffer.writeFloat(this.green);
            buffer.writeFloat(this.blue);
            buffer.writeFloat(this.alpha);
        }

        public static Colour fromNetwork(FriendlyByteBuf buffer) {
            return new Colour(buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat());
        }
    }
}

