/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.util;

import com.mojang.serialization.DynamicOps;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.tags.TagKey;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.SpawnData;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public final class BlockUtil {
    public static final float UNBREAKABLE_HARDNESS = -1.0f;
    public static final float UNBREAKABLE_RESISTANCE = 1.0E9f;

    public static Vec3 posToVec(BlockPos pos) {
        return new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
    }

    public static boolean isBlockTaggedAs(Block block, TagKey<Block> ... tags) {
        for (TagKey<Block> tag : tags) {
            if (!block.m_204297_().m_203656_(tag)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAirBlock(BlockState state) {
        return state.m_60767_() == Material.f_76296_ || state.m_60767_() == Material.f_76297_;
    }

    public static VoxelShape pixelBasedCube(int minPixelX, int minPixelY, int minPixelZ, int maxPixelX, int maxPixelY, int maxPixelZ) {
        return Shapes.m_83064_((AABB)new AABB((double)minPixelX / 16.0, (double)minPixelY / 16.0, (double)minPixelZ / 16.0, (double)maxPixelX / 16.0, (double)maxPixelY / 16.0, (double)maxPixelZ / 16.0));
    }

    public static boolean canPlayerHarvest(BlockState state, Player player, LevelAccessor world, BlockPos pos) {
        if (!state.m_60834_()) {
            return true;
        }
        return player.m_21205_().m_41735_(state);
    }

    public static class SpawnerBuilder {
        private short initialSpawnDelay = (short)20;
        private short minSpawnDelay = (short)200;
        private short maxSpawnDelay = (short)800;
        private short spawnsPerGroup = (short)4;
        private short maxNearbyEntities = (short)6;
        private short requiredPlayerRange = (short)16;
        private short spawnRange = (short)4;
        private SpawnData nextSpawn = null;
        private final SimpleWeightedRandomList.Builder<SpawnData> mobs = SimpleWeightedRandomList.m_146263_();

        public SpawnerBuilder initialSpawnDelay(int ticks) {
            this.initialSpawnDelay = (short)ticks;
            return this;
        }

        public SpawnerBuilder minSpawnDelay(int ticks) {
            this.minSpawnDelay = (short)ticks;
            return this;
        }

        public SpawnerBuilder maxSpawnDelay(int ticks) {
            this.maxSpawnDelay = (short)ticks;
            return this;
        }

        public SpawnerBuilder spawnsPerGroup(int amount) {
            this.spawnsPerGroup = (short)amount;
            return this;
        }

        public SpawnerBuilder maxNearbyEntities(int amount) {
            this.maxNearbyEntities = (short)amount;
            return this;
        }

        public SpawnerBuilder whenPlayerWithin(int distance) {
            this.requiredPlayerRange = (short)distance;
            return this;
        }

        public SpawnerBuilder spawnWithinXBlocks(int distance) {
            this.spawnRange = (short)distance;
            return this;
        }

        public SpawnerBuilder withSpawns(EntityType<?> ... entities) {
            for (EntityType<?> entity : entities) {
                this.withSpawn(1, entity);
            }
            return this;
        }

        public SpawnerBuilder withSpawns(RegistryObject<EntityType<?>> ... entities) {
            for (RegistryObject<EntityType<?>> registryEntry : entities) {
                this.withSpawn(1, (EntityType)registryEntry.get());
            }
            return this;
        }

        public SpawnerBuilder withSpawn(int weight, EntityType<?> entity) {
            return this.withSpawn(weight, entity, null);
        }

        public SpawnerBuilder withSpawn(int weight, EntityType<?> entity, SpawnData.CustomSpawnRules spawnRules) {
            CompoundTag tag = new CompoundTag();
            tag.m_128359_("id", ForgeRegistries.ENTITY_TYPES.getKey(entity).toString());
            return this.withSpawn(weight, tag, spawnRules);
        }

        public SpawnerBuilder withSpawn(int weight, CompoundTag nbt, @Nullable SpawnData.CustomSpawnRules spawnRules) {
            if (this.nextSpawn == null) {
                this.nextSpawn = new SpawnData(nbt, spawnRules == null ? Optional.empty() : Optional.of(spawnRules));
                return this;
            }
            this.mobs.m_146271_((Object)new SpawnData(nbt, spawnRules == null ? Optional.empty() : Optional.of(spawnRules)), weight);
            return this;
        }

        public CompoundTag build() {
            CompoundTag nbt = new CompoundTag();
            if (this.nextSpawn == null) {
                throw new IllegalStateException("Attempted to create spawner data with no mobs listed.");
            }
            nbt.m_128376_("Delay", this.initialSpawnDelay);
            nbt.m_128376_("MinSpawnDelay", this.minSpawnDelay);
            nbt.m_128376_("MaxSpawnDelay", this.maxSpawnDelay);
            nbt.m_128376_("SpawnCount", this.spawnsPerGroup);
            nbt.m_128376_("MaxNearbyEntities", this.maxNearbyEntities);
            nbt.m_128376_("RequiredPlayerRange", this.requiredPlayerRange);
            nbt.m_128376_("SpawnRange", this.spawnRange);
            nbt.m_128365_("SpawnData", (Tag)SpawnData.f_186559_.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this.nextSpawn).result().orElseThrow(() -> new IllegalStateException("Invalid SpawnData")));
            nbt.m_128365_("SpawnPotentials", (Tag)SpawnData.f_186560_.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this.mobs.m_146270_()).result().orElseThrow());
            return nbt;
        }
    }

    public static class CompactProperties {
        private final BlockBehaviour.Properties properties;

        public CompactProperties(Material material, Function<BlockState, MaterialColor> mapColours) {
            this.properties = BlockBehaviour.Properties.m_60947_((Material)material, mapColours).m_60918_(CompactProperties.approximateSound(material));
        }

        public CompactProperties(Material material, MaterialColor mapColour) {
            this(material, (BlockState state) -> mapColour);
        }

        public CompactProperties needsTool() {
            this.properties.m_60999_();
            return this;
        }

        public CompactProperties sound(SoundType sound) {
            this.properties.m_60918_(sound);
            return this;
        }

        public CompactProperties stats(float hardness) {
            return this.stats(hardness, hardness);
        }

        public CompactProperties stats(float hardness, float resistance) {
            this.properties.m_60913_(hardness, resistance);
            return this;
        }

        public CompactProperties unbreakable() {
            this.noDrops();
            return this.stats(-1.0f, 1.0E9f);
        }

        public CompactProperties light(int light) {
            return this.light(state -> light);
        }

        public CompactProperties light(ToIntFunction<BlockState> light) {
            this.properties.m_60953_(light);
            return this;
        }

        public CompactProperties randomTicks() {
            this.properties.m_60977_();
            return this;
        }

        public CompactProperties isAir() {
            this.properties.m_60996_();
            return this;
        }

        public CompactProperties dynamicShape() {
            this.properties.m_60988_();
            return this;
        }

        public CompactProperties slippery(float slipMod) {
            this.properties.m_60911_(slipMod);
            return this;
        }

        public CompactProperties emissive() {
            return this.emissive((state, world, pos) -> true);
        }

        public CompactProperties emissive(BlockBehaviour.StatePredicate when) {
            this.properties.m_60991_(when);
            return this;
        }

        public CompactProperties renderAdjust() {
            return this.renderAdjust((state, world, pos) -> true);
        }

        public CompactProperties renderAdjust(BlockBehaviour.StatePredicate when) {
            this.properties.m_60982_(when);
            return this;
        }

        public CompactProperties moveSpeed(float speedMod) {
            this.properties.m_60956_(speedMod);
            return this;
        }

        public CompactProperties bouncy(float jumpFactor) {
            this.properties.m_60967_(jumpFactor);
            return this;
        }

        public CompactProperties noDrops() {
            this.properties.m_222994_();
            return this;
        }

        public CompactProperties noOcclusion() {
            this.properties.m_60955_();
            return this;
        }

        public CompactProperties noClip() {
            this.properties.m_60910_();
            this.coversScreen((state, world, pos) -> false);
            return this;
        }

        public CompactProperties noScreenCover() {
            return this.coversScreen((state, world, pos) -> false);
        }

        public CompactProperties coversScreen(BlockBehaviour.StatePredicate when) {
            this.properties.m_60971_(when);
            return this;
        }

        public CompactProperties noRedstone() {
            return this.conductRedstone((state, world, pos) -> false);
        }

        public CompactProperties conductRedstone(BlockBehaviour.StatePredicate when) {
            this.properties.m_60924_(when);
            return this;
        }

        public CompactProperties noSpawns() {
            return this.specialSpawns((state, world, pos, entityType) -> false);
        }

        public CompactProperties specialSpawns(BlockBehaviour.StateArgumentPredicate<EntityType<?>> when) {
            this.properties.m_60922_(when);
            return this;
        }

        public CompactProperties breathable() {
            return this.suffocate((state, world, pos) -> false);
        }

        public CompactProperties suffocate(BlockBehaviour.StatePredicate when) {
            this.properties.m_60960_(when);
            return this;
        }

        public BlockBehaviour.Properties get() {
            return this.properties;
        }

        private static SoundType approximateSound(Material material) {
            if (material == Material.f_76320_) {
                return SoundType.f_56736_;
            }
            if (material == Material.f_76275_) {
                return SoundType.f_56744_;
            }
            if (material == Material.f_76314_) {
                return SoundType.f_56739_;
            }
            if (material == Material.f_76300_ || material == Material.f_76315_) {
                return SoundType.f_56740_;
            }
            if (material == Material.f_76308_ || material == Material.f_76280_) {
                return SoundType.f_56747_;
            }
            if (material == Material.f_76317_) {
                return SoundType.f_56746_;
            }
            if (material == Material.f_76272_) {
                return SoundType.f_56745_;
            }
            if (material == Material.f_76279_ || material == Material.f_76281_) {
                return SoundType.f_56743_;
            }
            return SoundType.f_56742_;
        }
    }
}

