/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.player.skill;

import com.google.gson.JsonObject;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.player.ItemFishedEvent;
import net.tslat.aoa3.common.registration.AoATags;
import net.tslat.aoa3.common.registration.custom.AoASkills;
import net.tslat.aoa3.player.AoAPlayerEventListener;
import net.tslat.aoa3.player.ServerPlayerDataManager;
import net.tslat.aoa3.player.skill.AoASkill;
import net.tslat.aoa3.util.PlayerUtil;
import net.tslat.smartbrainlib.util.RandomUtil;

public class HaulingSkill
extends AoASkill.Instance {
    private static final AoAPlayerEventListener.ListenerType[] LISTENERS = new AoAPlayerEventListener.ListenerType[]{AoAPlayerEventListener.ListenerType.FISHED_ITEM, AoAPlayerEventListener.ListenerType.CUSTOM};

    public HaulingSkill(ServerPlayerDataManager plData, JsonObject jsonData) {
        super((AoASkill)AoASkills.HAULING.get(), plData, jsonData);
    }

    public HaulingSkill(CompoundTag nbtData) {
        super((AoASkill)AoASkills.HAULING.get(), nbtData);
    }

    @Override
    public AoAPlayerEventListener.ListenerType[] getListenerTypes() {
        return LISTENERS;
    }

    @Override
    public void handleItemFished(ItemFishedEvent ev, boolean isHauling) {
        if (!this.canGainXp(true)) {
            return;
        }
        float xp = PlayerUtil.getTimeBasedXpForLevel(this.getLevel(true), 200.0f) * (float)(1.0 + RandomUtil.randomScaledGaussianValue((double)0.25));
        if (isHauling) {
            xp *= 2.0f;
            for (ItemStack stack : ev.getDrops()) {
                if (!stack.m_204117_(AoATags.Items.HAULING_FISH)) continue;
                xp *= 1.25f;
            }
        }
        this.adjustXp(xp, false, false);
    }

    @Override
    public void handleCustomInteraction(String interactionType, Object data) {
        if (interactionType.equals("fishing_cage_harvest")) {
            if (!this.canGainXp(true)) {
                return;
            }
            List loot = (List)data;
            float xp = PlayerUtil.getTimeBasedXpForLevel(this.getLevel(true), 1000.0f) * (float)Math.min(4, loot.size());
            this.adjustXp(xp, false, false);
        }
    }
}

