/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.player.skill;

import com.google.gson.JsonObject;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import net.tslat.aoa3.common.registration.custom.AoASkills;
import net.tslat.aoa3.player.AoAPlayerEventListener;
import net.tslat.aoa3.player.ServerPlayerDataManager;
import net.tslat.aoa3.player.skill.AoASkill;
import net.tslat.aoa3.util.PlayerUtil;

public class DexteritySkill
extends AoASkill.Instance {
    private static final AoAPlayerEventListener.ListenerType[] LISTENERS = new AoAPlayerEventListener.ListenerType[]{AoAPlayerEventListener.ListenerType.PLAYER_TICK, AoAPlayerEventListener.ListenerType.PLAYER_JUMP, AoAPlayerEventListener.ListenerType.CRITICAL_HIT};
    private double lastX = 0.0;
    private double lastZ = 0.0;
    private double cumulativeDistance = 0.0;
    private float cumulativeXp = 0.0f;

    public DexteritySkill(ServerPlayerDataManager plData, JsonObject jsonData) {
        super((AoASkill)AoASkills.DEXTERITY.get(), plData, jsonData);
    }

    public DexteritySkill(CompoundTag nbtData) {
        super((AoASkill)AoASkills.DEXTERITY.get(), nbtData);
    }

    @Override
    public AoAPlayerEventListener.ListenerType[] getListenerTypes() {
        return LISTENERS;
    }

    @Override
    public void handlePlayerTick(TickEvent.PlayerTickEvent ev) {
        if (!this.canGainXp(true) || ev.player.m_20159_()) {
            return;
        }
        Vec3 pos = ev.player.m_20182_();
        if (ev.player.m_20142_()) {
            if (ev.player.m_20096_() || ev.player.m_6069_()) {
                double distZ;
                double distX;
                double dist;
                if (this.lastX != 0.0 && this.lastZ != 0.0 && (dist = Math.sqrt((distX = pos.m_7096_() - this.lastX) * distX + (distZ = pos.m_7094_() - this.lastZ) * distZ)) < 1.0) {
                    this.cumulativeDistance += dist;
                }
                this.lastX = pos.m_7096_();
                this.lastZ = pos.m_7094_();
            }
        } else {
            this.lastX = 0.0;
            this.lastZ = 0.0;
        }
        if (ev.player.f_19797_ % 200 == 0) {
            if (this.cumulativeDistance > 0.0) {
                this.cumulativeXp += PlayerUtil.getTimeBasedXpForLevel(this.getLevel(true), 100.0f) * Math.min(1.75f, (float)(this.cumulativeDistance / 56.0));
                this.cumulativeDistance = 0.0;
            }
            if (this.cumulativeXp > 0.0f) {
                this.adjustXp(this.cumulativeXp, false, false);
                this.cumulativeXp = 0.0f;
            }
        }
    }

    @Override
    public void handlePlayerJump(LivingEvent.LivingJumpEvent ev) {
        if (!this.canGainXp(true)) {
            return;
        }
        float xp = PlayerUtil.getTimeBasedXpForLevel(this.getLevel(true), 5.0f);
        if (ev.getEntity().m_20142_()) {
            xp *= 1.3f;
        }
        this.cumulativeXp += xp;
    }

    @Override
    public void handleCriticalHit(CriticalHitEvent ev) {
        if (!this.canGainXp(true)) {
            return;
        }
        this.cumulativeXp += ev.getDamageModifier() * PlayerUtil.getTimeBasedXpForLevel(this.getLevel(true), 12.0f);
    }
}

