/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.player.skill;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.util.Lazy;
import net.tslat.aoa3.common.packet.AoAPackets;
import net.tslat.aoa3.common.packet.packets.XpGainPacket;
import net.tslat.aoa3.common.registration.AoAAdvancementTriggers;
import net.tslat.aoa3.common.registration.AoAConfigs;
import net.tslat.aoa3.common.registration.AoARegistries;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.common.registration.custom.AoAAbilities;
import net.tslat.aoa3.common.registration.worldgen.AoADimensions;
import net.tslat.aoa3.event.custom.AoAEvents;
import net.tslat.aoa3.library.builder.SoundBuilder;
import net.tslat.aoa3.player.AoAPlayerEventListener;
import net.tslat.aoa3.player.ServerPlayerDataManager;
import net.tslat.aoa3.player.ability.AoAAbility;
import net.tslat.aoa3.util.PlayerUtil;
import net.tslat.aoa3.util.WorldUtil;

public final class AoASkill {
    private final Lazy<MutableComponent> name = () -> Component.m_237115_((String)Util.m_137492_((String)"skill", (ResourceLocation)AoARegistries.AOA_SKILLS.getId(this)));
    private final BiFunction<ServerPlayerDataManager, JsonObject, Instance> jsonFactory;
    private final Function<CompoundTag, Instance> clientFactory;

    public AoASkill(BiFunction<ServerPlayerDataManager, JsonObject, Instance> jsonFactory, Function<CompoundTag, Instance> clientFactory) {
        this.jsonFactory = jsonFactory;
        this.clientFactory = clientFactory;
    }

    public MutableComponent getName() {
        return (MutableComponent)this.name.get();
    }

    public Instance buildDefaultInstance(ServerPlayerDataManager plData, JsonObject resourceData) {
        return this.jsonFactory.apply(plData, resourceData);
    }

    public Instance buildClientInstance(CompoundTag resourceData) {
        return this.clientFactory.apply(resourceData);
    }

    public static abstract class Instance
    implements AoAPlayerEventListener {
        private final AoASkill skill;
        private final HashMap<String, AoAAbility.Instance> abilities = new HashMap();
        protected ServerPlayerDataManager playerDataManager;
        protected int cycle = 0;
        protected int level = 1;
        protected float xp = 0.0f;
        protected float xpModifier = 1.0f;
        public boolean needsSync = true;

        protected Instance(AoASkill skill, ServerPlayerDataManager plData, JsonObject instanceData) {
            this.skill = skill;
            if (instanceData != null) {
                this.playerDataManager = plData;
                this.xpModifier = GsonHelper.m_13820_((JsonObject)instanceData, (String)"xp_modifier", (float)1.0f);
                if (instanceData.has("abilities")) {
                    for (JsonElement entry : instanceData.getAsJsonArray("abilities")) {
                        JsonObject abilityData = entry.getAsJsonObject();
                        AoAAbility ability = AoAAbilities.getAbility(new ResourceLocation(GsonHelper.m_13906_((JsonObject)abilityData, (String)"id")));
                        AoAAbility.Instance instance = ability.create(this, abilityData);
                        this.abilities.put(instance.getUniqueIdentifier(), instance);
                    }
                }
            }
        }

        protected Instance(AoASkill skill, CompoundTag instanceData) {
            this.skill = skill;
            this.xpModifier = instanceData.m_128457_("xp_modifier");
            if (instanceData.m_128441_("abilities")) {
                CompoundTag abilityData = instanceData.m_128469_("abilities");
                for (String key : abilityData.m_128431_()) {
                    AoAAbility ability = AoAAbilities.getAbility(new ResourceLocation(abilityData.m_128469_(key).m_128461_("id")));
                    AoAAbility.Instance instance = ability.loadFromNbt(this, (CompoundTag)abilityData.m_128423_(key));
                    this.abilities.put(instance.getUniqueIdentifier(), instance);
                }
            }
        }

        public void changePlayerInstance(ServerPlayerDataManager plData) {
            this.playerDataManager = plData;
        }

        public AoASkill type() {
            return this.skill;
        }

        public MutableComponent getName() {
            return this.type().getName();
        }

        public HashMap<String, AoAAbility.Instance> getAbilityMap() {
            return this.abilities;
        }

        public Player getPlayer() {
            return this.playerDataManager.player();
        }

        public ServerPlayerDataManager getPlayerDataManager() {
            return this.playerDataManager;
        }

        public float getXp() {
            return this.xp;
        }

        public int getLevel(boolean includeVanityLevels) {
            return includeVanityLevels ? this.level : Math.min(this.level, 100);
        }

        public int getCycles() {
            return this.cycle;
        }

        public boolean hasLevel(int levelReq) {
            return this.getLevel(true) >= levelReq;
        }

        public void setLevel(int newLevel) {
            int oldLevel = this.level;
            this.level = Mth.m_14045_((int)newLevel, (int)0, (int)1000);
            this.xp = 0.0f;
            this.needsSync = true;
            this.playerDataManager.applyLegitimacyPenalties();
            AoAEvents.playerLevelChange(this.playerDataManager, this, oldLevel, false);
        }

        public void applyXpModifier(float xpMod) {
            this.xpModifier += xpMod;
            this.needsSync = true;
        }

        public void removeXpModifier(float xpMod) {
            this.xpModifier -= xpMod;
            this.needsSync = true;
        }

        private float applyXpBuffs(float xp) {
            xp = (float)((double)xp * (Double)AoAConfigs.SERVER.globalXpModifier.get());
            if (WorldUtil.isWorld(this.getPlayer().f_19853_, AoADimensions.NOWHERE.key)) {
                xp *= 0.5f;
            }
            xp *= this.xpModifier;
            if (this.cycle > 0) {
                xp *= (float)(3 * this.cycle);
            }
            return Math.max(0.0f, xp);
        }

        public void adjustXp(float xp, boolean isUnnaturalSource, boolean ignoreXpBuffs) {
            float xpAfterMods = xp;
            if (!isUnnaturalSource && !ignoreXpBuffs) {
                xpAfterMods = this.applyXpBuffs(xp);
            }
            if ((xp = AoAEvents.playerChangeXp(this.playerDataManager, this, xp, xpAfterMods, !isUnnaturalSource)) > 0.0f) {
                if (this.level >= 1000) {
                    return;
                }
            } else {
                if (xp == 0.0f) {
                    return;
                }
                if (this.level == 1) {
                    return;
                }
                this.subtractXp(xp, isUnnaturalSource);
                return;
            }
            float remaining = Math.min(5.4413235E8f, xp);
            int newLevels = 0;
            float xpRemaining = PlayerUtil.getXpRemainingUntilLevel(this.playerDataManager, this.skill);
            if (remaining > xpRemaining) {
                remaining -= xpRemaining;
                ++newLevels;
                while (true) {
                    float f;
                    float stillRemaining = remaining - PlayerUtil.getXpRequiredForNextLevel(this.level + newLevels);
                    if (!(f >= 0.0f) || this.level + newLevels >= 1000) break;
                    remaining = stillRemaining;
                    ++newLevels;
                }
            }
            if (newLevels > 0) {
                this.levelUp(this.level, this.level + newLevels, !isUnnaturalSource);
            }
            if (isUnnaturalSource) {
                this.playerDataManager.applyLegitimacyPenalties();
            } else {
                AoAAdvancementTriggers.xpGainTrigger.trigger(this.playerDataManager.player(), this.skill, xp);
            }
            this.xp += remaining;
            this.needsSync = true;
            this.playerDataManager.checkAndUpdateLegitimacy();
            AoAPackets.messagePlayer(this.playerDataManager.player(), new XpGainPacket(AoARegistries.AOA_SKILLS.getId(this.skill), xp, newLevels > 0));
        }

        private void subtractXp(float xp, boolean isUnnaturalSource) {
            float remaining = Math.min(5.4413235E8f, Math.abs(xp));
            int newLevels = 0;
            if (this.level >= 1 && remaining >= this.xp) {
                remaining -= this.xp;
                ++newLevels;
                while (true) {
                    float f;
                    float stillRemaining = remaining - PlayerUtil.getXpRequiredForNextLevel(this.level - newLevels - 1);
                    if (!(f >= 0.0f) || this.level - newLevels <= 1) break;
                    remaining = stillRemaining;
                    ++newLevels;
                }
            }
            if (newLevels > 0) {
                this.level = Math.max(1, this.level - newLevels);
                AoAEvents.playerLevelChange(this.playerDataManager, this, this.level + newLevels, !isUnnaturalSource);
            }
            this.xp = Math.max(0.0f, PlayerUtil.getXpRequiredForNextLevel(this.level - newLevels) - remaining);
            this.needsSync = true;
            if (!isUnnaturalSource) {
                this.playerDataManager.applyLegitimacyPenalties();
            }
            AoAPackets.messagePlayer(this.playerDataManager.player(), new XpGainPacket(AoARegistries.AOA_SKILLS.getId(this.skill), xp, newLevels > 0));
        }

        private void levelUp(int oldLevel, int newLevel, boolean isNaturalLevel) {
            ServerPlayer player = this.playerDataManager.player();
            new SoundBuilder((Supplier<SoundEvent>)AoASounds.PLAYER_LEVEL_UP).isPlayer().notInWorld().include(new Player[]{player}).execute();
            this.level = newLevel;
            this.xp = 0.0f;
            AoAEvents.playerLevelChange(this.playerDataManager, this, oldLevel, isNaturalLevel);
            AoAAdvancementTriggers.levelUpTrigger.trigger(player, this.skill, newLevel);
        }

        public boolean addCycle() {
            if (this.level >= 100 && this.cycle < 10) {
                int oldLevel = this.level;
                ++this.cycle;
                this.level = 1;
                this.xp = 0.0f;
                this.needsSync = true;
                AoAEvents.playerLevelChange(this.playerDataManager, this, oldLevel, true);
                AoAAdvancementTriggers.cycleTrigger.trigger(this.playerDataManager.player(), this.skill, this.cycle);
                return true;
            }
            return false;
        }

        public void setCycle(int cycle) {
            this.cycle = Mth.m_14045_((int)cycle, (int)0, (int)10);
            this.needsSync = true;
            this.playerDataManager.applyLegitimacyPenalties();
        }

        public CompoundTag saveToNbt() {
            CompoundTag skillData = new CompoundTag();
            CompoundTag abilityData = new CompoundTag();
            skillData.m_128405_("cycle", this.cycle);
            skillData.m_128405_("level", this.level);
            skillData.m_128350_("xp", this.xp);
            for (Map.Entry<String, AoAAbility.Instance> ability : this.getAbilityMap().entrySet()) {
                CompoundTag abilityNbt = ability.getValue().saveToNbt();
                if (abilityNbt == null) continue;
                abilityData.m_128365_(ability.getKey(), (Tag)abilityNbt);
            }
            skillData.m_128365_("abilities", (Tag)abilityData);
            return skillData;
        }

        public void loadFromNbt(CompoundTag skillData) {
            this.level = 1;
            this.xp = 0.0f;
            if (skillData.m_128441_("cycle")) {
                this.cycle = skillData.m_128451_("cycle");
            }
            if (skillData.m_128441_("level")) {
                this.level = skillData.m_128451_("level");
            }
            if (skillData.m_128441_("xp")) {
                this.xp = skillData.m_128457_("xp");
            }
            if (skillData.m_128441_("abilities")) {
                CompoundTag abilityData = skillData.m_128469_("abilities");
                for (AoAAbility.Instance ability : this.getAbilityMap().values()) {
                    if (abilityData.m_128441_(ability.getUniqueIdentifier())) {
                        ability.loadFromNbt(abilityData.m_128469_(ability.getUniqueIdentifier()));
                        continue;
                    }
                    ability.checkDeactivation(false, false);
                }
            }
        }

        public CompoundTag getSyncData(boolean forClientSetup) {
            CompoundTag data = new CompoundTag();
            CompoundTag abilityData = new CompoundTag();
            data.m_128405_("cycle", this.cycle);
            data.m_128405_("level", this.level);
            data.m_128350_("xp", this.xp);
            data.m_128350_("xpMod", this.xpModifier);
            for (Map.Entry<String, AoAAbility.Instance> ability : this.getAbilityMap().entrySet()) {
                AoAAbility.Instance instance = ability.getValue();
                if (!instance.needsSync && !forClientSetup) continue;
                abilityData.m_128365_(instance.getUniqueIdentifier(), (Tag)instance.getSyncData(forClientSetup));
                instance.needsSync = false;
            }
            if (!abilityData.m_128456_()) {
                data.m_128365_("abilities", (Tag)abilityData);
            }
            if (!forClientSetup) {
                this.needsSync = false;
            }
            return data;
        }

        public void receiveSyncData(CompoundTag data) {
            this.cycle = data.m_128451_("cycle");
            this.level = data.m_128451_("level");
            this.xp = data.m_128457_("xp");
            this.xpModifier = data.m_128457_("xpMod");
            if (data.m_128441_("abilities")) {
                CompoundTag abilityData = data.m_128469_("abilities");
                for (String key : abilityData.m_128431_()) {
                    AoAAbility.Instance ability = this.abilities.get(key);
                    if (ability == null) continue;
                    ability.receiveSyncData(abilityData.m_128469_(key));
                }
            }
        }

        public boolean canGainXp(boolean naturalXpSource) {
            Player player = this.getPlayer();
            if (naturalXpSource && (player.m_7500_() || player.m_5833_())) {
                return false;
            }
            return this.getLevel(true) < 1000;
        }
    }
}

