/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.player.ability;

import com.google.gson.JsonObject;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.tslat.aoa3.client.AoAKeybinds;
import net.tslat.aoa3.common.registration.custom.AoAAbilities;
import net.tslat.aoa3.common.registration.custom.AoAResources;
import net.tslat.aoa3.player.AoAPlayerEventListener;
import net.tslat.aoa3.player.ability.AoAAbility;
import net.tslat.aoa3.player.resource.AoAResource;
import net.tslat.aoa3.player.skill.AoASkill;
import net.tslat.aoa3.scheduling.AoAScheduler;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.NumberUtil;
import net.tslat.aoa3.util.PlayerUtil;
import net.tslat.effectslib.api.util.EffectBuilder;

public class StunStrike
extends AoAAbility.Instance {
    private static final AoAPlayerEventListener.ListenerType[] LISTENERS = new AoAPlayerEventListener.ListenerType[]{AoAPlayerEventListener.ListenerType.KEY_INPUT, AoAPlayerEventListener.ListenerType.OUTGOING_ATTACK_AFTER};
    private final float energyCost;
    private final int stunDuration;
    private boolean primedAttack = false;

    public StunStrike(AoASkill.Instance skill, JsonObject data) {
        super((AoAAbility)AoAAbilities.STUN_STRIKE.get(), skill, data);
        this.energyCost = GsonHelper.m_13915_((JsonObject)data, (String)"energy_cost");
        this.stunDuration = GsonHelper.m_13824_((JsonObject)data, (String)"stun_duration", (int)20);
    }

    public StunStrike(AoASkill.Instance skill, CompoundTag data) {
        super((AoAAbility)AoAAbilities.STUN_STRIKE.get(), skill, data);
        this.energyCost = data.m_128457_("energy_cost");
        this.stunDuration = data.m_128451_("stun_duration");
    }

    @Override
    protected void updateDescription(MutableComponent defaultDescription) {
        super.updateDescription(Component.m_237110_((String)((TranslatableContents)defaultDescription.m_214077_()).m_237508_(), (Object[])new Object[]{NumberUtil.roundToNthDecimalPlace((float)this.stunDuration / 20.0f, 2), NumberUtil.roundToNthDecimalPlace(this.energyCost, 2)}));
    }

    @Override
    public AoAPlayerEventListener.ListenerType[] getListenerTypes() {
        return LISTENERS;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public KeyMapping getKeybind() {
        return AoAKeybinds.ABILITY_ACTION;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldSendKeyPress() {
        LocalPlayer pl = Minecraft.m_91087_().f_91074_;
        return !pl.f_108618_.m_108577_() && pl.f_108618_.f_108566_ == 0.0f && !pl.m_21120_(InteractionHand.OFF_HAND).m_41619_() && PlayerUtil.getResourceValue((Player)pl, (AoAResource)AoAResources.ENERGY.get()) >= this.energyCost;
    }

    @Override
    public void handleKeyInput() {
        ServerPlayer player = this.getPlayer();
        if (!this.primedAttack && this.skill.getPlayerDataManager().getResource((AoAResource)AoAResources.ENERGY.get()).hasAmount(this.energyCost)) {
            this.primedAttack = true;
            this.activatedActionKey(player);
        }
    }

    @Override
    public void handlePostOutgoingAttack(LivingDamageEvent ev) {
        if (ev.getAmount() > 0.0f && this.primedAttack && DamageUtil.isMeleeDamage(ev.getSource()) && !this.getPlayer().m_21120_(InteractionHand.OFF_HAND).m_41619_()) {
            this.primedAttack = false;
            if (this.skill.getPlayerDataManager().getResource((AoAResource)AoAResources.ENERGY.get()).consume(this.energyCost, true)) {
                ServerPlayer player = this.getPlayer();
                LivingEntity target = ev.getEntity();
                AoAScheduler.scheduleSyncronisedTask(() -> {
                    player.m_21011_(InteractionHand.OFF_HAND, true);
                    if (target != null && target.m_6084_() && player.m_20280_((Entity)target) < 36.0 && player.m_142582_((Entity)target)) {
                        DamageUtil.doScaledKnockback(target, (LivingEntity)player, 0.3f, 1.0, 1.0, 1.0);
                        EntityUtil.applyPotions((Entity)target, new EffectBuilder(MobEffects.f_19597_, this.stunDuration).level(127), new EffectBuilder(MobEffects.f_19599_, this.stunDuration).level(127));
                        this.activatedActionKey(player);
                        if (this.skill.canGainXp(true)) {
                            this.skill.adjustXp(PlayerUtil.getTimeBasedXpForLevel(this.skill.getLevel(true), 30.0f), false, false);
                        }
                    }
                }, player.m_21304_() - 1);
            }
        }
    }

    @Override
    public CompoundTag getSyncData(boolean forClientSetup) {
        CompoundTag data = super.getSyncData(forClientSetup);
        if (forClientSetup) {
            data.m_128350_("energy_cost", this.energyCost);
            data.m_128350_("stun_duration", (float)this.stunDuration);
        }
        return data;
    }
}

