/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.player.ability;

import com.google.gson.JsonObject;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.tslat.aoa3.common.registration.AoARegistries;
import net.tslat.aoa3.player.ability.AoAAbility;
import net.tslat.aoa3.player.skill.AoASkill;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.NumberUtil;
import net.tslat.smartbrainlib.util.RandomUtil;

public abstract class ScalableModAbility
extends AoAAbility.Instance {
    protected final float baseValue;
    protected final float perLevelMod;
    private int lastUpdateLevel = 0;

    public ScalableModAbility(AoAAbility ability, AoASkill.Instance skill, JsonObject data) {
        super(ability, skill, data);
        this.baseValue = GsonHelper.m_13820_((JsonObject)data, (String)"base_value", (float)0.0f);
        this.perLevelMod = GsonHelper.m_13820_((JsonObject)data, (String)"per_level_mod", (float)0.0f);
    }

    public ScalableModAbility(AoAAbility ability, AoASkill.Instance skill, CompoundTag data) {
        super(ability, skill, data);
        this.baseValue = data.m_128457_("base_value");
        this.perLevelMod = data.m_128457_("per_level_mod");
    }

    @Override
    protected void updateDescription(MutableComponent defaultDescription) {
        String defaultKey = Util.m_137492_((String)"ability", (ResourceLocation)AoARegistries.AOA_ABILITIES.getId(this.type())) + ".description";
        TranslatableContents contents = (TranslatableContents)defaultDescription.m_214077_();
        if (contents.m_237508_().equals(defaultKey) && contents.m_237523_().length == 0) {
            MutableComponent component = Component.m_237110_((String)contents.m_237508_(), (Object[])new Object[]{this.getScalingDescriptionComponent(4)});
            for (Component child : defaultDescription.m_7360_()) {
                component.m_7220_(child);
            }
            super.updateDescription(component);
            return;
        }
        super.updateDescription(defaultDescription);
    }

    @Override
    public MutableComponent getDescription() {
        if (this.skill.getLevel(true) != this.lastUpdateLevel) {
            this.lastUpdateLevel = this.skill.getLevel(true);
            this.updateDescription(Component.m_237115_((String)(Util.m_137492_((String)"ability", (ResourceLocation)AoARegistries.AOA_ABILITIES.getId(this.type())) + ".description")));
        }
        return super.getDescription();
    }

    protected MutableComponent getScalingDescriptionComponent(int precision) {
        return LocaleUtil.getAbilityValueDesc(this.baseValue != 0.0f, this.perLevelMod != 0.0f, this.isPercent(), NumberUtil.roundToNthDecimalPlace(this.baseValue * (float)(this.isPercent() ? 100 : 1), precision), NumberUtil.roundToNthDecimalPlace(this.perLevelMod * (float)(this.isPercent() ? 100 : 1), precision), NumberUtil.roundToNthDecimalPlace(this.getScaledValue() * (float)(this.isPercent() ? 100 : 1), precision));
    }

    protected boolean isPercent() {
        return true;
    }

    protected boolean testAsChance() {
        return RandomUtil.percentChance((float)this.getScaledValue());
    }

    protected float getScaledValue() {
        if (this.perLevelMod == 0.0f) {
            return this.baseValue;
        }
        return this.baseValue + (float)this.skill.getLevel(false) * this.perLevelMod;
    }

    @Override
    public CompoundTag getSyncData(boolean forClientSetup) {
        CompoundTag data = super.getSyncData(forClientSetup);
        if (forClientSetup) {
            data.m_128350_("base_value", this.baseValue);
            data.m_128350_("per_level_mod", this.perLevelMod);
        }
        return data;
    }
}

