/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.player.ability;

import com.google.gson.JsonObject;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.tslat.aoa3.client.AoAKeybinds;
import net.tslat.aoa3.common.registration.custom.AoAAbilities;
import net.tslat.aoa3.common.registration.custom.AoAResources;
import net.tslat.aoa3.library.constant.ScreenImageEffect;
import net.tslat.aoa3.player.AoAPlayerEventListener;
import net.tslat.aoa3.player.ability.AoAAbility;
import net.tslat.aoa3.player.resource.AoAResource;
import net.tslat.aoa3.player.skill.AoASkill;
import net.tslat.aoa3.util.NumberUtil;
import net.tslat.aoa3.util.PlayerUtil;

public class InnervationMobLure
extends AoAAbility.Instance {
    private static final AoAPlayerEventListener.ListenerType[] LISTENERS = new AoAPlayerEventListener.ListenerType[]{AoAPlayerEventListener.ListenerType.KEY_INPUT, AoAPlayerEventListener.ListenerType.PLAYER_TICK, AoAPlayerEventListener.ListenerType.INCOMING_ATTACK_DURING};
    private final float onHitDrain;
    private final float perTickDrain;
    private final float luredDamageModifier;
    private boolean isLuring = false;
    private Mob luringEntity = null;

    public InnervationMobLure(AoASkill.Instance skill, JsonObject data) {
        super((AoAAbility)AoAAbilities.INNERVATION_MOB_LURE.get(), skill, data);
        this.onHitDrain = GsonHelper.m_13915_((JsonObject)data, (String)"on_hit_drain");
        this.perTickDrain = GsonHelper.m_13915_((JsonObject)data, (String)"per_tick_spirit_drain");
        this.luredDamageModifier = GsonHelper.m_13820_((JsonObject)data, (String)"lured_damage_modifier", (float)0.5f);
    }

    public InnervationMobLure(AoASkill.Instance skill, CompoundTag data) {
        super((AoAAbility)AoAAbilities.INNERVATION_MOB_LURE.get(), skill, data);
        this.onHitDrain = data.m_128457_("on_hit_drain");
        this.perTickDrain = data.m_128457_("per_tick_spirit_drain");
        this.luredDamageModifier = data.m_128457_("lured_damage_modifier");
    }

    @Override
    protected void updateDescription(MutableComponent defaultDescription) {
        super.updateDescription(Component.m_237110_((String)((TranslatableContents)defaultDescription.m_214077_()).m_237508_(), (Object[])new Object[]{NumberUtil.roundToNthDecimalPlace(this.perTickDrain * 20.0f, 2), NumberUtil.roundToNthDecimalPlace(this.luredDamageModifier * 100.0f, 2), NumberUtil.roundToNthDecimalPlace(this.onHitDrain, 2)}));
    }

    @Override
    public AoAPlayerEventListener.ListenerType[] getListenerTypes() {
        return LISTENERS;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public KeyMapping getKeybind() {
        return AoAKeybinds.ABILITY_ACTION;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldSendKeyPress() {
        return Minecraft.m_91087_().f_91074_.m_6047_();
    }

    @Override
    public void handleKeyInput() {
        LivingEntity livingEntity;
        ServerPlayer player = this.getPlayer();
        if (!this.isLuring && player.m_6047_() && (livingEntity = player.m_21214_()) instanceof Mob) {
            Mob mob;
            this.luringEntity = mob = (Mob)livingEntity;
            this.isLuring = true;
            this.activatedActionKey(player);
        }
    }

    @Override
    public void handlePlayerTick(TickEvent.PlayerTickEvent ev) {
        Player player;
        if (!this.isLuring) {
            return;
        }
        if (this.luringEntity == null || this.luringEntity.m_21224_() || ev.player.m_21224_() || !ev.player.m_6047_() || !this.skill.getPlayerDataManager().getResource((AoAResource)AoAResources.SPIRIT.get()).consume(this.perTickDrain, true)) {
            this.resetLureState();
            return;
        }
        if (ev.player.f_19853_.m_46467_() % 10L == 0L && (player = ev.player) instanceof ServerPlayer) {
            ServerPlayer pl = (ServerPlayer)player;
            new ScreenImageEffect(ScreenImageEffect.Type.ACTION_KEY_VIGNETTE).fullscreen(true).duration(10).sendToPlayer(pl);
        }
        if (this.luringEntity.m_5448_() != ev.player) {
            this.luringEntity.m_6710_((LivingEntity)ev.player);
        }
    }

    @Override
    public void handleIncomingAttack(LivingHurtEvent ev) {
        if (this.isLuring && ev.getSource().m_7639_() == this.luringEntity) {
            this.skill.getPlayerDataManager().getResource((AoAResource)AoAResources.SPIRIT.get()).consume(this.onHitDrain, true);
            ev.setAmount(ev.getAmount() * this.luredDamageModifier);
            this.resetLureState();
            if (this.skill.canGainXp(true)) {
                this.skill.adjustXp(PlayerUtil.getTimeBasedXpForLevel(this.skill.getLevel(true), 30.0f), false, false);
            }
        }
    }

    private void resetLureState() {
        this.isLuring = false;
        this.luringEntity = null;
    }

    @Override
    public CompoundTag getSyncData(boolean forClientSetup) {
        CompoundTag data = super.getSyncData(forClientSetup);
        if (forClientSetup) {
            data.m_128350_("on_hit_drain", this.onHitDrain);
            data.m_128350_("per_tick_spirit_drain", this.perTickDrain);
            data.m_128350_("lured_damage_modifier", this.luredDamageModifier);
        }
        return data;
    }
}

