/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.player.ability;

import com.google.gson.JsonObject;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.player.ItemFishedEvent;
import net.tslat.aoa3.common.registration.custom.AoAAbilities;
import net.tslat.aoa3.event.custom.events.HaulingItemFishedEvent;
import net.tslat.aoa3.player.AoAPlayerEventListener;
import net.tslat.aoa3.player.ability.AoAAbility;
import net.tslat.aoa3.player.ability.ScalableModAbility;
import net.tslat.aoa3.player.skill.AoASkill;
import net.tslat.smartbrainlib.util.RandomUtil;

public class FishingXpBoost
extends ScalableModAbility {
    private static final AoAPlayerEventListener.ListenerType[] LISTENERS = new AoAPlayerEventListener.ListenerType[]{AoAPlayerEventListener.ListenerType.FISHED_ITEM};
    private final boolean useAddition;

    public FishingXpBoost(AoASkill.Instance skill, JsonObject data) {
        super((AoAAbility)AoAAbilities.FISHING_XP_BOOST.get(), skill, data);
        this.useAddition = GsonHelper.m_13855_((JsonObject)data, (String)"use_addition", (boolean)false);
    }

    public FishingXpBoost(AoASkill.Instance skill, CompoundTag data) {
        super((AoAAbility)AoAAbilities.FISHING_XP_BOOST.get(), skill, data);
        this.useAddition = data.m_128471_("use_addition");
    }

    @Override
    protected boolean isPercent() {
        return !this.useAddition;
    }

    @Override
    public AoAPlayerEventListener.ListenerType[] getListenerTypes() {
        return LISTENERS;
    }

    @Override
    public void handleItemFished(ItemFishedEvent ev, boolean isHauling) {
        if (ev instanceof HaulingItemFishedEvent) {
            HaulingItemFishedEvent haulingEv = (HaulingItemFishedEvent)ev;
            float xp = haulingEv.getXp();
            xp = this.useAddition ? (xp += this.getScaledValue()) : (xp *= 1.0f + this.getScaledValue());
            haulingEv.setXp((int)xp);
        } else {
            Player player = ev.getEntity();
            player.f_19853_.m_7967_((Entity)new ExperienceOrb(player.f_19853_, player.m_20185_() + 0.5, player.m_20186_() + 0.5, player.m_20189_() + 0.5, RandomUtil.randomNumberBetween((int)1, (int)6)));
        }
    }

    @Override
    public CompoundTag getSyncData(boolean forClientSetup) {
        CompoundTag data = super.getSyncData(forClientSetup);
        if (forClientSetup) {
            data.m_128379_("use_addition", this.useAddition);
        }
        return data;
    }
}

