/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.player.ability;

import com.google.gson.JsonObject;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.tslat.aoa3.common.registration.custom.AoAAbilities;
import net.tslat.aoa3.player.AoAPlayerEventListener;
import net.tslat.aoa3.player.ability.AoAAbility;
import net.tslat.aoa3.player.ability.ScalableModAbility;
import net.tslat.aoa3.player.skill.AoASkill;

public class FallDamageReduction
extends ScalableModAbility {
    private static final AoAPlayerEventListener.ListenerType[] LISTENERS = new AoAPlayerEventListener.ListenerType[]{AoAPlayerEventListener.ListenerType.PLAYER_FALL};
    private final int minHeight;
    private final int maxHeight;

    public FallDamageReduction(AoASkill.Instance skill, JsonObject data) {
        super((AoAAbility)AoAAbilities.FALL_DAMAGE_REDUCTION.get(), skill, data);
        this.minHeight = GsonHelper.m_13824_((JsonObject)data, (String)"min_height", (int)0);
        this.maxHeight = GsonHelper.m_13824_((JsonObject)data, (String)"max_height", (int)Integer.MAX_VALUE);
    }

    public FallDamageReduction(AoASkill.Instance skill, CompoundTag data) {
        super((AoAAbility)AoAAbilities.FALL_DAMAGE_REDUCTION.get(), skill, data);
        this.minHeight = data.m_128451_("min_height");
        this.maxHeight = data.m_128451_("max_height");
    }

    @Override
    protected void updateDescription(MutableComponent defaultDescription) {
        Object key = ((TranslatableContents)defaultDescription.m_214077_()).m_237508_();
        if (this.minHeight > 0) {
            if (this.maxHeight == Integer.MAX_VALUE) {
                key = (String)key + ".min";
            }
        } else if (this.maxHeight < Integer.MAX_VALUE) {
            key = (String)key + ".max";
        }
        super.updateDescription(Component.m_237110_((String)key, (Object[])new Object[]{this.minHeight - 1, this.maxHeight, this.getScalingDescriptionComponent(2)}));
    }

    @Override
    public AoAPlayerEventListener.ListenerType[] getListenerTypes() {
        return LISTENERS;
    }

    @Override
    public void handlePlayerFall(LivingFallEvent ev) {
        if (ev.getDistance() >= (float)this.minHeight && ev.getDistance() <= (float)this.maxHeight) {
            ev.setDamageMultiplier(Math.max(0.0f, ev.getDamageMultiplier() * (1.0f - Math.min(1.0f, this.getScaledValue()))));
            if (Mth.m_14167_((float)((ev.getDistance() - 3.0f) * ev.getDamageMultiplier())) < 1) {
                ev.setDamageMultiplier(0.0f);
            }
        }
    }

    @Override
    public CompoundTag getSyncData(boolean forClientSetup) {
        CompoundTag data = super.getSyncData(forClientSetup);
        if (forClientSetup) {
            data.m_128405_("min_height", this.minHeight);
            data.m_128405_("max_height", this.maxHeight);
        }
        return data;
    }
}

