/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.player.ability;

import com.google.gson.JsonObject;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.level.BlockEvent;
import net.tslat.aoa3.common.packet.AoAPackets;
import net.tslat.aoa3.common.packet.packets.ServerParticlePacket;
import net.tslat.aoa3.common.registration.custom.AoAAbilities;
import net.tslat.aoa3.common.registration.entity.AoANpcs;
import net.tslat.aoa3.content.entity.npc.ambient.DryadSpriteEntity;
import net.tslat.aoa3.library.builder.ParticleBuilder;
import net.tslat.aoa3.player.AoAPlayerEventListener;
import net.tslat.aoa3.player.ability.AoAAbility;
import net.tslat.aoa3.player.ability.ScalableModAbility;
import net.tslat.aoa3.player.skill.AoASkill;
import net.tslat.aoa3.util.EntitySpawningUtil;
import net.tslat.smartbrainlib.util.RandomUtil;

public class DryadSpriteSpawn
extends ScalableModAbility {
    private static final AoAPlayerEventListener.ListenerType[] LISTENERS = new AoAPlayerEventListener.ListenerType[]{AoAPlayerEventListener.ListenerType.BLOCK_BREAK};

    public DryadSpriteSpawn(AoASkill.Instance skill, JsonObject data) {
        super((AoAAbility)AoAAbilities.DRYAD_SPRITE_SPAWN.get(), skill, data);
    }

    public DryadSpriteSpawn(AoASkill.Instance skill, CompoundTag data) {
        super((AoAAbility)AoAAbilities.DRYAD_SPRITE_SPAWN.get(), skill, data);
    }

    @Override
    public AoAPlayerEventListener.ListenerType[] getListenerTypes() {
        return LISTENERS;
    }

    @Override
    public void handleBlockBreak(BlockEvent.BreakEvent ev) {
        LevelAccessor levelAccessor = ev.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)levelAccessor;
            if (this.testAsChance()) {
                CropBlock crop;
                Block block = ev.getState().m_60734_();
                if (!(block instanceof CropBlock) || !(crop = (CropBlock)block).m_52307_(ev.getState()) || this.getPlayer().m_150110_().f_35937_) {
                    return;
                }
                BlockPos pos = ev.getPos();
                if (serverLevel.m_8055_(pos.m_7494_()).m_60795_()) {
                    DryadSpriteEntity dryad = (DryadSpriteEntity)((Object)EntitySpawningUtil.spawnEntity(serverLevel, (EntityType)AoANpcs.DRYAD_SPRITE.get(), new Vec3((double)((float)pos.m_123341_() + 0.5f), (double)pos.m_123342_() + 0.1, (double)((float)pos.m_123343_() + 0.5f)), MobSpawnType.TRIGGERED));
                    ServerParticlePacket packet = new ServerParticlePacket();
                    for (int i = 0; i < 20; ++i) {
                        packet.particle(ParticleBuilder.forRandomPosInEntity((ParticleOptions)ParticleTypes.f_123748_, (Entity)dryad).velocity(RandomUtil.randomScaledGaussianValue((double)0.02), RandomUtil.randomScaledGaussianValue((double)0.02), RandomUtil.randomScaledGaussianValue((double)0.02)));
                    }
                    AoAPackets.messageAllPlayersTrackingEntity(packet, (Entity)ev.getPlayer());
                }
            }
        }
    }
}

