/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.player.ability;

import com.google.gson.JsonObject;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.tslat.aoa3.common.registration.custom.AoAAbilities;
import net.tslat.aoa3.player.AoAPlayerEventListener;
import net.tslat.aoa3.player.ability.AoAAbility;
import net.tslat.aoa3.player.skill.AoASkill;
import net.tslat.aoa3.util.NumberUtil;

public class BowDamageIncrease
extends AoAAbility.Instance {
    private static final AoAPlayerEventListener.ListenerType[] LISTENERS = new AoAPlayerEventListener.ListenerType[]{AoAPlayerEventListener.ListenerType.OUTGOING_ATTACK_DURING};
    private final boolean requireFullyCharged;
    private final float modifier;

    public BowDamageIncrease(AoASkill.Instance skill, JsonObject data) {
        super((AoAAbility)AoAAbilities.BOW_DAMAGE_INCREASE.get(), skill, data);
        this.requireFullyCharged = GsonHelper.m_13855_((JsonObject)data, (String)"require_full_charge", (boolean)true);
        this.modifier = GsonHelper.m_13915_((JsonObject)data, (String)"modifier");
    }

    public BowDamageIncrease(AoASkill.Instance skill, CompoundTag data) {
        super((AoAAbility)AoAAbilities.BOW_DAMAGE_INCREASE.get(), skill, data);
        this.requireFullyCharged = data.m_128471_("require_full_charge");
        this.modifier = data.m_128457_("modifier");
    }

    @Override
    public AoAPlayerEventListener.ListenerType[] getListenerTypes() {
        return LISTENERS;
    }

    @Override
    protected void updateDescription(MutableComponent defaultDescription) {
        super.updateDescription(Component.m_237110_((String)(((TranslatableContents)defaultDescription.m_214077_()).m_237508_() + (this.requireFullyCharged ? ".fullCharge" : "")), (Object[])new Object[]{NumberUtil.roundToNthDecimalPlace((this.modifier - 1.0f) * 100.0f, 2)}));
    }

    @Override
    public void handleOutgoingAttack(LivingHurtEvent ev) {
        DamageSource source = ev.getSource();
        if (source.m_269533_(DamageTypeTags.f_268524_) && source.m_7640_() instanceof AbstractArrow && (!this.requireFullyCharged || ((AbstractArrow)source.m_7640_()).m_36792_())) {
            ev.setAmount(ev.getAmount() * this.modifier);
        }
    }

    @Override
    public CompoundTag getSyncData(boolean forClientSetup) {
        CompoundTag data = super.getSyncData(forClientSetup);
        if (forClientSetup) {
            data.m_128379_("require_full_charge", this.requireFullyCharged);
            data.m_128350_("modifier", this.modifier);
        }
        return data;
    }
}

