/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.player.ability;

import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraftforge.registries.ForgeRegistries;
import net.tslat.aoa3.common.registration.custom.AoAAbilities;
import net.tslat.aoa3.event.custom.events.ItemCraftingEvent;
import net.tslat.aoa3.player.AoAPlayerEventListener;
import net.tslat.aoa3.player.ability.AoAAbility;
import net.tslat.aoa3.player.ability.ScalableModAbility;
import net.tslat.aoa3.player.skill.AoASkill;

public class BonusCraftingOutput
extends ScalableModAbility {
    private static final AoAPlayerEventListener.ListenerType[] LISTENERS = new AoAPlayerEventListener.ListenerType[]{AoAPlayerEventListener.ListenerType.ITEM_CRAFTING};
    @Nullable
    private final Item outputTarget;
    @Nullable
    private final TagKey<Item> outputTargetTag;

    public BonusCraftingOutput(AoASkill.Instance skill, JsonObject data) {
        super((AoAAbility)AoAAbilities.BONUS_CRAFTING_OUTPUT.get(), skill, data);
        if (data.has("item")) {
            this.outputTargetTag = null;
            this.outputTarget = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(GsonHelper.m_13906_((JsonObject)data, (String)"item")));
        } else {
            this.outputTarget = null;
            this.outputTargetTag = ItemTags.create((ResourceLocation)new ResourceLocation(GsonHelper.m_13906_((JsonObject)data, (String)"tag")));
        }
    }

    public BonusCraftingOutput(AoASkill.Instance skill, CompoundTag data) {
        super((AoAAbility)AoAAbilities.BONUS_CRAFTING_OUTPUT.get(), skill, data);
        if (data.m_128441_("item")) {
            this.outputTargetTag = null;
            this.outputTarget = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(data.m_128461_("item")));
        } else {
            this.outputTarget = null;
            this.outputTargetTag = ItemTags.create((ResourceLocation)new ResourceLocation(data.m_128461_("tag")));
        }
    }

    @Override
    protected void updateDescription(MutableComponent defaultDescription) {
        MutableComponent component = this.outputTarget != null ? Component.m_237110_((String)(((TranslatableContents)defaultDescription.m_214077_()).m_237508_() + ".item"), (Object[])new Object[]{this.getScalingDescriptionComponent(2), this.outputTarget.m_7968_().m_41786_()}) : Component.m_237110_((String)(((TranslatableContents)defaultDescription.m_214077_()).m_237508_() + ".tag"), (Object[])new Object[]{this.getScalingDescriptionComponent(2), this.outputTargetTag.f_203868_().toString()});
        super.updateDescription(component);
    }

    @Override
    public AoAPlayerEventListener.ListenerType[] getListenerTypes() {
        return LISTENERS;
    }

    @Override
    public void handleItemCrafting(ItemCraftingEvent ev) {
        if (this.outputTarget != null) {
            if (ev.getOutputStack().m_41720_() == this.outputTarget) {
                ev.getOutputStack().m_41764_((int)Math.ceil((float)ev.getOutputStack().m_41613_() * (1.0f + this.getScaledValue())));
            }
        } else if (ev.getOutputStack().m_204117_(this.outputTargetTag)) {
            ev.getOutputStack().m_41764_((int)Math.ceil((float)ev.getOutputStack().m_41613_() * (1.0f + this.getScaledValue())));
        }
    }

    @Override
    public CompoundTag getSyncData(boolean forClientSetup) {
        CompoundTag data = super.getSyncData(forClientSetup);
        if (forClientSetup) {
            if (this.outputTarget != null) {
                data.m_128359_("item", ForgeRegistries.ITEMS.getKey((Object)this.outputTarget).toString());
            } else {
                data.m_128359_("tag", this.outputTargetTag.f_203868_().toString());
            }
        }
        return data;
    }
}

