/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.player.ability;

import com.google.gson.JsonObject;
import java.util.function.BiFunction;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.Lazy;
import net.tslat.aoa3.common.registration.AoARegistries;
import net.tslat.aoa3.player.AoAPlayerEventListener;
import net.tslat.aoa3.player.resource.AoAResource;
import net.tslat.aoa3.player.skill.AoASkill;

public class AoAAbility {
    private final Lazy<MutableComponent> name = Lazy.of(() -> Component.m_237115_((String)Util.m_137492_((String)"ability", (ResourceLocation)AoARegistries.AOA_ABILITIES.getId(this))));
    private final BiFunction<AoASkill.Instance, JsonObject, Instance> jsonFactory;
    private final BiFunction<AoASkill.Instance, CompoundTag, Instance> nbtFactory;

    public AoAAbility(BiFunction<AoASkill.Instance, JsonObject, Instance> jsonFactory, BiFunction<AoASkill.Instance, CompoundTag, Instance> nbtFactory) {
        this.jsonFactory = jsonFactory;
        this.nbtFactory = nbtFactory;
    }

    public MutableComponent getName() {
        return (MutableComponent)this.name.get();
    }

    public Instance create(AoASkill.Instance skillInstance, JsonObject abilityData) {
        return this.jsonFactory.apply(skillInstance, abilityData);
    }

    public Instance loadFromNbt(AoASkill.Instance skillInstance, CompoundTag abilityData) {
        return this.nbtFactory.apply(skillInstance, abilityData);
    }

    public static abstract class Instance
    implements AoAPlayerEventListener {
        private final AoAAbility ability;
        protected AoASkill.Instance skill;
        private final int levelReq;
        private final String uniqueIdentifier;
        private MutableComponent description;
        public boolean needsSync = true;
        private AoAPlayerEventListener.ListenerState state;

        public Instance(AoAAbility ability, AoASkill.Instance skill, JsonObject data) {
            this.skill = skill;
            this.ability = ability;
            this.uniqueIdentifier = GsonHelper.m_13906_((JsonObject)data, (String)"unique_id");
            this.levelReq = GsonHelper.m_13927_((JsonObject)data, (String)"level_req");
            this.state = AoAPlayerEventListener.ListenerState.fromId(GsonHelper.m_13851_((JsonObject)data, (String)"state", (String)AoAPlayerEventListener.ListenerState.ACTIVE.getId()));
            this.description = data.has("description") ? Component.m_237115_((String)GsonHelper.m_13906_((JsonObject)data, (String)"description")) : null;
            this.checkDeactivation(true, false);
        }

        public Instance(AoAAbility ability, AoASkill.Instance skill, CompoundTag data) {
            this.skill = skill;
            this.ability = ability;
            this.uniqueIdentifier = data.m_128461_("unique_identifier");
            this.levelReq = data.m_128451_("level_req");
            this.state = AoAPlayerEventListener.ListenerState.fromId(data.m_128461_("state"));
            this.description = data.m_128441_("description") ? Component.m_237115_((String)data.m_128461_("description")) : null;
        }

        protected void updateDescription(MutableComponent defaultDescription) {
            this.description = defaultDescription;
        }

        public AoAAbility type() {
            return this.ability;
        }

        public MutableComponent getName() {
            return this.type().getName();
        }

        public MutableComponent getDescription() {
            if (this.description == null) {
                this.updateDescription(Component.m_237115_((String)(Util.m_137492_((String)"ability", (ResourceLocation)AoARegistries.AOA_ABILITIES.getId(this.type())) + ".description")));
            }
            return this.description;
        }

        public String getUniqueIdentifier() {
            return this.uniqueIdentifier;
        }

        public int getLevelReq() {
            return this.levelReq;
        }

        public AoASkill.Instance getSkill() {
            return this.skill;
        }

        @Override
        public final void reenable(boolean isInit) {
            if (this.skill.hasLevel(this.getLevelReq())) {
                this.state = AoAPlayerEventListener.ListenerState.ACTIVE;
                this.markForClientSync();
                this.skill.getPlayerDataManager().markListenerDirty(this);
                if (!isInit) {
                    this.applyAttributeModifiers(this.skill.getPlayerDataManager());
                    this.onReenable();
                }
            }
        }

        @Override
        public final void disable(AoAPlayerEventListener.ListenerState reason, boolean isInit) {
            this.state = reason;
            this.markForClientSync();
            this.skill.getPlayerDataManager().markListenerDirty(this);
            if (!isInit) {
                this.removeAttributeModifiers(this.skill.getPlayerDataManager());
                this.onDisable();
            }
        }

        protected void onReenable() {
        }

        protected void onDisable() {
        }

        protected void markForClientSync() {
            this.needsSync = true;
            this.skill.needsSync = true;
        }

        @Override
        public AoAPlayerEventListener.ListenerState getListenerState() {
            return this.state;
        }

        protected ServerPlayer getPlayer() {
            return this.skill.getPlayerDataManager().player();
        }

        protected boolean consumeResource(AoAResource resource, float amount, boolean consumeIfInsufficient) {
            return this.skill.getPlayerDataManager().getResource(resource).consume(amount, consumeIfInsufficient);
        }

        @Override
        public boolean meetsRequirements() {
            return this.skill.hasLevel(this.getLevelReq());
        }

        public void checkDeactivation(boolean isInit, boolean stateChanged) {
            if (this.state == AoAPlayerEventListener.ListenerState.ACTIVE) {
                if (!this.skill.hasLevel(this.levelReq)) {
                    this.disable(AoAPlayerEventListener.ListenerState.DEACTIVATED, isInit);
                } else if (stateChanged) {
                    this.reenable(isInit);
                }
            } else if (this.state == AoAPlayerEventListener.ListenerState.DEACTIVATED) {
                if (this.skill.hasLevel(this.levelReq)) {
                    this.reenable(isInit);
                } else {
                    this.disable(this.state, isInit);
                }
            }
        }

        public CompoundTag saveToNbt() {
            CompoundTag data = new CompoundTag();
            data.m_128359_("state", this.state.getId());
            return data;
        }

        public void loadFromNbt(CompoundTag data) {
            AoAPlayerEventListener.ListenerState prevState = this.state;
            this.state = AoAPlayerEventListener.ListenerState.fromId(data.m_128461_("state"));
            this.checkDeactivation(false, prevState != this.state);
        }

        public CompoundTag getSyncData(boolean forClientSetup) {
            CompoundTag data = new CompoundTag();
            data.m_128359_("state", this.state.getId());
            if (forClientSetup) {
                data.m_128359_("id", AoARegistries.AOA_ABILITIES.getId(this.type()).toString());
                data.m_128359_("unique_identifier", this.uniqueIdentifier);
                data.m_128405_("level_req", this.levelReq);
                if (this.description != null) {
                    data.m_128359_("description", ((TranslatableContents)this.description.m_214077_()).m_237508_());
                }
            }
            return data;
        }

        public void receiveSyncData(CompoundTag data) {
            this.state = AoAPlayerEventListener.ListenerState.fromId(data.m_128461_("state"));
        }

        public void receiveInteractionDataFromClient(String data) {
        }

        @OnlyIn(value=Dist.CLIENT)
        public boolean onGuiClick(int mouseX, int mouseY) {
            return this.getListenerState() == AoAPlayerEventListener.ListenerState.ACTIVE || this.getListenerState() == AoAPlayerEventListener.ListenerState.MANUALLY_DISABLED;
        }

        @OnlyIn(value=Dist.CLIENT)
        public boolean onGuiHover(int mouseX, int mouseY) {
            return this.getListenerState() == AoAPlayerEventListener.ListenerState.ACTIVE || this.getListenerState() == AoAPlayerEventListener.ListenerState.MANUALLY_DISABLED;
        }
    }
}

