/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.player;

import java.util.List;
import net.minecraft.client.KeyMapping;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.BabyEntitySpawnEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingChangeTargetEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import net.minecraftforge.event.entity.player.ItemFishedEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerXpEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.tslat.aoa3.event.custom.events.HaulingRodPullEntityEvent;
import net.tslat.aoa3.event.custom.events.ItemCraftingEvent;
import net.tslat.aoa3.event.custom.events.ItemSmeltingEvent;
import net.tslat.aoa3.event.custom.events.PlayerChangeXpEvent;
import net.tslat.aoa3.event.custom.events.PlayerLevelChangeEvent;
import net.tslat.aoa3.library.constant.ScreenImageEffect;
import net.tslat.aoa3.player.ServerPlayerDataManager;
import net.tslat.aoa3.util.ColourUtil;

public interface AoAPlayerEventListener {
    default public ListenerType[] getListenerTypes() {
        return new ListenerType[0];
    }

    default public ListenerState getListenerState() {
        return ListenerState.ACTIVE;
    }

    default public boolean meetsRequirements() {
        return true;
    }

    default public void reenable(boolean isInit) {
    }

    default public void disable(ListenerState reason, boolean isInit) {
    }

    default public void handlePlayerTick(TickEvent.PlayerTickEvent ev) {
    }

    default public void handlePlayerJump(LivingEvent.LivingJumpEvent ev) {
    }

    default public void handlePlayerFall(LivingFallEvent ev) {
    }

    default public void handlePlayerDeath(LivingDeathEvent ev) {
    }

    default public void handlePlayerRespawn(PlayerEvent.PlayerRespawnEvent ev) {
    }

    default public void handlePlayerLogin(PlayerEvent.PlayerLoggedInEvent ev) {
    }

    default public void handlePlayerLogout(PlayerEvent.PlayerLoggedOutEvent ev) {
    }

    default public void handlePlayerDataClone(PlayerEvent.Clone ev) {
    }

    default public void handleArmourChange(LivingEquipmentChangeEvent ev) {
    }

    default public void handleDimensionChange(PlayerEvent.PlayerChangedDimensionEvent ev) {
    }

    default public void handleGamemodeChange(PlayerEvent.PlayerChangeGameModeEvent ev) {
    }

    default public void handleBlockHarvestAttempt(PlayerEvent.HarvestCheck ev) {
    }

    default public void handleHarvestSpeedCheck(PlayerEvent.BreakSpeed ev) {
    }

    default public void handleBlockBreak(BlockEvent.BreakEvent ev) {
    }

    default public void handleBlockPlacement(BlockEvent.EntityPlaceEvent ev) {
    }

    default public void handleBlockInteraction(PlayerInteractEvent.RightClickBlock ev) {
    }

    default public void handleItemToss(ItemTossEvent ev) {
    }

    default public void handleLevelChange(PlayerLevelChangeEvent ev) {
    }

    default public void handleSkillXpGain(PlayerChangeXpEvent ev) {
    }

    default public void handleVanillaXpGain(PlayerXpEvent.XpChange ev) {
    }

    default public void handleItemCrafting(ItemCraftingEvent ev) {
    }

    default public void handleItemCrafted(PlayerEvent.ItemCraftedEvent ev) {
    }

    default public void handleItemSmelting(ItemSmeltingEvent ev) {
    }

    default public void handleItemSmelted(PlayerEvent.ItemSmeltedEvent ev) {
    }

    default public void handleItemFished(ItemFishedEvent ev, boolean isHauling) {
    }

    default public void handleHaulingRodPullEntity(HaulingRodPullEntityEvent ev) {
    }

    default public void handleAppliedPotion(MobEffectEvent.Added ev) {
    }

    default public void applyAttributeModifiers(ServerPlayerDataManager plData) {
    }

    default public void removeAttributeModifiers(ServerPlayerDataManager plData) {
    }

    default public void handleCriticalHit(CriticalHitEvent ev) {
    }

    default public void handleEntityTarget(LivingChangeTargetEvent ev) {
    }

    default public void handlePreIncomingAttack(LivingAttackEvent ev) {
    }

    default public void handlePreOutgoingAttack(LivingAttackEvent ev) {
    }

    default public void handleIncomingAttack(LivingHurtEvent ev) {
    }

    default public void handleOutgoingAttack(LivingHurtEvent ev) {
    }

    default public void handlePostIncomingAttack(LivingDamageEvent ev) {
    }

    default public void handlePostOutgoingAttack(LivingDamageEvent ev) {
    }

    default public void handleEntityKill(LivingDeathEvent ev) {
    }

    default public void handleAnimalBreed(BabyEntitySpawnEvent ev) {
    }

    default public void handleLootModification(List<ItemStack> loot, LootContext context) {
    }

    @OnlyIn(value=Dist.CLIENT)
    default public KeyMapping getKeybind() {
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    default public boolean shouldSendKeyPress() {
        return true;
    }

    default public void handleKeyInput() {
    }

    default public void activatedActionKey(ServerPlayer player) {
        new ScreenImageEffect(ScreenImageEffect.Type.ACTION_KEY_VIGNETTE).coloured(ColourUtil.addAlpha(ColourUtil.WHITE, 127)).fullscreen(true).duration(10).sendToPlayer(player);
    }

    default public void handleCustomInteraction(String interactionType, Object data) {
    }

    public static enum ListenerType {
        PLAYER_TICK,
        PLAYER_JUMP,
        PLAYER_FALL,
        PLAYER_DEATH,
        PLAYER_RESPAWN,
        PLAYER_LOGIN,
        PLAYER_LOGOUT,
        PLAYER_CLONE,
        EQUIPMENT_CHANGE,
        DIMENSION_CHANGE,
        GAMEMODE_CHANGE,
        BLOCK_HARVEST_ATTEMPT,
        BLOCK_BREAK_SPEED,
        BLOCK_BREAK,
        BLOCK_PLACE,
        BLOCK_INTERACT,
        ITEM_THROW,
        LEVEL_CHANGE,
        GAIN_SKILL_XP,
        GAIN_VANILLA_XP,
        ITEM_CRAFTING,
        ITEM_CRAFTED,
        ITEM_SMELTING,
        ITEM_SMELTED,
        FISHED_ITEM,
        HAULING_ROD_PULL_ENTITY,
        POTION_APPLIED,
        LOOT_MODIFICATION,
        ATTRIBUTE_MODIFIERS,
        CRITICAL_HIT,
        ENTITY_TARGET,
        INCOMING_ATTACK_BEFORE,
        INCOMING_ATTACK_DURING,
        INCOMING_ATTACK_AFTER,
        OUTGOING_ATTACK_BEFORE,
        OUTGOING_ATTACK_DURING,
        OUTGOING_ATTACK_AFTER,
        ENTITY_KILL,
        ANIMAL_BREED,
        KEY_INPUT,
        CUSTOM;

    }

    public static enum ListenerState {
        ACTIVE("active"),
        MANUALLY_DISABLED("disabled"),
        DEACTIVATED("deactivated"),
        REGION_LOCKED("region_locked");

        private final String id;

        private ListenerState(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        public static ListenerState fromId(String id) {
            return switch (id) {
                case "disabled" -> MANUALLY_DISABLED;
                case "deactivated" -> DEACTIVATED;
                case "active" -> ACTIVE;
                case "region_locked" -> REGION_LOCKED;
                default -> DEACTIVATED;
            };
        }
    }
}

