/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.library.object.explosion;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.enchantment.ProtectionEnchantment;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.tslat.aoa3.library.object.AllDirections;
import net.tslat.aoa3.library.object.explosion.ExplosionInfo;
import net.tslat.aoa3.library.object.explosion.ExtendedExplosion;
import net.tslat.aoa3.util.EntityUtil;
import org.jetbrains.annotations.Nullable;

public class StandardExplosion
extends ExtendedExplosion {
    protected EnumMap<AllDirections, Float> sectorPenetrationMap;

    public StandardExplosion(ExplosionInfo explosionInfo, ServerLevel level, Entity exploder, Entity indirectExploder) {
        super(explosionInfo, level, exploder, indirectExploder);
    }

    public StandardExplosion(ExplosionInfo explosionInfo, ServerLevel level, Entity exploder) {
        super(explosionInfo, level, exploder);
    }

    public StandardExplosion(ExplosionInfo explosionInfo, ServerLevel level, Entity exploder, Vec3 position) {
        super(explosionInfo, level, exploder, position);
    }

    public StandardExplosion(ExplosionInfo explosionInfo, ServerLevel level, Entity exploder, Entity indirectExploder, Vec3 position) {
        super(explosionInfo, level, exploder, indirectExploder, position);
    }

    public StandardExplosion(ExplosionInfo explosionInfo, ServerLevel level, Entity exploder, double x, double y, double z) {
        super(explosionInfo, level, exploder, x, y, z);
    }

    public StandardExplosion(ExplosionInfo explosionInfo, ServerLevel level, double x, double y, double z) {
        super(explosionInfo, level, x, y, z);
    }

    public StandardExplosion(ExplosionInfo explosionInfo, ServerLevel level, DamageSource damageSource, double x, double y, double z) {
        super(explosionInfo, level, damageSource, x, y, z);
    }

    public StandardExplosion(ExplosionInfo explosionInfo, ServerLevel level, @Nullable Entity exploder, @Nullable Entity indirectExploder, @Nullable DamageSource damageSource, double x, double y, double z) {
        super(explosionInfo, level, exploder, indirectExploder, damageSource, x, y, z);
    }

    @Override
    public int stepsPerTick() {
        return 1000;
    }

    @Override
    protected void doPreExplosionWork() {
        if (this.shouldDamageBlocks()) {
            this.sectorPenetrationMap = new EnumMap(AllDirections.class);
            float penetration = this.info.getPenetrationPower();
            BlockPos originPos = BlockPos.m_274446_((Position)this.origin);
            float originFluidBlastResistance = this.f_46012_.m_6425_(originPos).getExplosionResistance((BlockGetter)this.f_46012_, originPos, (Explosion)this);
            if (originFluidBlastResistance > 0.0f) {
                penetration *= Math.max(0.0f, 0.6f - 0.1f * originFluidBlastResistance / 100.0f);
            }
            for (AllDirections direction : AllDirections.values()) {
                this.sectorPenetrationMap.put(direction, Float.valueOf(penetration * (float)this.random.randomValueBetween(0.5, 1.5)));
            }
        }
    }

    @Override
    protected ObjectArrayList<BlockPos> getAffectedBlocks() {
        if (!this.shouldDamageBlocks()) {
            return new ObjectArrayList();
        }
        ObjectArrayList list = new ObjectArrayList((int)Math.pow(this.info.getEffectiveRadius(), 2.0) * 4);
        this.info.getRadius().ifLeft(radius -> {
            for (int x = -((int)Math.floor(radius.floatValue())); x <= (int)Math.ceil(radius.floatValue()); ++x) {
                for (int y = -((int)Math.floor(radius.floatValue())); y <= (int)Math.ceil(radius.floatValue()); ++y) {
                    for (int z = -((int)Math.floor(radius.floatValue())); z <= (int)Math.ceil(radius.floatValue()); ++z) {
                        BlockPos pos;
                        if (!(((float)x + 0.5f) * ((float)x + 0.5f) + ((float)y + 0.5f) * ((float)y + 0.5f) + ((float)z + 0.5f) * ((float)z + 0.5f) < radius.floatValue() * radius.floatValue()) || !this.f_46012_.m_46739_(pos = BlockPos.m_274561_((double)((double)x + this.origin.f_82479_), (double)((double)y + this.origin.f_82480_), (double)((double)z + this.origin.f_82481_)))) continue;
                        list.add((Object)pos);
                    }
                }
            }
        }).ifRight(squareRadius -> {
            BlockPos originPos = BlockPos.m_274446_((Position)this.origin);
            for (BlockPos pos : BlockPos.m_121940_((BlockPos)originPos.m_121996_(squareRadius.toVec3i()), (BlockPos)originPos.m_121955_(squareRadius.toVec3i()))) {
                if (!this.f_46012_.m_46739_(pos)) continue;
                list.add((Object)pos);
            }
        });
        list.sort(Comparator.comparingDouble(pos -> pos.m_203193_((Position)this.origin)));
        return list;
    }

    @Override
    protected void filterAffectedBlocksAndEntities() {
        BlockPos pos2;
        ObjectListIterator objectListIterator = this.f_46020_.iterator();
        while (objectListIterator.hasNext() && this.doBlockDamage(pos2 = (BlockPos)objectListIterator.next())) {
        }
        this.f_46020_.removeIf(pos -> !this.affectedBlocks.containsKey(pos));
    }

    @Override
    protected void impactEntities() {
        for (Entity entity : this.affectedEntities) {
            if (this.info.isEntityDamaging() || this.info.isKnockbackEntities()) {
                double impactPercent = StandardExplosion.m_46064_((Vec3)this.origin, (Entity)entity);
                if (this.info.isEntityDamaging()) {
                    float distModifier = (float)Math.pow(EntityUtil.getEntityCenter(entity).m_82554_(this.origin), 0.5);
                    float damage = this.info.getBaseDamage() * (1.0f / distModifier);
                    damage *= this.info.calculateEntityDamageModifier(this, entity);
                    damage = (float)((double)damage * impactPercent);
                    damage = Math.min(this.info.getBaseDamage(), damage);
                    entity.m_6469_(this.f_46018_, damage);
                }
                if (this.info.isKnockbackEntities() && entity.m_6094_()) {
                    Vec3 dist = entity.m_20182_().m_82546_(this.origin).m_82541_();
                    double knockback = (double)this.info.getBaseKnockback() * impactPercent;
                    knockback *= (double)this.info.calculateKnockbackModifier(this, entity);
                    if (entity instanceof LivingEntity) {
                        LivingEntity livingEntity = (LivingEntity)entity;
                        knockback = ProtectionEnchantment.m_45135_((LivingEntity)livingEntity, (double)knockback);
                    }
                    dist.m_82542_(knockback, knockback, knockback);
                    entity.m_20256_(entity.m_20184_().m_82549_(dist));
                }
            }
            this.info.entityImpacted(this, entity);
        }
    }

    protected boolean doBlockDamage(BlockPos pos) {
        Vec3 posCenter = Vec3.m_82512_((Vec3i)pos);
        AllDirections sector = AllDirections.byAngle(this.origin.m_82546_(posCenter).m_82541_());
        float sectorPenetration = this.sectorPenetrationMap.get((Object)sector).floatValue();
        if (sectorPenetration <= 0.0f) {
            return true;
        }
        BlockState state = this.f_46012_.m_8055_(pos);
        Optional blastResistance = this.f_46019_.m_6617_((Explosion)this, (BlockGetter)this.f_46012_, pos, state, this.f_46012_.m_6425_(pos));
        if (blastResistance.isEmpty()) {
            return true;
        }
        if (!this.info.shouldAffectBlock(this, state, pos) || !this.f_46019_.m_6714_((Explosion)this, (BlockGetter)this.f_46012_, pos, state, (this.info.getBaseDamage() + this.info.getEffectiveRadius()) / 2.0f)) {
            float remainingPenetration = Math.max(0.0f, sectorPenetration - ((Float)blastResistance.get()).floatValue() / 5.0f);
            this.sectorPenetrationMap.put(sector, Float.valueOf(remainingPenetration));
            if (remainingPenetration > 0.0f) {
                return true;
            }
            for (float value : this.sectorPenetrationMap.values()) {
                if (!(value > 0.0f)) continue;
                return true;
            }
            return false;
        }
        float specificPenetration = sectorPenetration * this.info.calculateBlockDamageModifier(this, state, pos);
        float remainingPenetration = sectorPenetration;
        BlockPos immutablePos = pos.m_7949_();
        if (specificPenetration <= ((Float)blastResistance.get()).floatValue()) {
            if (this.random.fiftyFifty()) {
                remainingPenetration *= 0.5f;
            }
        } else {
            remainingPenetration = sectorPenetration - ((Float)blastResistance.get()).floatValue();
            this.affectedBlocks.put((Object)immutablePos, (Object)state);
        }
        this.sectorPenetrationMap.put(sector, Float.valueOf(Math.max(0.0f, remainingPenetration)));
        if (remainingPenetration > 0.0f) {
            return true;
        }
        for (float value : this.sectorPenetrationMap.values()) {
            if (!(value > 0.0f)) continue;
            return true;
        }
        return false;
    }
}

