/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.library.object.explosion;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.enchantment.ProtectionEnchantment;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.tslat.aoa3.library.object.explosion.ExplosionInfo;
import net.tslat.aoa3.library.object.explosion.ExtendedExplosion;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.ObjectUtil;
import org.jetbrains.annotations.Nullable;

public class ShrapnelExplosion
extends ExtendedExplosion {
    private static final int RAYS_PER_AXIS = 13;
    protected List<Vec3> rays;
    protected final Object2ObjectOpenHashMap<UUID, Pair<Entity, Set<Vec3>>> collatedEntityImpacts = new Object2ObjectOpenHashMap();

    public ShrapnelExplosion(ExplosionInfo explosionInfo, ServerLevel level, Entity exploder, Entity indirectExploder) {
        super(explosionInfo, level, exploder, indirectExploder);
    }

    public ShrapnelExplosion(ExplosionInfo explosionInfo, ServerLevel level, Entity exploder) {
        super(explosionInfo, level, exploder);
    }

    public ShrapnelExplosion(ExplosionInfo explosionInfo, ServerLevel level, Entity exploder, Vec3 position) {
        super(explosionInfo, level, exploder, position);
    }

    public ShrapnelExplosion(ExplosionInfo explosionInfo, ServerLevel level, Entity exploder, Entity indirectExploder, Vec3 position) {
        super(explosionInfo, level, exploder, indirectExploder, position);
    }

    public ShrapnelExplosion(ExplosionInfo explosionInfo, ServerLevel level, Entity exploder, double x, double y, double z) {
        super(explosionInfo, level, exploder, x, y, z);
    }

    public ShrapnelExplosion(ExplosionInfo explosionInfo, ServerLevel level, double x, double y, double z) {
        super(explosionInfo, level, x, y, z);
    }

    public ShrapnelExplosion(ExplosionInfo explosionInfo, ServerLevel level, DamageSource damageSource, double x, double y, double z) {
        super(explosionInfo, level, damageSource, x, y, z);
    }

    public ShrapnelExplosion(ExplosionInfo explosionInfo, ServerLevel level, @Nullable Entity exploder, @Nullable Entity indirectExploder, @Nullable DamageSource damageSource, double x, double y, double z) {
        super(explosionInfo, level, exploder, indirectExploder, damageSource, x, y, z);
    }

    @Override
    public int stepsPerTick() {
        return 1000;
    }

    @Override
    protected void doPreExplosionWork() {
        this.populateRays();
    }

    @Override
    protected void filterAffectedBlocksAndEntities() {
        ObjectOpenHashSet emptyPos = new ObjectOpenHashSet();
        for (Vec3 ray : this.rays) {
            this.doRayTraversal(ray, this.info.getPenetrationPower() * (float)this.random.randomValueBetween((double)0.85f, (double)1.15f), this.shouldDamageBlocks(), (ObjectOpenHashSet<BlockPos>)emptyPos, this.affectedEntities, this.collatedEntityImpacts);
        }
        this.affectedEntities.removeIf(entity -> !this.collatedEntityImpacts.containsKey((Object)entity.m_20148_()));
        this.affectedBlocks.forEach((pos, state) -> this.f_46020_.add(pos));
        this.f_46020_.sort(Comparator.comparingDouble(pos -> pos.m_203193_((Position)this.origin)));
    }

    protected void populateRays() {
        this.rays = new ObjectArrayList((int)Math.pow(13.0, 3.0));
        float angleStep = 0.15384616f;
        for (float x = (float)(-this.random.randomValueBetween(0.95, 1.0)); x <= 1.0f; x += 0.15384616f) {
            for (float y = (float)(-this.random.randomValueBetween(0.95, 1.0)); y <= 1.0f; y += 0.15384616f) {
                for (float z = (float)(-this.random.randomValueBetween(0.95, 1.0)); z <= 1.0f; z += 0.15384616f) {
                    if (!((double)Math.abs(x * y * z) > 5.0E-5)) continue;
                    this.rays.add(new Vec3((double)x, (double)y, (double)z));
                }
            }
        }
        ObjectUtil.fastShuffleList(this.rays);
    }

    protected float doRayTraversal(Vec3 ray, float penetration, boolean blockDamage, ObjectOpenHashSet<BlockPos> emptyPos, List<Entity> nearbyEntities, Object2ObjectOpenHashMap<UUID, Pair<Entity, Set<Vec3>>> entities) {
        float stepDistance = 0.0f;
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        BlockPos lastPos = null;
        while (stepDistance <= this.info.getEffectiveRadius()) {
            Vec3 exactPos = new Vec3(this.origin.f_82479_ + (double)stepDistance * ray.f_82479_, this.origin.f_82480_ + (double)stepDistance * ray.f_82480_, this.origin.f_82481_ + (double)stepDistance * ray.f_82481_);
            stepDistance += 0.33333334f;
            if (pos.m_122169_(exactPos.f_82479_, exactPos.f_82480_, exactPos.f_82481_).equals(lastPos) || emptyPos.contains((Object)pos)) continue;
            if (!this.boundsPredicate.test(exactPos) || !this.f_46012_.m_46739_((BlockPos)pos)) {
                this.checkForEntitiesInRay(ray, exactPos, nearbyEntities, entities);
                return 0.0f;
            }
            BlockPos immutablePos = pos.m_7949_();
            BlockState state = this.f_46012_.m_8055_((BlockPos)pos);
            lastPos = immutablePos;
            if (!this.info.shouldAffectBlock(this, state, (BlockPos)pos)) {
                this.checkForEntitiesInRay(ray, exactPos, nearbyEntities, entities);
                return 0.0f;
            }
            Optional blastResistance = this.f_46019_.m_6617_((Explosion)this, (BlockGetter)this.f_46012_, (BlockPos)pos, state, this.f_46012_.m_6425_((BlockPos)pos));
            if (blastResistance.isEmpty()) {
                emptyPos.add((Object)immutablePos);
                continue;
            }
            if (!blockDamage || !this.f_46019_.m_6714_((Explosion)this, (BlockGetter)this.f_46012_, immutablePos, state, (this.info.getBaseDamage() + this.info.getEffectiveRadius()) / 2.0f)) {
                this.checkForEntitiesInRay(ray, exactPos, nearbyEntities, entities);
                return 0.0f;
            }
            float specificPenetration = penetration * this.info.calculateBlockDamageModifier(this, state, immutablePos);
            float resistance = ((Float)blastResistance.get()).floatValue();
            if (resistance > specificPenetration) {
                this.checkForEntitiesInRay(ray, exactPos, nearbyEntities, entities);
                return 0.0f;
            }
            penetration -= resistance;
            this.affectedBlocks.put((Object)immutablePos, (Object)state);
            emptyPos.add((Object)immutablePos);
        }
        return penetration;
    }

    @Override
    protected void impactEntities() {
        for (Pair pair : this.collatedEntityImpacts.values()) {
            Entity entity = (Entity)pair.getFirst();
            if (this.info.isEntityDamaging()) {
                float distModifier = (float)Math.pow(EntityUtil.getEntityCenter(entity).m_82554_(this.origin), 0.5);
                float damage = this.info.getBaseDamage() * (1.0f / distModifier);
                damage *= this.info.calculateEntityDamageModifier(this, entity);
                damage = (float)((double)damage * (0.5 + (double)((Set)pair.getSecond()).size() * 0.5));
                damage = Math.min(this.info.getBaseDamage(), damage);
                entity.m_6469_(this.f_46018_, damage);
            }
            if (this.info.isKnockbackEntities() && entity.m_6094_()) {
                Vec3 dist = entity.m_20182_().m_82546_(this.origin).m_82541_();
                double knockback = (double)this.info.getBaseKnockback() * (0.5 + (double)((Set)pair.getSecond()).size() * 0.5);
                knockback *= (double)this.info.calculateKnockbackModifier(this, entity);
                if (entity instanceof LivingEntity) {
                    LivingEntity livingEntity = (LivingEntity)entity;
                    knockback = ProtectionEnchantment.m_45135_((LivingEntity)livingEntity, (double)knockback);
                }
                dist.m_82542_(knockback, knockback, knockback);
                entity.m_20256_(entity.m_20184_().m_82549_(dist));
            }
            this.info.entityImpacted(this, entity);
        }
    }

    protected void checkForEntitiesInRay(Vec3 ray, Vec3 rayEndPos, List<Entity> entitiesInBlast, Object2ObjectOpenHashMap<UUID, Pair<Entity, Set<Vec3>>> hitEntityMap) {
        for (Entity entity : entitiesInBlast) {
            Pair collidedRaysForEntity = (Pair)hitEntityMap.get((Object)entity.m_20148_());
            if (collidedRaysForEntity != null && ((Set)collidedRaysForEntity.getSecond()).contains(ray) || !entity.m_20191_().m_82371_(this.origin, rayEndPos).isPresent()) continue;
            if (collidedRaysForEntity == null) {
                collidedRaysForEntity = new Pair((Object)entity, (Object)new ObjectOpenHashSet());
                hitEntityMap.put((Object)entity.m_20148_(), (Object)collidedRaysForEntity);
            }
            ((Set)collidedRaysForEntity.getSecond()).add(ray);
        }
    }
}

