/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.library.object.explosion;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.EntityBasedExplosionDamageCalculator;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.tslat.aoa3.common.registration.AoAGameRules;
import net.tslat.aoa3.library.object.explosion.ExplosionInfo;
import net.tslat.aoa3.scheduling.AoAScheduler;
import net.tslat.aoa3.util.NumberUtil;
import net.tslat.smartbrainlib.util.EntityRetrievalUtil;
import net.tslat.smartbrainlib.util.RandomUtil;

public class ExtendedExplosion
extends Explosion {
    protected final ExplosionInfo info;
    protected final RandomUtil.EasyRandom random = new RandomUtil.EasyRandom();
    protected List<Entity> affectedEntities;
    protected Object2ObjectOpenHashMap<BlockPos, BlockState> affectedBlocks = new Object2ObjectOpenHashMap();
    protected ObjectArrayList<Pair<ItemStack, BlockPos>> blockDrops = new ObjectArrayList();
    @Nullable
    protected Entity indirectExploder;
    protected Vec3 origin;
    protected boolean shouldDamageBlocks = true;
    protected int explodeTick;
    protected Predicate<Vec3> boundsPredicate = null;

    public ExtendedExplosion(ExplosionInfo explosionInfo, ServerLevel level, Entity exploder, Entity indirectExploder) {
        this(explosionInfo, level, exploder, indirectExploder, null, exploder.m_20165_(0.5), exploder.m_20227_(0.5), exploder.m_20246_(0.5));
    }

    public ExtendedExplosion(ExplosionInfo explosionInfo, ServerLevel level, Entity exploder) {
        this(explosionInfo, level, exploder, null, null, exploder.m_20165_(0.5), exploder.m_20227_(0.5), exploder.m_20246_(0.5));
    }

    public ExtendedExplosion(ExplosionInfo explosionInfo, ServerLevel level, Entity exploder, Entity indirectExploder, Vec3 position) {
        this(explosionInfo, level, exploder, indirectExploder, null, position.f_82479_, position.f_82480_, position.f_82481_);
    }

    public ExtendedExplosion(ExplosionInfo explosionInfo, ServerLevel level, Entity exploder, Vec3 position) {
        this(explosionInfo, level, exploder, null, null, position.f_82479_, position.f_82480_, position.f_82481_);
    }

    public ExtendedExplosion(ExplosionInfo explosionInfo, ServerLevel level, Entity exploder, double x, double y, double z) {
        this(explosionInfo, level, exploder, null, null, x, y, z);
    }

    public ExtendedExplosion(ExplosionInfo explosionInfo, ServerLevel level, double x, double y, double z) {
        this(explosionInfo, level, null, null, null, x, y, z);
    }

    public ExtendedExplosion(ExplosionInfo explosionInfo, ServerLevel level, DamageSource damageSource, double x, double y, double z) {
        this(explosionInfo, level, null, null, damageSource, x, y, z);
    }

    public ExtendedExplosion(ExplosionInfo explosionInfo, ServerLevel level, @Nullable Entity exploder, @Nullable Entity indirectExploder, @Nullable DamageSource damageSource, double x, double y, double z) {
        super((Level)level, exploder, damageSource, null, x, y, z, 0.0f, false, Explosion.BlockInteraction.KEEP);
        this.info = explosionInfo;
        this.origin = this.getPosition();
        this.indirectExploder = indirectExploder;
    }

    public ExplosionInfo getExplosionInfo() {
        return this.info;
    }

    public Level getLevel() {
        return this.f_46012_;
    }

    public RandomUtil.EasyRandom rand() {
        return this.random;
    }

    public int getExplodeTick() {
        return this.explodeTick;
    }

    public boolean shouldDamageBlocks() {
        return this.shouldDamageBlocks;
    }

    public int stepsPerTick() {
        return 1000;
    }

    public void m_46061_() {
        this.sanityCheck();
        this.shouldDamageBlocks = this.griefingCheck();
        this.f_46019_ = this.f_46016_ != null ? new EntityBasedExplosionDamageCalculator(this.f_46016_) : new ExplosionDamageCalculator();
        this.f_46012_.m_220400_(this.f_46016_, GameEvent.f_157812_, this.origin);
        this.boundsPredicate = (Predicate)this.info.getRadius().map(radius -> pos -> pos.m_82509_((Position)this.origin, (double)radius.floatValue()), squareRadius -> {
            AABB bounds = squareRadius.inflateAABB(new AABB(this.origin.f_82479_, this.origin.f_82480_, this.origin.f_82481_, this.origin.f_82479_, this.origin.f_82480_, this.origin.f_82481_));
            return arg_0 -> ((AABB)bounds).m_82390_(arg_0);
        });
        this.doPreExplosionWork();
        this.f_46020_ = this.getAffectedBlocks();
        this.affectedEntities = this.getAffectedEntities();
        this.filterAffectedBlocksAndEntities();
        ForgeEventFactory.onExplosionDetonate((Level)this.f_46012_, (Explosion)this, this.affectedEntities, (double)((this.info.getBaseDamage() + this.info.getEffectiveRadius()) / 2.0f));
        this.f_46012_.m_6263_(null, this.origin.f_82479_, this.origin.f_82480_, this.origin.f_82481_, this.info.getExplosionSound(), SoundSource.BLOCKS, 4.0f, (1.0f + (this.f_46012_.f_46441_.m_188501_() - this.f_46012_.f_46441_.m_188501_()) * 0.2f) * 0.7f);
        if (this.info.isSingleTickExplosion()) {
            this.info.doParticles(this, -1);
            for (BlockPos pos : this.f_46020_) {
                BlockState state = (BlockState)this.affectedBlocks.get((Object)pos);
                if (state == null) continue;
                this.captureDropsForBlock(state, pos, this.blockDrops);
                state.onBlockExploded(this.f_46012_, pos, (Explosion)this);
                this.info.blockBroken(this, state, pos);
            }
            this.impactEntities();
            this.finishExplosion();
        } else {
            this.doExplosionTick(this.stepsPerTick());
        }
    }

    protected void sanityCheck() {
        if (!NumberUtil.numberIsBetween(this.info.getEffectiveRadius(), 0.0, 256.0)) {
            throw new IllegalArgumentException("Invalid radius provided, must be between 1 and 255 blocks (inclusive)");
        }
        if (!(this.info.isBlockDamaging() || this.info.isEntityDamaging() || this.info.isKnockbackEntities())) {
            throw new IllegalArgumentException("Provided ExplosionInfo has all functional effects disabled. What are you even doing?");
        }
    }

    protected void doPreExplosionWork() {
    }

    protected boolean griefingCheck() {
        if (!this.info.isBlockDamaging()) {
            return false;
        }
        if (this.indirectExploder != null) {
            if (this.indirectExploder instanceof Player) {
                return AoAGameRules.checkDestructiveWeaponPhysics(this.f_46012_);
            }
            return ForgeEventFactory.getMobGriefingEvent((Level)this.f_46012_, (Entity)this.indirectExploder);
        }
        if (this.f_46016_ != null) {
            OwnableEntity ownable;
            if (this.f_46016_ instanceof Player) {
                return AoAGameRules.checkDestructiveWeaponPhysics(this.f_46012_);
            }
            Entity entity = this.f_46016_;
            if (entity instanceof OwnableEntity && (ownable = (OwnableEntity)entity).m_269323_() instanceof Player) {
                return AoAGameRules.checkDestructiveWeaponPhysics(this.f_46012_);
            }
            return ForgeEventFactory.getMobGriefingEvent((Level)this.f_46012_, (Entity)this.f_46016_);
        }
        return true;
    }

    protected ObjectArrayList<BlockPos> getAffectedBlocks() {
        return new ObjectArrayList();
    }

    protected List<Entity> getAffectedEntities() {
        Predicate<Entity> predicate = this.info.getAffectsOwner() ? entity -> !entity.m_6128_() && this.info.shouldAffectEntity(this, (Entity)entity) : entity -> entity != this.f_46016_ && entity != this.indirectExploder && !entity.m_6128_() && this.info.shouldAffectEntity(this, (Entity)entity);
        return (List)this.info.getRadius().map(radius -> EntityRetrievalUtil.getEntities((Level)this.f_46012_, (AABB)AABB.m_165882_((Vec3)this.origin, (double)(radius.floatValue() * 2.0f), (double)(radius.floatValue() * 2.0f), (double)(radius.floatValue() * 2.0f)), (Predicate)predicate), squareRadius -> EntityRetrievalUtil.getEntities((Level)this.f_46012_, (AABB)squareRadius.inflateAABB(new AABB(this.origin.f_82479_, this.origin.f_82480_, this.origin.f_82481_, this.origin.f_82479_, this.origin.f_82480_, this.origin.f_82481_)), (Predicate)predicate));
    }

    protected void filterAffectedBlocksAndEntities() {
    }

    protected void finishExplosion() {
        this.spawnDrops((List<Pair<ItemStack, BlockPos>>)this.blockDrops);
        this.info.postExplosionCallback(this);
    }

    protected void doExplosionTick(int steps) {
        this.info.doParticles(this, this.explodeTick);
        if (this.shouldDamageBlocks()) {
            int step = 0;
            ObjectListIterator iterator = this.f_46020_.iterator();
            while (step++ <= steps && iterator.hasNext()) {
                BlockPos pos = (BlockPos)iterator.next();
                BlockState state = (BlockState)this.affectedBlocks.get((Object)pos);
                this.captureDropsForBlock(state, pos, this.blockDrops);
                state.onBlockExploded(this.f_46012_, pos, (Explosion)this);
                this.info.blockBroken(this, state, pos);
                iterator.remove();
            }
            if (this.explodeTick++ < 600 && !this.f_46020_.isEmpty()) {
                AoAScheduler.scheduleSyncronisedTask(() -> this.doExplosionTick(steps), 1);
                return;
            }
        }
        this.impactEntities();
        this.finishExplosion();
    }

    protected void impactEntities() {
    }

    protected void captureDropsForBlock(BlockState state, BlockPos pos, ObjectArrayList<Pair<ItemStack, BlockPos>> loot) {
        if (state.canDropFromExplosion((BlockGetter)this.f_46012_, pos, (Explosion)this) && RandomUtil.percentChance((double)this.info.getBlockDropChance())) {
            ServerLevel serverLevel = (ServerLevel)this.f_46012_;
            LootContext.Builder lootContext = new LootContext.Builder(serverLevel).m_230911_(this.f_46012_.f_46441_).m_78972_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)pos)).m_78972_(LootContextParams.f_81463_, (Object)ItemStack.f_41583_).m_78972_(LootContextParams.f_81464_, (Object)Float.valueOf((this.info.getBaseDamage() + this.info.getEffectiveRadius()) / 2.0f)).m_78984_(LootContextParams.f_81462_, state.m_155947_() ? this.f_46012_.m_7702_(pos) : null).m_78984_(LootContextParams.f_81455_, (Object)this.f_46016_);
            state.m_222967_(serverLevel, pos, ItemStack.f_41583_, this.f_46016_ instanceof Player || this.indirectExploder instanceof Player);
            state.m_60724_(lootContext).forEach(stack -> ExtendedExplosion.m_46067_((ObjectArrayList)loot, (ItemStack)stack, (BlockPos)pos));
        }
    }

    protected void spawnDrops(List<Pair<ItemStack, BlockPos>> loot) {
        for (Pair<ItemStack, BlockPos> lootDrop : loot) {
            Block.m_49840_((Level)this.f_46012_, (BlockPos)((BlockPos)lootDrop.getSecond()), (ItemStack)((ItemStack)lootDrop.getFirst()));
        }
    }
}

