/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.library.object;

import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.common.capabilities.CapabilityProvider;

public class EntityDataHolder<T> {
    private final EntityDataAccessor<T> key;
    private final T defaultValue;
    private final Function<Entity, T> getter;
    private final BiConsumer<Entity, T> setter;

    private EntityDataHolder(EntityDataAccessor<T> key, T defaultValue, Function<Entity, T> getter, BiConsumer<Entity, T> setter) {
        this.key = key;
        this.defaultValue = defaultValue;
        this.getter = getter;
        this.setter = setter;
    }

    public static <E extends Entity, T> EntityDataHolder<T> register(Class<E> clazz, EntityDataSerializer<T> serializer, T defaultValue, Function<E, T> getter, BiConsumer<E, T> setter) {
        return new EntityDataHolder<T>(EntityDataHolder.register(clazz, serializer), defaultValue, getter, setter);
    }

    public void defineDefault(Entity entity) {
        entity.m_20088_().m_135372_(this.key, this.defaultValue);
    }

    public boolean checkSync(Entity entity, EntityDataAccessor<?> updatedKey) {
        if (this.key.equals(updatedKey)) {
            this.setter.accept(entity, (Entity)entity.m_20088_().m_135370_(this.key));
            return true;
        }
        return false;
    }

    public T get(Entity entity) {
        return this.getter.apply(entity);
    }

    public void setRaw(Entity entity, T value) {
        entity.m_20088_().m_135381_(this.key, value);
    }

    public void set(Entity entity, T value) {
        this.setRaw(entity, value);
        this.setter.accept(entity, (Entity)value);
    }

    public T defaultValue() {
        return this.defaultValue;
    }

    public boolean is(Entity entity, @Nonnull T value) {
        return value.equals(this.get(entity));
    }

    public boolean isAny(Entity entity, T ... values) {
        T value = this.get(entity);
        for (T val : values) {
            if (!val.equals(value)) continue;
            return true;
        }
        return false;
    }

    private static <T> EntityDataAccessor<T> register(Class<? extends Entity> clazz, EntityDataSerializer<T> serializer) {
        int id = 0;
        if (SynchedEntityData.f_135343_.containsKey(clazz)) {
            id = SynchedEntityData.f_135343_.getInt(clazz) + 1;
        } else {
            for (Class<? extends Entity> parentClass = clazz.getSuperclass(); parentClass != CapabilityProvider.class; parentClass = parentClass.getSuperclass()) {
                if (!SynchedEntityData.f_135343_.containsKey(parentClass)) continue;
                id = SynchedEntityData.f_135343_.getInt(parentClass) + 1;
                break;
            }
        }
        if (id >= 255) {
            throw new IllegalArgumentException("Too many data parameters registered for " + clazz + "!. Max is 254");
        }
        SynchedEntityData.f_135343_.put(clazz, id);
        return serializer.m_135021_(id);
    }
}

