/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.library.object;

import java.util.function.Function;
import javax.annotation.Nonnull;

public interface CachedFunction<T, R>
extends Function<T, R> {
    public static <T, R> CachedFunction<T, R> of(@Nonnull Function<T, R> function) {
        return new Impl<T, R>(function);
    }

    public static final class Impl<T, R>
    implements CachedFunction<T, R> {
        private Function<T, R> function;
        private R cached = null;

        private Impl(Function<T, R> function) {
            this.function = function;
        }

        @Override
        public R apply(T t) {
            if (this.cached != null) {
                return this.cached;
            }
            this.cached = this.function.apply(t);
            this.function = null;
            return this.cached;
        }
    }
}

